/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import com.sas.graphics.util.j2d.Viewport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Stack;

class JLine
implements Drawable {
    Point3 loc1;
    Point3 loc2;
    Point3 dscr1;
    Point3 dscr2;
    boolean clip;
    Stack namelist;
    boolean pickable;
    boolean optimized;
    static Point3 p1 = new Point3(0.0, 0.0, 1.0);
    static Point3 p2 = new Point3(0.0, 0.0, 1.0);
    static int[] xpoints = new int[6];
    static int[] ypoints = new int[6];
    static final Color dark = Color.darkGray;
    static final Color light = new Color(222, 222, 222);
    boolean border;
    Color borderColor;
    Color color;
    Polygon screen;
    boolean clean = false;
    int lineWidth;
    int[] stipplePattern;
    ChannelLite channel = null;

    JLine(StateLite state, double x1, double y1, double x2, double y2, boolean flag) {
        this(state, x1, y1, x2, y2);
        this.border = flag;
        if (!this.pickable && this.border) {
            int[] xpoints = new int[4];
            int[] ypoints = new int[4];
            this.screen = new Polygon(xpoints, ypoints, 4);
        }
    }

    JLine(StateLite state, double x1, double y1, double x2, double y2) {
        ChannelLite ch = this.channel = state.ch;
        TransInfo tr = ch.trans;
        this.clip = false;
        this.namelist = state.namelist;
        this.pickable = state.capabilities[0];
        this.pickable &= state.capabilities[1];
        this.lineWidth = state.lineWidth;
        if (this.pickable) {
            int[] xpoints = new int[4];
            int[] ypoints = new int[4];
            this.screen = new Polygon(xpoints, ypoints, 4);
        }
        this.loc1 = new Point3(x1, y1, 1.0);
        this.loc2 = new Point3(x2, y2, 1.0);
        boolean bl = this.optimized = state.render_mode == 3;
        if (this.optimized) {
            this.loc1.postMultiply(tr.w2m);
            this.loc2.postMultiply(tr.w2m);
        }
        this.stipplePattern = (int[])(ch.state.capabilities[7] ? (int[])ch.state.stipplePattern.clone() : null);
        this.border = false;
        this.borderColor = state.edgecolor;
        this.color = state.color;
        this.dscr1 = new Point3(0.0, 0.0, 1.0);
        this.dscr2 = new Point3(0.0, 0.0, 1.0);
        if (state.render_mode >= 3) {
            state.displaylist.addElement(this);
        } else if (state.render_mode == 0) {
            Graphics bgc = ch.getBackbufferGC();
            this.computeScreen(ch);
            this.render(state, bgc);
            ch.glRefresh();
        }
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        StateLite state = ch.state;
        TransInfo tr = ch.trans;
        this.clip = false;
        this.clean = false;
        Polygon myscreen = this.screen;
        Viewport view = tr.GetViewport();
        double lens = state.lensFactor;
        double thetaLens = tr.getRadialFactor(state.thetaLensFac);
        if (state.dirtyLensFlag) {
            view.computeLogR(lens);
            state.dirtyLensFlag = false;
        }
        Point3 lensOrgLoc = tr.getLensOriginalLocation(state.thetaLensFac);
        Point3 tpnt = new Point3();
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                tpnt.copy(this.loc1);
            } else {
                tpnt.copy(this.loc2);
            }
            if (state.capabilities[2]) {
                if (state.capabilities[3] && tr.moved) {
                    JPolygon.angularDistortion(tpnt, tr.movingDir, thetaLens, state.minAngle, state.maxAngle);
                }
                if (this.optimized) {
                    tr.Model2Screen(tpnt);
                } else {
                    tr.World2Screen(tpnt);
                }
                if (state.lensDirection == 6) {
                    JPolygon.verticalDistortion(tpnt, view, tr, state.lensFactor, state.lensScreenAreaPercentage, state);
                } else if (state.lensDirection == 0) {
                    JPolygon.radialDistortion(tpnt, lensOrgLoc, view, tr.movingDir, state.lensFactor);
                } else {
                    JPolygon.conalDistortion(tpnt, lensOrgLoc, view, tr.movingDir, state.lensFactor, state.lensDirection);
                }
            } else if (this.optimized) {
                tr.Model2Screen(tpnt);
            } else {
                tr.World2Screen(tpnt);
            }
            if (i == 0) {
                this.dscr1.x = tpnt.x;
                this.dscr1.y = tpnt.y;
            } else {
                this.dscr2.x = tpnt.x;
                this.dscr2.y = tpnt.y;
            }
            myscreen.xpoints[i] = (int)tpnt.x;
            myscreen.ypoints[i] = (int)tpnt.y;
        }
        if (this.pickable || this.border) {
            JPolygon.makeWideLine(state, this.screen.xpoints, this.screen.ypoints, this.dscr1.x, this.dscr1.y, this.dscr2.x, this.dscr2.y, this.lineWidth + 1);
        }
        return !this.clip;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        if (this.clip) {
            return false;
        }
        bgc.setColor(this.color);
        if (state.capabilities[8]) {
            double[] dscrx = new double[]{this.dscr2.x, this.dscr2.x, this.dscr1.x, this.dscr1.x};
            double[] dscry = new double[]{this.dscr2.y, (this.dscr2.y + this.dscr1.y) / 2.0, (this.dscr2.y + this.dscr1.y) / 2.0, this.dscr1.y};
            if (this.stipplePattern != null) {
                state.stippleHistory[1] = 0;
                state.stippleHistory[0] = 0;
                for (int i = 0; i < 3; ++i) {
                    JPolygon.stipple(state, bgc, this.stipplePattern, state.stippleHistory, dscrx[i], dscry[i], dscrx[i + 1], dscry[i + 1], this.lineWidth);
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    JPolygon.drawSegment(state, bgc, dscrx[i], dscry[i], dscrx[i + 1], dscry[i + 1], this.lineWidth);
                }
            }
        } else if (this.stipplePattern != null) {
            state.stippleHistory[1] = 0;
            state.stippleHistory[0] = 0;
            JPolygon.stipple(state, bgc, this.stipplePattern, state.stippleHistory, this.dscr1.x, this.dscr1.y, this.dscr2.x, this.dscr2.y, this.lineWidth);
        } else {
            JPolygon.drawSegment(state, bgc, this.dscr1.x, this.dscr1.y, this.dscr2.x, this.dscr2.y, this.lineWidth);
            if (this.border) {
                bgc.setColor(this.borderColor);
                JPolygon.makeWideLine(state, state.wideLineX, state.wideLineY, this.dscr1.x, this.dscr1.y, this.dscr2.x, this.dscr2.y, this.lineWidth + 2);
                bgc.drawPolygon(this.screen.xpoints, this.screen.ypoints, 4);
            }
        }
        return true;
    }

    @Override
    public Stack getNameList() {
        return this.namelist;
    }

    @Override
    public boolean pick(Graphics bgc, Rectangle pickmatrix) {
        if (this.clip || !this.pickable) {
            return false;
        }
        return this.intersects(pickmatrix);
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        if (this.clip || !this.pickable) {
            return false;
        }
        return this.intersects(pickmatrix);
    }

    final boolean intersects(Rectangle r) {
        if (!this.clean) {
            this.screen = new Polygon(this.screen.xpoints, this.screen.ypoints, this.screen.npoints);
            this.clean = true;
        }
        if (!this.channel.getPickFullLine()) {
            if (r.contains(this.screen.xpoints[0], this.screen.ypoints[0]) || r.contains(this.screen.xpoints[this.screen.xpoints.length - 2], this.screen.ypoints[this.screen.ypoints.length - 2])) {
                return true;
            }
        } else {
            Rectangle bbox = this.screen.getBounds();
            if (bbox.intersects(r)) {
                int xx = r.x;
                int yy = r.y;
                int dx = xx + r.width;
                int dy = yy + r.height;
                for (int ix = xx; ix < dx; ++ix) {
                    for (int iy = yy; iy < dy; ++iy) {
                        if (!this.screen.contains(ix, iy)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean isClipped() {
        return this.clip;
    }

    void drawSegment(StateLite state, Graphics gc, double x1, double y1, double x2, double y2) {
        if (this.lineWidth <= 1) {
            if (x1 < -32768.0 || x1 > 32767.0 || x2 < -32768.0 || x2 > 32767.0) {
                return;
            }
            gc.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        } else {
            JPolygon.makeWideLine(state, state.wideLineX, state.wideLineY, x1, y1, x2, y2, this.lineWidth);
            gc.fillPolygon(state.wideLineX, state.wideLineY, state.wideLineX.length);
            if (state.capStyle == 1) {
                double halfWidth = (double)this.lineWidth / 2.0 - 0.5;
                gc.fillOval((int)(x1 - halfWidth), (int)(y1 - halfWidth), this.lineWidth, this.lineWidth);
                gc.fillOval((int)(x2 - halfWidth), (int)(y2 - halfWidth), this.lineWidth, this.lineWidth);
            }
        }
    }
}

