/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.Drawable;
import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import com.sas.graphics.util.j2d.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.util.Stack;
import java.util.Vector;

public class CompositeTextRectangle
implements Drawable {
    Color color;
    Font font;
    Point3 loc;
    Point3 dscr;
    boolean clip;
    Stack namelist;
    boolean pickable;
    boolean optimized;
    boolean handle;
    static Point3 p1 = new Point3(0.0, 0.0, 1.0);
    static Point3 p2 = new Point3(0.0, 0.0, 1.0);
    boolean border;
    int borderType;
    Color borderColor;
    Color lineColor;
    Color handleColor;
    protected double bkgdHeight = 1.0;
    protected double bkgdWidth = 1.0;
    protected Color bkgdColor;
    Color textColor;
    int borderWidth;
    Rectangle bbox;
    private static char newline = (char)10;
    private static final int multiLineOffsetIndex = 7;
    private Vector string;
    private int[] textWidth;
    private int maxTextWidth;
    private int textLines;
    private StateLite state;
    private Point3 uc;
    private Point3 lc;
    private Point3 cl;
    private Point3 cr;
    private Point3 wloc;
    private Point3 ucscr;
    private Point3 lcscr;
    private Point3 clscr;
    private Point3 crscr;
    int x;
    int y;
    int width;
    int height;
    private final int MAX_ICON_WIDTH = 24;
    private final int MAX_ICON_HEIGHT = 24;
    private Image icon = null;
    private boolean selected = false;
    private Color selectColor = Color.black;
    private int maxNumLines = 5;
    private int iconPad = 4;
    public static final int TEXT_PAD = 4;
    private int roundingDiameter = 8;
    private boolean drawIcon = true;
    private boolean inFocus = false;

    CompositeTextRectangle(StateLite state, String str, double x, double y, double width, double height, Image icon) {
        this.state = state;
        ChannelLite ch = state.ch;
        TransInfo tr = ch.trans;
        this.font = new Font("SansSerif", 0, 12);
        this.clip = false;
        this.pickable = false;
        this.handleColor = state.textHandleColor;
        this.wloc = new Point3(x, y, 1.0);
        this.loc = new Point3(x, y, 1.0);
        boolean bl = this.optimized = state.render_mode == 3;
        if (this.optimized) {
            this.loc.postMultiply(tr.w2m);
        }
        this.string = CompositeTextRectangle.makeMultiLine(str);
        this.textLines = this.string.size();
        this.textWidth = null;
        this.color = state.color;
        this.border = state.border;
        this.borderType = state.textBorderType;
        this.borderColor = state.textBorderColor;
        this.lineColor = state.textLineColor;
        this.textColor = state.textColor;
        this.dscr = new Point3(0.0, 0.0, 1.0);
        this.bbox = new Rectangle();
        if (state.render_mode >= 3) {
            state.displaylist.addElement(this);
        } else if (state.render_mode == 0) {
            Graphics bgc = ch.getBackbufferGC();
            this.computeScreen(ch);
            this.render(state, bgc);
            ch.glRefresh();
        }
        this.ucscr = new Point3();
        this.lcscr = new Point3();
        this.clscr = new Point3();
        this.crscr = new Point3();
        this.bkgdWidth = width;
        this.bkgdHeight = height;
        this._setBackgroundWidth(width);
        this._setBackgroundHeight(height);
        this.x = (int)(x + 0.5);
        this.y = (int)(y + 0.5);
        this.width = (int)(width + 0.5);
        this.height = (int)(height + 0.5);
        this.icon = icon;
    }

    @Override
    public boolean computeScreen(ChannelLite ch) {
        String label = this.string.elementAt(0).toString();
        StateLite state = ch.getState();
        if (state.render_mode == 1) {
            return !this.clip;
        }
        this.clip = false;
        TransInfo tr = ch.trans;
        this.dscr.copy(this.loc);
        boolean fixedHeight = false;
        boolean fixedWidth = false;
        if (this.bkgdHeight != -1.0) {
            this.ucscr.copy(this.uc);
            this.lcscr.copy(this.lc);
            fixedHeight = true;
        }
        if (this.bkgdWidth != -1.0 && this.bkgdWidth < 1.0) {
            this.clscr.copy(this.cl);
            this.crscr.copy(this.cr);
            fixedWidth = true;
        }
        if (state.capabilities[2]) {
            int fnHeight;
            Viewport view = tr.GetViewport();
            double lens = state.lensFactor;
            double thetaLens = tr.getRadialFactor(state.thetaLensFac);
            if (state.dirtyLensFlag) {
                view.computeLogR(lens);
                state.dirtyLensFlag = false;
            }
            Point3 lensOrgLoc = tr.getLensOriginalLocation(state.thetaLensFac);
            double tfac = 0.0;
            if (state.capabilities[3] && tr.moved) {
                tfac = JPolygon.angularDistortion(this.dscr, tr.movingDir, thetaLens, state.minAngle, state.maxAngle);
            }
            if (this.optimized) {
                tr.Model2Screen(this.dscr);
                if (fixedHeight) {
                    tr.Model2Screen(this.ucscr);
                    tr.Model2Screen(this.lcscr);
                }
                if (fixedWidth) {
                    tr.Model2Screen(this.clscr);
                    tr.Model2Screen(this.crscr);
                }
            } else {
                tr.World2Screen(this.dscr);
                if (fixedHeight) {
                    tr.World2Screen(this.ucscr);
                    tr.World2Screen(this.lcscr);
                }
                if (fixedWidth) {
                    tr.World2Screen(this.clscr);
                    tr.World2Screen(this.crscr);
                }
            }
            double rfac = 0.5;
            if (state.lensDirection == 6) {
                rfac = JPolygon.verticalDistortion(this.dscr, view, tr, state.lensFactor, state.lensScreenAreaPercentage, state);
                if (fixedWidth) {
                    JPolygon.verticalDistortion(this.clscr, view, tr, state.lensFactor, state.lensScreenAreaPercentage, state);
                    JPolygon.verticalDistortion(this.crscr, view, tr, state.lensFactor, state.lensScreenAreaPercentage, state);
                }
                if (fixedHeight) {
                    JPolygon.verticalDistortion(this.ucscr, view, tr, state.lensFactor, state.lensScreenAreaPercentage, state);
                    JPolygon.verticalDistortion(this.lcscr, view, tr, state.lensFactor, state.lensScreenAreaPercentage, state);
                }
                double[] cutoffs = tr.cutoffs;
                double[] range = tr.lensRange;
                int index = 0;
                while (this.dscr.y > range[index]) {
                    ++index;
                }
            }
            int n = fnHeight = this.font == null ? 12 : Toolkit.getDefaultToolkit().getFontMetrics(this.font).getHeight();
            if (fixedWidth) {
                this.bbox.x = (int)this.clscr.x;
                this.bbox.width = (int)(this.crscr.x - this.clscr.x);
            } else if (this.bkgdWidth > 1.0) {
                this.bbox.x = (int)(this.dscr.x - this.bkgdWidth / 2.0);
                this.bbox.width = (int)this.bkgdWidth;
            }
            if (fixedHeight) {
                this.bbox.y = (int)this.lcscr.y;
                this.bbox.height = (int)(this.ucscr.y - this.lcscr.y);
            }
        } else if (this.optimized) {
            tr.Model2Screen(this.dscr);
            if (fixedHeight) {
                tr.Model2Screen(this.ucscr);
                tr.Model2Screen(this.lcscr);
            }
            if (fixedWidth) {
                tr.Model2Screen(this.clscr);
                tr.Model2Screen(this.crscr);
            }
        } else {
            tr.World2Screen(this.dscr);
            if (fixedHeight) {
                tr.World2Screen(this.ucscr);
                tr.World2Screen(this.lcscr);
            }
            if (fixedWidth) {
                tr.World2Screen(this.clscr);
                tr.World2Screen(this.crscr);
            }
        }
        if (fixedWidth) {
            this.dscr.x = (this.clscr.x + this.crscr.x) / 2.0;
        }
        if (fixedHeight) {
            this.dscr.y = (this.ucscr.y + this.lcscr.y) / 2.0;
        }
        return !this.clip;
    }

    @Override
    public boolean render(StateLite state, Graphics bgc) {
        if (this.clip) {
            return false;
        }
        if (this.font != null) {
            bgc.setFont(this.font);
        }
        Font fn = bgc.getFont();
        FontMetrics fm = bgc.getFontMetrics();
        int[] info = this.computeAlignmentInfo(state, bgc, (int)this.dscr.x, (int)this.dscr.y, this.handle);
        int yPad = state.capabilities[2] && state.lensDirection == 6 ? (int)Math.max(1.0, this.bkgdHeight / 2.0) : 1;
        this.bbox.x = info[0] - 2 - 24 - 4;
        this.bbox.width = this.width;
        this.bbox.y = info[4] - yPad - 4;
        this.bbox.height = this.height;
        int xoffset = 0;
        int yoffset = 0;
        bgc.setColor(Color.white);
        bgc.fillRoundRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, this.roundingDiameter, this.roundingDiameter);
        xoffset = this.drawIcon ? 24 + 2 * this.iconPad : 0;
        yoffset = 0;
        bgc.setColor(this.color);
        bgc.fillRect(this.bbox.x + xoffset + 1, this.bbox.y + yoffset, this.roundingDiameter, this.height - yoffset + 1);
        bgc.setColor(Color.white);
        bgc.fillRoundRect(this.bbox.x + xoffset + 1, this.bbox.y + yoffset, this.width - xoffset, this.height - yoffset + 1, this.roundingDiameter, this.roundingDiameter);
        bgc.setColor(this.color);
        bgc.fillRoundRect(this.bbox.x + xoffset + 1, this.bbox.y + yoffset, this.width - xoffset, this.height - yoffset + 1, this.roundingDiameter, this.roundingDiameter);
        xoffset = this.drawIcon ? 24 + 2 * this.iconPad + 4 : 4;
        yoffset = 4;
        int textAreaWidth = this.width - xoffset - 4 + 1;
        bgc.setColor(this.textColor);
        String thisLine = null;
        int limit = this.maxNumLines;
        if (this.textLines > this.maxNumLines) {
            limit = this.maxNumLines - 1;
        }
        for (int i = 0; i < this.textLines && i < this.maxNumLines; ++i) {
            yoffset += fm.getAscent();
            if (i == 0) {
                yoffset -= 2;
            }
            thisLine = (String)this.string.elementAt(i);
            boolean stringChopped = false;
            while (thisLine.length() > 0 && fm.stringWidth(thisLine) > textAreaWidth) {
                thisLine = thisLine.substring(0, thisLine.length() - 1);
                stringChopped = true;
            }
            if (stringChopped && thisLine.length() > 3) {
                thisLine = thisLine.substring(0, thisLine.length() - 3) + "...";
            }
            if (i == limit) {
                thisLine = "...";
                xoffset = xoffset + textAreaWidth / 2 - 5;
            }
            bgc.drawString(thisLine, this.bbox.x + xoffset + 1, this.bbox.y + yoffset);
        }
        if (this.drawIcon) {
            if (this.icon != null) {
                int iw = this.icon.getWidth(null);
                int ih = this.icon.getHeight(null);
                if (iw <= 24 && ih <= 24) {
                    xoffset = (24 - iw) / 2;
                    yoffset = (24 - ih) / 2;
                    bgc.drawImage(this.icon, this.bbox.x + xoffset + this.iconPad, this.bbox.y + yoffset + this.iconPad, null);
                }
            }
            xoffset = 24 + 2 * this.iconPad;
            ColorSpace rgb = ColorSpace.getInstance(1000);
            bgc.setColor(new Color(rgb, this.borderColor.getColorComponents(rgb, null), 0.7f));
            bgc.drawLine(this.bbox.x + xoffset, this.bbox.y, this.bbox.x + xoffset, this.bbox.y + this.height);
        }
        bgc.setColor(this.borderColor);
        bgc.drawRoundRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, this.roundingDiameter, this.roundingDiameter);
        if (this.selected) {
            Stroke savedStroke = null;
            Graphics2D g2 = null;
            if (bgc instanceof Graphics2D) {
                g2 = (Graphics2D)bgc;
                savedStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(2.0f, 2, 2));
            }
            bgc.setColor(this.selectColor);
            bgc.drawRoundRect(this.bbox.x - 1, this.bbox.y - 1, this.width + 2, this.height + 2, this.roundingDiameter, this.roundingDiameter);
            if (g2 != null) {
                g2.setStroke(savedStroke);
            }
        }
        Color focusColor = Color.DARK_GRAY;
        int gap = 2;
        if (this.inFocus) {
            Stroke savedStroke = null;
            Graphics2D g2 = null;
            if (bgc instanceof Graphics2D) {
                g2 = (Graphics2D)bgc;
                savedStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{3.0f}, 0.0f));
            }
            bgc.setColor(focusColor);
            bgc.drawRoundRect(this.bbox.x - gap, this.bbox.y - gap, this.width + 2 * gap, this.height + 2 * gap, this.roundingDiameter, this.roundingDiameter);
            if (g2 != null) {
                g2.setStroke(savedStroke);
            }
        }
        return true;
    }

    @Override
    public Stack getNameList() {
        return this.namelist;
    }

    @Override
    public boolean pick(Graphics bgc, Rectangle pickmatrix) {
        if (this.clip || !this.pickable) {
            return false;
        }
        return pickmatrix.intersects(this.bbox);
    }

    @Override
    public boolean pickInRevOrder(Graphics gc, Rectangle pickmatrix) {
        if (this.clip || !this.pickable) {
            return false;
        }
        return pickmatrix.intersects(this.bbox);
    }

    @Override
    public boolean isClipped() {
        return this.clip;
    }

    void setBorderFlag(boolean flag) {
        this.border = flag;
    }

    void setBorderType(int type) {
        this.borderType = type;
    }

    public void setBorderColor(Color clr) {
        this.borderColor = clr;
    }

    public void setColor(Color clr) {
        this.color = clr;
    }

    public void setLineColor(Color clr) {
        this.lineColor = clr;
    }

    Color getLineColor() {
        return this.lineColor;
    }

    Point3 getLocation() {
        return this.dscr;
    }

    private static Vector makeMultiLine(String text) {
        int nlIndex = 0;
        Vector<String> multiLine = new Vector<String>();
        if (text != null && text.length() > 0) {
            int i = 0;
            while (nlIndex >= 0) {
                nlIndex = text.indexOf(newline, i);
                String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                multiLine.addElement(line);
                i = 1 + nlIndex;
            }
        }
        return multiLine;
    }

    private static int[] getInfoBuffer(StateLite state, int lineCount) {
        int infoLength = 7 + lineCount;
        if (state.tempRasterInfo == null || state.tempRasterInfo.length < infoLength) {
            state.tempRasterInfo = new int[infoLength];
        }
        return state.tempRasterInfo;
    }

    private static int computeWidths(Vector string, int[] widths, FontMetrics fm) {
        int max = Integer.MIN_VALUE;
        int lineCount = string.size();
        if (widths == null) {
            widths = new int[lineCount];
        }
        for (int i = 0; i < lineCount; ++i) {
            widths[i] = fm.stringWidth((String)string.elementAt(i));
            max = Math.max(max, widths[i]);
        }
        return max;
    }

    protected int[] computeAlignmentInfo(StateLite state, Graphics gc, int x, int y, boolean handle) {
        gc.setFont(this.font);
        FontMetrics fm = gc.getFontMetrics();
        if (this.textWidth == null || state.capabilities[2]) {
            this.textWidth = new int[this.textLines];
            this.maxTextWidth = CompositeTextRectangle.computeWidths(this.string, this.textWidth, fm);
        }
        this.maxTextWidth = this.width - 24 - 20;
        int[] alignInfo = CompositeTextRectangle.getInfoBuffer(state, this.textLines);
        int hnwidth = 0;
        if (handle) {
            hnwidth = fm.stringWidth(" + ");
        }
        this.maxTextWidth += hnwidth;
        this.computeAlignmentInfo(alignInfo, this.textWidth, this.maxTextWidth, this.string.size(), fm, 1, 1, hnwidth, x, y);
        return alignInfo;
    }

    int[] computeAlignmentInfo(StateLite state, Graphics gc, Vector string, Font font, int halign, int valign, boolean handle, int x, int y) {
        int lineCount = string.size();
        int[] textWidth = state.tempTextWidth;
        if (textWidth == null || textWidth.length < lineCount) {
            textWidth = state.tempTextWidth = new int[lineCount];
        }
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        int maxTextWidth = CompositeTextRectangle.computeWidths(string, textWidth, fm);
        int hnwidth = 0;
        if (handle) {
            hnwidth = fm.stringWidth(" + ");
        }
        int[] info = CompositeTextRectangle.getInfoBuffer(state, lineCount);
        this.computeAlignmentInfo(info, textWidth, maxTextWidth += hnwidth, string.size(), fm, halign, valign, hnwidth, x, y);
        return info;
    }

    private void computeAlignmentInfo(int[] info, int[] widths, int w, int lineCount, FontMetrics fm, int halign, int valign, int hnwidth, int x, int y) {
        int descent;
        info[0] = 0;
        info[1] = 0;
        int ascent = fm.getAscent();
        info[6] = descent = fm.getDescent();
        int lineHeight = fm.getHeight();
        int h = lineHeight * lineCount;
        switch (valign) {
            case 0: {
                info[1] = info[1] + ascent;
                break;
            }
            case 1: {
                info[1] = info[1] + (ascent - this.height / 2 + 4);
                break;
            }
            case 3: {
                info[1] = info[1] - (this.height - ascent);
                break;
            }
        }
        info[0] = -w;
        info[2] = w;
        info[3] = h;
        info[4] = y + info[1] - ascent;
        switch (halign) {
            default: {
                info[0] = 0;
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = hnwidth;
                }
                break;
            }
            case 1: {
                info[0] = info[0] / 2;
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = hnwidth + (w - hnwidth - widths[i - 7]) / 2;
                }
                break;
            }
            case 2: {
                for (int i = 7; i < lineCount + 7; ++i) {
                    info[i] = w - widths[i - 7] - hnwidth;
                }
            }
        }
        info[0] = info[0] + x;
        info[1] = info[1] + y;
        info[5] = lineHeight;
    }

    private void _setBackgroundHeight(double ht) {
        if (ht != -1.0) {
            this.uc = new Point3(this.wloc.x, this.wloc.y - ht / 2.0, 1.0);
            this.lc = new Point3(this.wloc.x, this.wloc.y + ht / 2.0, 1.0);
            if (this.optimized) {
                this.uc.postMultiply(this.state.ch.trans.w2m);
                this.lc.postMultiply(this.state.ch.trans.w2m);
            }
        }
    }

    private void _setBackgroundWidth(double w) {
        if (w != -1.0) {
            this.cl = new Point3(this.wloc.x - w / 2.0, this.wloc.y, 1.0);
            this.cr = new Point3(this.wloc.x + w / 2.0, this.wloc.y, 1.0);
            if (this.optimized) {
                this.cl.postMultiply(this.state.ch.trans.w2m);
                this.cr.postMultiply(this.state.ch.trans.w2m);
            }
        }
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    void setPickable(StateLite state, boolean flag) {
        this.pickable = flag;
        this.namelist = flag ? state.namelist : null;
    }

    public void setHandleVisible(boolean flag) {
        this.handle = flag;
    }

    public void setHandleColor(Color c) {
        this.handleColor = c;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setSelectColor(Color color) {
        this.selectColor = color;
    }

    public void setMaxNumLines(int maxNumLines) {
        this.maxNumLines = maxNumLines;
    }

    public void setDrawIcon(boolean drawIcon) {
        this.drawIcon = drawIcon;
    }

    public boolean isInFocus() {
        return this.inFocus;
    }

    public void setInFocus(boolean inFocus) {
        this.inFocus = inFocus;
    }
}

