/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.j2d;

import com.sas.graphics.util.j2d.CompositeTextRectangle;
import com.sas.graphics.util.j2d.CompoundedText;
import com.sas.graphics.util.j2d.J2Debug;
import com.sas.graphics.util.j2d.JPolygon;
import com.sas.graphics.util.j2d.Point3;
import com.sas.graphics.util.j2d.RasterImage;
import com.sas.graphics.util.j2d.RasterText;
import com.sas.graphics.util.j2d.StateLite;
import com.sas.graphics.util.j2d.TransInfo;
import com.sas.graphics.util.j2d.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Stack;
import java.util.Vector;

public class ChannelLite
implements ImageObserver {
    private static final RenderingHints ANTIALIAS_ON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static final RenderingHints ANTIALIAS_OFF = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    protected Component component;
    private Image[] backbuffer;
    private Graphics[] bgc;
    private Graphics gc;
    private int currentBuffer;
    private Color backgroundColor = Color.gray;
    private Color shadowColor = Color.darkGray;
    private int shadowX = 4;
    private int shadowY = 4;
    private Color rasterBackgroundColor = null;
    private Image backgroundImage = null;
    private int backgroundImageStyle = 2;
    private int backgroundImagePositionX = 0;
    private int backgroundImagePositionY = 0;
    private Image scaledBackgroundImage = null;
    private int maxwidth = 320;
    private int maxheight = 240;
    public boolean yTextBorder = false;
    public int width = 320;
    public int height = 240;
    StateLite state;
    TransInfo trans;
    private Thread curThread;
    private Insets viewportInsets = new Insets(0, 0, 0, 0);
    protected myComponentAdapter componentListener = null;
    protected Rectangle viewportClipRectangle = new Rectangle();
    protected Rectangle userClipRectangle = null;
    protected Rectangle tempRectangle = new Rectangle();
    int refreshCount = -1;
    private static final int NUMBER_OF_BUFFERS = 4;
    private double xlens;
    private double ylens;

    public ChannelLite(Component component) {
        this.trans = new TransInfo(this);
        this.state = new StateLite(this);
        if (component == null) {
            throw new Error("Channel: component can't be null.");
        }
        this.component = component;
        this.componentListener = new myComponentAdapter(this);
        component.addComponentListener(this.componentListener);
        this.bgc = new Graphics[4];
        this.backbuffer = new Image[4];
        this.allocateBackbuffer();
        this.glViewport(0, 0, 1, 1);
    }

    StateLite getState() {
        return this.state;
    }

    public void addNotify() {
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        float[] hsb = new float[3];
        int r = this.backgroundColor.getRed();
        int g = this.backgroundColor.getGreen();
        int b = this.backgroundColor.getBlue();
        hsb = Color.RGBtoHSB(r, g, b, hsb);
        hsb[2] = (float)((double)hsb[2] * 0.5);
        this.shadowColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void removeBackgroundImage() {
        this.backgroundImage = null;
        this.scaledBackgroundImage = null;
    }

    public void setBackgroundImage(Image image, int style) {
        this.backgroundImage = image;
        this.scaledBackgroundImage = null;
        image.getWidth(this.component);
        image.getHeight(this.component);
        this.backgroundImageStyle = style;
    }

    public void setBackgroundImagePosition(int x, int y) {
        this.backgroundImagePositionX = x;
        this.backgroundImagePositionY = y;
    }

    public Graphics getGraphics() {
        return this.component.getGraphics();
    }

    public int getWidth() {
        Dimension size = this.component.getSize();
        return size.width;
    }

    public int getHeight() {
        Dimension size = this.component.getSize();
        return size.height;
    }

    public Component getComponent() {
        return this.component;
    }

    public Graphics getBackbufferGC() {
        return this.bgc[this.currentBuffer];
    }

    public Image getBackbuffer() {
        return this.backbuffer[this.currentBuffer];
    }

    public void setBackbuffer(Image img) {
        if (img == null) {
            return;
        }
        this.currentBuffer = 0;
        if (this.backbuffer[this.currentBuffer] != null && this.backbuffer[this.currentBuffer] != img) {
            this.backbuffer[this.currentBuffer].flush();
        }
        this.backbuffer[this.currentBuffer] = img;
        this.gc = this.bgc[this.currentBuffer] = img.getGraphics();
    }

    public void glDisable(int cap) {
        this.state.Disable(cap);
    }

    public void glEnable(int cap) {
        this.state.Enable(cap);
    }

    public boolean glIsEnabled(int cap) {
        return this.state.capabilities[cap];
    }

    public synchronized void glCallList(long lid) {
        this.glCallList(this.bgc[this.currentBuffer], lid, true);
    }

    public synchronized void glCallList(Graphics g, long lid, boolean reComputeScreenCoordinates) {
        J2Debug.println("glCallList: name=" + lid);
        if (g == null) {
            return;
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.state.capabilities[9]) {
                g2d.addRenderingHints(ANTIALIAS_ON);
            } else {
                g2d.addRenderingHints(ANTIALIAS_OFF);
            }
        }
        Rectangle c = g.getClipBounds();
        this.setClip(g);
        this.state.CallList(this, g, lid, reComputeScreenCoordinates);
        g.setClip(c);
    }

    public void glCallList(Graphics g, long lid) {
        this.glCallList(g, lid, true);
    }

    public synchronized void glCallList(long lid, boolean reComputeScreenCoordinates) {
        this.glCallList(this.bgc[this.currentBuffer], lid, reComputeScreenCoordinates);
    }

    public synchronized void glDeleteList(long lid) {
        this.state.DeleteList(lid);
    }

    public synchronized void glNewList(long lid) {
        J2Debug.println("glNewList: name=" + lid);
        this.state.NewList(lid);
    }

    public synchronized void glNewList(long lid, boolean optimized) {
        this.glNewList(lid);
    }

    public synchronized void glEndList() {
        this.state.EndList();
    }

    public void glViewport(int x, int y, int width, int height) {
        boolean dimensionsChanged;
        int oldWidth = this.width;
        int oldHeight = this.height;
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        this.width = width;
        this.height = height;
        if (width > this.maxwidth || height > this.maxheight) {
            this.maxwidth = width;
            this.maxheight = height;
            Dimension d = this.component.getSize();
            if (d.width > this.maxwidth) {
                this.maxwidth = d.width;
            }
            if (d.height > this.maxheight) {
                this.maxheight = d.height;
            }
        }
        this.allocateBackbuffer();
        this.trans.Viewport(x, y, width, height);
        this.viewportClipRectangle.setBounds(0, 0, width, height);
        this.setClip();
        boolean bl = dimensionsChanged = oldWidth != width || oldHeight != height;
        if (this.glIsEnabled(2) && dimensionsChanged) {
            if (this.xlens <= 1.0 && this.ylens <= 1.0) {
                this.setLensWorldLocation(this.xlens, this.ylens);
            } else {
                double widthRatio = (double)width / (double)oldWidth;
                double heightRatio = (double)height / (double)oldHeight;
                this.xlens = (int)(this.xlens * widthRatio);
                this.ylens = (int)(this.ylens * heightRatio);
                this.setLensScreenLocation(this.xlens, this.ylens);
            }
        }
    }

    public void glViewport(int width, int height, Insets border) {
        this.glViewport(border.left, border.top, width - border.left - border.right, height - border.top - border.bottom);
    }

    private void setClip() {
        Graphics g = this.bgc[this.currentBuffer];
        this.setClip(g);
    }

    private void setClip(Graphics g) {
        Rectangle r;
        Rectangle rectangle = r = this.userClipRectangle == null ? this.viewportClipRectangle : this.userClipRectangle;
        if (g != null) {
            g.setClip(r.x, r.y, r.width, r.height);
        }
    }

    public void glBegin(int mode) {
        this.state.Begin(mode);
    }

    public void glEnd() {
        this.state.End(this.bgc[this.currentBuffer]);
    }

    public void glRefresh(Rectangle area) {
        this.glRefresh(null, area);
    }

    public void glRefresh(Graphics gc) {
        this.glRefresh(gc, null);
    }

    public void glRefresh() {
        this.glRefresh(null, null);
    }

    public synchronized void glRefresh(Graphics gc, Rectangle area) {
        Viewport viewport;
        if (this.refreshCount >= 0) {
            ++this.refreshCount;
        }
        if (gc == null) {
            gc = this.gc;
        }
        if (area == null) {
            viewport = this.trans.GetViewport();
            area = this.tempRectangle;
            area.x = viewport.xo;
            area.y = viewport.yo;
            area.width = viewport.width;
            area.height = viewport.height;
        }
        viewport = this.trans.GetViewport();
        int xo = Math.max(viewport.xo, area.x);
        int yo = Math.max(viewport.yo, area.y);
        int x1 = Math.min(viewport.xo + viewport.width, area.x + area.width);
        int y1 = Math.min(viewport.yo + viewport.height, area.y + area.height);
        xo = Math.max(xo, 0);
        yo = Math.max(yo, 0);
        x1 = Math.min(x1, xo + this.component.getWidth());
        y1 = Math.min(y1, yo + this.component.getHeight());
        if (this.backbuffer[this.currentBuffer] != null) {
            gc.drawImage(this.backbuffer[this.currentBuffer], xo, yo, x1, y1, xo, yo, x1, y1, this.component);
        }
    }

    public void setClip(Rectangle rectangle) {
        this.userClipRectangle = rectangle.intersection(this.viewportClipRectangle);
        this.setClip();
    }

    public void resetClip() {
        this.userClipRectangle = null;
        this.setClip();
    }

    private boolean backbufferReady() {
        return this.backbuffer[this.currentBuffer] != null && this.bgc[this.currentBuffer] != null;
    }

    public void clearBGC() {
        Viewport viewport = this.trans.GetViewport();
        this.tempRectangle.x = viewport.xo;
        this.tempRectangle.y = viewport.yo;
        this.tempRectangle.width = viewport.width;
        this.tempRectangle.height = viewport.height;
        this.clearBuffer(this.tempRectangle);
    }

    public void clearBuffer(double xo, double yo, double x1, double y1) {
        Point3 po = new Point3(xo, yo, 1.0);
        this.trans.World2Screen(po);
        Point3 p1 = new Point3(x1, y1, 1.0);
        this.trans.World2Screen(p1);
        this.tempRectangle.x = (int)po.x;
        this.tempRectangle.y = (int)po.y;
        this.tempRectangle.width = (int)(p1.x - po.x);
        this.tempRectangle.height = (int)(p1.y - po.y);
        this.clearBuffer(this.tempRectangle);
    }

    public void clearBuffer(double xo, double yo, double zo, double x1, double y1, double z1) {
        Point3 po = new Point3(xo, yo, 1.0);
        this.trans.World2Screen(po);
        Point3 p1 = new Point3(x1, y1, 1.0);
        this.trans.World2Screen(p1);
        this.tempRectangle.x = (int)po.x;
        this.tempRectangle.y = (int)po.y;
        this.tempRectangle.width = (int)(p1.x - po.x);
        this.tempRectangle.height = (int)(p1.y - po.y);
        this.clearBuffer(this.tempRectangle);
    }

    public synchronized void clearBuffer(Rectangle area) {
        if (!this.backbufferReady()) {
            return;
        }
        if (area == null) {
            this.clearBGC();
        }
        Graphics bgc = this.backbuffer[this.currentBuffer].getGraphics();
        bgc.setColor(this.backgroundColor);
        bgc.fillRect(area.x, area.y, area.width, area.height);
        if (this.backgroundImage != null) {
            switch (this.backgroundImageStyle) {
                case 0: {
                    Viewport viewport = this.trans.GetViewport();
                    if (this.scaledBackgroundImage == null) {
                        this.scaledBackgroundImage = this.backgroundImage.getScaledInstance(viewport.width, viewport.height, 1);
                        int status = this.component.checkImage(this.scaledBackgroundImage, viewport.width, viewport.height, this);
                        if ((status & 0x20) == 0) {
                            Thread.yield();
                        }
                    } else {
                        int w = this.scaledBackgroundImage.getWidth(this.component);
                        int h = this.scaledBackgroundImage.getHeight(this.component);
                        if (w > 0 && h > 0 && (w != viewport.width || h != viewport.height)) {
                            this.scaledBackgroundImage = this.backgroundImage.getScaledInstance(viewport.width, viewport.height, 1);
                            int status = this.component.checkImage(this.scaledBackgroundImage, viewport.width, viewport.height, this);
                            if ((status & 0x20) == 0) {
                                Thread.yield();
                            }
                        }
                    }
                    bgc.drawImage(this.scaledBackgroundImage, viewport.xo, viewport.yo, this.backgroundColor, this.component);
                    break;
                }
                case 1: {
                    int w = this.backgroundImage.getWidth(this.component);
                    int h = this.backgroundImage.getHeight(this.component);
                    if (!(w > 0 & h > 0)) break;
                    Viewport viewport = this.trans.GetViewport();
                    for (int iy = 0; iy < viewport.height; iy += h) {
                        for (int ix = 0; ix < viewport.width; ix += w) {
                            bgc.drawImage(this.backgroundImage, ix, iy, this.backgroundColor, this.component);
                        }
                    }
                    break;
                }
                case 2: {
                    int w = this.backgroundImage.getWidth(this.component);
                    int h = this.backgroundImage.getHeight(this.component);
                    if (!(w > 0 & h > 0)) break;
                    Viewport viewport = this.trans.GetViewport();
                    int x = (viewport.width - w) / 2;
                    int y = (viewport.height - h) / 2;
                    bgc.drawImage(this.backgroundImage, x, y, this.backgroundColor, this.component);
                    break;
                }
                case 3: {
                    int w = this.backgroundImage.getWidth(this.component);
                    int h = this.backgroundImage.getHeight(this.component);
                    if (!(w > 0 & h > 0)) break;
                    Viewport viewport = this.trans.GetViewport();
                    int x = this.backgroundImagePositionX;
                    int y = this.backgroundImagePositionY;
                    if (x < 0) {
                        x = viewport.width + x - w;
                    }
                    if (y < 0) {
                        y = viewport.height + y - h;
                    }
                    bgc.drawImage(this.backgroundImage, x, y, this.backgroundColor, this.component);
                    break;
                }
            }
        }
    }

    public void copyBuffer(int src) {
        Viewport viewport = this.trans.GetViewport();
        Rectangle r = this.tempRectangle;
        r.x = viewport.xo;
        r.y = viewport.yo;
        r.width = viewport.width;
        r.height = viewport.height;
        this.copyBuffer(r, src);
    }

    public void copyBuffer(Rectangle rect, int src) {
        if (rect == null) {
            return;
        }
        int current = this.currentBuffer;
        if (!this.backbufferReady()) {
            return;
        }
        this.setBackbuffer(src);
        if (!this.backbufferReady()) {
            return;
        }
        this.setBackbuffer(current);
        this.bgc[this.currentBuffer].drawImage(this.backbuffer[src], rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, this.component);
    }

    public void copyBuffer(double xo, double yo, double zo, double x1, double y1, double z1, int src) {
        Point3 po = new Point3(xo, yo, 1.0);
        this.trans.World2Screen(po);
        Point3 p1 = new Point3(x1, y1, 1.0);
        this.trans.World2Screen(p1);
        Rectangle r = this.tempRectangle;
        r.x = (int)po.x;
        r.y = (int)po.y;
        r.width = (int)(p1.x - po.x);
        r.height = (int)(p1.y - po.y);
        this.copyBuffer(r, src);
    }

    public void copyBuffer(double xo, double yo, double x1, double y1, int src) {
        Point3 po = new Point3(xo, yo, 1.0);
        this.trans.World2Screen(po);
        Point3 p1 = new Point3(x1, y1, 1.0);
        this.trans.World2Screen(p1);
        Rectangle r = this.tempRectangle;
        r.x = (int)po.x;
        r.y = (int)po.y;
        r.width = (int)(p1.x - po.x);
        r.height = (int)(p1.y - po.y);
        this.copyBuffer(r, src);
    }

    public void setBackbuffer(int index) {
        if (index >= 4) {
            J2Debug.println("WARNING: Maximum number of allowed buffers is 4.");
            J2Debug.println("Channel: setBackbuffer() call ignored.");
            return;
        }
        this.currentBuffer = index;
        this.allocateBackbuffer();
        this.setClip();
    }

    void allocateBackbuffer() {
        this.gc = this.component.getGraphics();
        Image i = this.backbuffer[this.currentBuffer];
        int curWidth = this.component.getWidth();
        int curHeight = this.component.getHeight();
        if (i == null || i.getHeight(this.component) < curHeight || i.getWidth(this.component) < curWidth || (double)i.getHeight(this.component) * 0.5 > (double)curHeight || (double)i.getWidth(this.component) * 0.5 > (double)curWidth) {
            if (i != null) {
                i.flush();
            }
            if (curWidth > 0 && curHeight > 0 && (i = this.component.createImage(curWidth, curHeight)) == null) {
                i = new BufferedImage(curWidth, curHeight, 1);
            }
            if (i != null) {
                this.backbuffer[this.currentBuffer] = i;
            }
        }
        this.bgc[this.currentBuffer] = this.backbuffer[this.currentBuffer] == null ? this.gc : this.backbuffer[this.currentBuffer].getGraphics();
    }

    public double[] glGetDoublev(int pname) {
        double[] r;
        switch (pname) {
            case 0: {
                r = this.trans.getViewport();
                break;
            }
            default: {
                J2Debug.println("glGetDoublev: unknown pname.");
                r = new double[]{};
            }
        }
        return r;
    }

    public void enableRefreshCount() {
        this.refreshCount = 0;
    }

    public void disableRefreshCount() {
        this.refreshCount = -1;
    }

    public void resetRefreshCount() {
        this.refreshCount = 0;
    }

    public int getRefreshCount() {
        return this.refreshCount;
    }

    public void glOblique(double left, double right, double bottom, double top, double near, double far, double distort, double angle) {
        this.trans.Ortho(left, right, bottom, top);
    }

    public void glOrtho(double left, double right, double bottom, double top) {
        this.trans.Ortho(left, right, bottom, top);
    }

    public void glOrtho(double left, double right, double bottom, double top, double near, double far) {
        this.trans.Ortho(left, right, bottom, top);
    }

    public void gluFrustum(double left, double right, double bottom, double top, double near, double far) {
        this.trans.Ortho(left, right, bottom, top);
    }

    public void gluPerspective(double fov, double aspect, double near, double far) {
    }

    public void gluLookAt(double eyex, double eyey, double eyez, double centerx, double centery, double centerz, double upx, double upy, double upz) {
        this.trans.LookAt(centerx, centery, 0.0);
    }

    public void gluLookAt(double centerx, double centery, double centerz, double dist, double azim, double inc, double twist) {
        this.trans.LookAt(centerx, centery, twist);
    }

    public void gluLookAt(double centerx, double centery, double angle) {
        this.trans.LookAt(centerx, centery, angle);
    }

    public void gluUnProject(double[] win, double[] obj) {
        Point3 p = new Point3(win[0], win[1], 1.0);
        this.trans.UnProject(p);
        obj[0] = p.x;
        obj[1] = p.y;
    }

    public void gluProject(double[] obj, double[] win) {
        Point3 p = new Point3(obj[0], obj[1], 1.0);
        this.trans.Project(p);
        win[0] = p.x;
        win[1] = p.y;
    }

    public void glLoadIdentity() {
        this.trans.LoadIdentity(this.state.render_mode, this.state.displaylist);
    }

    public void glScale(double x, double y, double z) {
        this.trans.Scale(x, y, this.state.render_mode, this.state.displaylist);
    }

    public void glScale(double x, double y) {
        this.trans.Scale(x, y, this.state.render_mode, this.state.displaylist);
    }

    public void glTranslate(double x, double y, double z) {
        this.trans.Translate(x, y, this.state.render_mode, this.state.displaylist);
    }

    public void glTranslate(double x, double y) {
        this.trans.Translate(x, y, this.state.render_mode, this.state.displaylist);
    }

    public void glRotate(double angle, double x, double y, double z) {
        this.trans.Rotate(angle, x, y, this.state.render_mode, this.state.displaylist);
    }

    public void glRotate(double angle, double x, double y) {
        this.trans.Rotate(angle, x, y, this.state.render_mode, this.state.displaylist);
    }

    public void glRotate(double centerx, double centery, double centerz, double x, double y, double z, double angle) {
        this.trans.Rotate(centerx, centery, angle, this.state.render_mode, this.state.displaylist);
    }

    public void glRotate(double centerx, double centery, double x, double y, double angle) {
        this.trans.Rotate(centerx, centery, angle, this.state.render_mode, this.state.displaylist);
    }

    public double[] gluGetScreenX() {
        return this.trans.GetScreenX();
    }

    public double[] gluGetScreenY() {
        return this.trans.GetScreenY();
    }

    public double[] gluGetScreenZ() {
        double[] result = new double[]{0.0, 0.0};
        return result;
    }

    public void glLoadMatrix(double[] matrix) {
        this.trans.LoadMatrix(matrix, this.state.render_mode, this.state.displaylist);
    }

    public void glGetMatrix(double[] matrix) {
        this.trans.GetMatrix(matrix);
    }

    public void glPopMatrix() {
        this.trans.PopMatrix(this.state.render_mode, this.state.displaylist);
    }

    public void glPushMatrix() {
        this.trans.PushMatrix(this.state.render_mode, this.state.displaylist);
    }

    public void glSelect2DFont(Font font) {
        this.state.Select2DFont(font);
    }

    public void glSelect2DFont(String name, int style) {
        this.state.Select2DFont(name, style);
    }

    public double glGetTextWidth(String string) {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getWidth(this.state, this.bgc[0], this.state.font, string);
    }

    public double glGetTextWidth(String string, Font font) {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getWidth(this.state, this.bgc[0], font, string);
    }

    public double glGetTextAscent() {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getAscent(this.state, this.bgc[0], this.state.font);
    }

    public double glGetTextDescent() {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getDescent(this.state, this.bgc[0], this.state.font);
    }

    public double glGetTextSize(Font font) {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getSize(this.state, this.bgc[0], font);
    }

    public double glGetTextHeight() {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getHeight(this.state, this.bgc[0], this.state.font);
    }

    public double glGetTextHeight(Font font) {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getHeight(this.state, this.bgc[0], font);
    }

    public double glGetTextHeight(String string, Font font) {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getHeight(this.state, this.bgc[0], font, string);
    }

    public double glGetTextHeight(String string) {
        if (this.bgc[0] == null) {
            this.allocateBackbuffer();
        }
        return RasterText.getHeight(this.state, this.bgc[0], this.state.font, string);
    }

    public void glTextHeight(double height) {
        this.state.TextHeight(height);
    }

    public void glTextHeight(int point) {
        this.state.TextHeight(point);
    }

    public void gl2DText(String string) {
        this.state.Text2D(string, 0.0, 0.0);
    }

    public CompoundedText glRectangleText(String string, double x, double y, double width, double height) {
        return this.state.RectangleText(string, x, y, width, height);
    }

    public CompoundedText glRectangleText(String string, double x, double y, double width, double height, boolean pickable) {
        return this.state.RectangleText(string, x, y, width, height, pickable);
    }

    public CompositeTextRectangle glCompositeText(String string, double x, double y, double width, double height, Image icon) {
        return this.state.CompositeText(string, x, y, width, height, icon);
    }

    public CompositeTextRectangle glCompositeText(String string, double x, double y, double width, double height, Image icon, boolean pickable) {
        return this.state.CompositeText(string, x, y, width, height, icon, pickable);
    }

    public RasterText gl2DText(String string, double x, double y, double z) {
        return this.state.Text2D(string, x, y);
    }

    public RasterText gl2DText(String string, double x, double y) {
        return this.state.Text2D(string, x, y);
    }

    public RasterText gl2DText(String string, double x, double y, boolean pickable) {
        return this.state.Text2D(string, x, y, pickable);
    }

    public RasterText gl2DTextRect(String string, double xo, double yo, double x1, double y1) {
        return this.state.Text2D(string, xo, yo, x1, y1);
    }

    public void glTextAlign(int halign, int valign) {
        this.state.TextAlign(halign, valign);
    }

    public void glRectAlign(int halign, int valign) {
        this.state.RectAlign(halign, valign);
    }

    public void glImage(Image im) {
        this.state.Image(im, 0.0, 0.0);
    }

    public void glImage(Image im, boolean raised) {
        this.state.Image(im, 0.0, 0.0, raised);
    }

    public void glImage(Image im, double x, double y) {
        this.state.Image(im, x, y);
    }

    public void glImage(Image im, double x, double y, boolean raised) {
        this.state.Image(im, x, y, raised);
    }

    public void glRectangle(double x, double y, double width, double height) {
        this.state.Rect(x, y, width, height);
    }

    public void glRectangle(double x, double y, double width, double height, boolean raised) {
        this.state.Rect(x, y, width, height, raised);
    }

    public void glLine(double x1, double y1, double x2, double y2) {
        this.state.Line(x1, y1, x2, y2);
    }

    public void glLine(double x1, double y1, double x2, double y2, boolean raised) {
        this.state.Line(x1, y1, x2, y2, raised);
    }

    public void glImage(Vector list, int id) {
        this.state.Image(list, id, 0.0, 0.0);
    }

    public void glImage(Vector list, int id, boolean raised) {
        this.state.Image(list, id, 0.0, 0.0, raised);
    }

    public void glImage(Vector list, int id, double x, double y) {
        this.state.Image(list, id, x, y);
    }

    public void glImage(Vector list, int id, double x, double y, boolean raised) {
        this.state.Image(list, id, x, y, raised);
    }

    public double glGetImageWidth(Image im) {
        return RasterImage.getWidth(this.state, im);
    }

    public double glGetImageHeight(Image im) {
        return RasterImage.getHeight(this.state, im);
    }

    public void glCenter(double x, double y) {
        this.state.Center(x, y);
    }

    public void glCenter(double x, double y, double z) {
        this.state.Center(x, y);
    }

    public void glVertex(String str, double x, double y) {
        this.state.Vertex(str, x, y);
    }

    public void glVertex(String str, double x, double y, double z) {
        this.state.Vertex(str, x, y);
    }

    public void glVertex(String str, double x, double y, boolean flag) {
        this.state.Vertex(str, x, y, flag);
    }

    public void glVertex(String str, double x, double y, double z, boolean flag) {
        this.state.Vertex(str, x, y, flag);
    }

    public void glVertex(double x, double y) {
        this.state.Vertex(x, y);
    }

    public void glVertex(double x, double y, double z) {
        this.state.Vertex(x, y);
    }

    public void glNormal(double x, double y, double z) {
    }

    public void glColor(Color color) {
        this.state.Color(color);
    }

    public void glEmissiveColor(Color color) {
    }

    public void glEmissiveColor(double r, double g, double b) {
    }

    public void glAmbientIntensity(double amb) {
    }

    public void glEdgeColor(Color color) {
        this.state.EdgeColor(color);
    }

    public void glColor(double r, double g, double b) {
        this.state.Color(new Color((float)r, (float)g, (float)b));
    }

    public void glEdgeColor(double r, double g, double b) {
        this.state.EdgeColor(new Color((float)r, (float)g, (float)b));
    }

    public Color getEdgeColor() {
        return this.state.edgecolor;
    }

    public Color getColor() {
        return this.state.color;
    }

    public Font glGetFont() {
        return this.state.font;
    }

    public synchronized void glFinish() {
        J2Debug.println("glFinish");
        this.clearBGC();
        if (this.bgc[this.currentBuffer] == null) {
            return;
        }
        Rectangle c = this.bgc[this.currentBuffer].getClipBounds();
        this.setClip(this.bgc[this.currentBuffer]);
        this.state.Finish(this.bgc[this.currentBuffer]);
        this.bgc[this.currentBuffer].setClip(c);
        this.glRefresh();
    }

    public void glCullFace(int mode) {
    }

    public void glFrontFace(int dir) {
    }

    public void glPolygonMode(int fill) {
        this.state.PolygonMode(fill);
    }

    public int getPolygonMode() {
        return this.state.getPolygonMode();
    }

    public void setPickAllHits(boolean aBoolean) {
        this.state.pickAllHits = aBoolean;
    }

    public synchronized void setPickFullLine(boolean aBoolean) {
        this.state.pickFullLine = aBoolean;
    }

    public synchronized boolean getPickFullLine() {
        return this.state.pickFullLine;
    }

    public boolean glRenderMode(int mode) {
        return this.state.RenderMode(mode);
    }

    public void glSelectBuffer(Stack buffer) {
        this.state.SelectBuffer(buffer);
    }

    public void gluPickMatrix(int curx, int cury, int width, int height) {
        this.state.PickMatrix(curx, cury, width, height);
    }

    public void glInitNames() {
        this.state.InitNames();
    }

    public void glPopName() {
        this.state.PopName();
    }

    public void glPushName(Object name) {
        this.state.PushName(name);
    }

    public void glLoadName(Object name) {
        this.state.LoadName(name);
    }

    public void setOutlineMode(int mode) {
        this.state.setOutlineMode(mode);
    }

    public int getOutlineMode() {
        return this.state.getOutlineMode();
    }

    public void setLensFactor(double fac) {
        this.state.setLensFactor(fac);
    }

    public double getLensFactor() {
        return this.state.getLensFactor();
    }

    public void setLensWorldPercentageFactors(double[] lwpFacs) {
        this.state.setLensWorldAreaPercentageFactors(lwpFacs);
    }

    public void setLensScreenPercentageFactor(double lspFac) {
        this.state.setLensScreenAreaPercentageFactor(lspFac);
    }

    public double getLensScreenPercentageFactor() {
        return this.state.getLensScreenAreaPercentageFactor();
    }

    public void setThetaLensFactor(double fac) {
        this.state.setThetaLensFactor(fac);
    }

    public void setThetaLensAngles(double min, double max) {
        this.state.setThetaLensAngles(min, max);
    }

    public double getThetaLensFactor() {
        return this.state.getThetaLensFactor();
    }

    public void setTextBorderFlag(boolean flag) {
        this.state.setTextBorderFlag(flag);
    }

    public void setTextBorderType(int type) {
        this.state.setTextBorderType(type);
    }

    public int getTextBorderType() {
        return this.state.getTextBorderType();
    }

    public void setTextBorderColor(Color color) {
        this.state.setTextBorderColor(color);
    }

    public void setTextColor(Color color) {
        this.state.setTextColor(color);
    }

    public void setTextLineColor(Color color) {
        this.state.setTextLineColor(color);
    }

    public void setBorderType(int type) {
        this.state.setBorderType(type);
    }

    public int getBorderType() {
        return this.state.getBorderType();
    }

    public void setTextHandleColor(Color color) {
        this.state.setTextHandleColor(color);
    }

    public void setTextCutoff(double fac, double spreadFac) {
        this.state.setTextCutoff(fac, spreadFac);
    }

    public void setBorderCutoff(double fac) {
        this.state.setBorderCutoff(fac);
    }

    public void glLineWidth(float width) {
        int pixels = 1;
        if (width > 1.0f) {
            pixels = (int)width;
        }
        this.state.lineWidth(pixels);
    }

    public void lineCapStyle(int capStyle) {
        this.state.capStyle(capStyle);
    }

    @Override
    public boolean imageUpdate(Image im, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) == 0) {
            return true;
        }
        if (this.component != null && this.gc != null) {
            this.component.paint(this.gc);
        }
        return false;
    }

    boolean hasBackImage() {
        return this.backgroundImage != null;
    }

    void shadow(int xo, int yo, int pw, int ph) {
        xo += this.shadowX;
        yo += this.shadowY;
        if (this.backgroundImage != null) {
            float[] hsb = new float[3];
            int[] pixels = new int[pw * ph];
            PixelGrabber pg = new PixelGrabber(this.backbuffer[this.currentBuffer], xo, yo, pw, ph, pixels, 0, pw);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                System.err.println("interrupted waiting for pixels!");
            }
            if ((pg.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
            } else {
                int psz = pixels.length;
                for (int ii = 0; ii < psz; ++ii) {
                    Color color = new Color(pixels[ii]);
                    int r = color.getRed();
                    int g = color.getGreen();
                    int b = color.getBlue();
                    hsb = Color.RGBtoHSB(r, g, b, hsb);
                    hsb[2] = (float)((double)hsb[2] * 0.5);
                    pixels[ii] = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                }
                Image im = this.component.createImage(new MemoryImageSource(pw, ph, pixels, 0, pw));
                this.bgc[this.currentBuffer].drawImage(im, xo, yo, null);
            }
        } else {
            this.bgc[this.currentBuffer].setColor(this.shadowColor);
            this.bgc[this.currentBuffer].fillRect(xo, yo, pw, ph);
        }
    }

    public void glLineStipple(int factor, int pattern) {
        this.state.setStipple(factor, pattern);
    }

    public void setLensWorldLocation(double x, double y) {
        this.trans.setLensWorldLocation(x, y);
        this.xlens = x;
        this.ylens = y;
        this.state.dirtyLensFlag = true;
    }

    public void setLensDirection(int dir) {
        this.state.lensDirection = dir;
    }

    public void setVerticalLensLocations(double[] locs, double[] range, double[] values, double[] cutoffs) {
        this.trans.setVerticalLensLocations(locs, range, values, cutoffs);
        this.state.lensDirection = 6;
    }

    public void setLensScreenLocation(double x, double y) {
        this.trans.setLensScreenLocation(x, y);
        this.xlens = x;
        this.ylens = y;
    }

    public double[] getLensScreenLocation() {
        double[] screen = new double[]{this.xlens, this.ylens};
        return screen;
    }

    public void setMaxNodeTextSize(double maxNodeTextSize) {
        Dimension d = this.component.getSize();
        if (d != null && maxNodeTextSize < d.getWidth()) {
            JPolygon.setRadialAreaUseFactor((d.getWidth() - maxNodeTextSize) / d.getWidth());
        }
    }

    public void setVerticalLensMargin(double margin) {
        JPolygon.setVerticalLensMargin(margin);
    }

    public static class myComponentAdapter
    extends ComponentAdapter {
        private ChannelLite container;

        public myComponentAdapter(ChannelLite container) {
            this.container = container;
        }

        @Override
        public void componentShown(ComponentEvent event) {
            this.container.allocateBackbuffer();
        }
    }
}

