/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Component;
import com.sas.dplycmn.planning.ComponentRelationship;
import com.sas.dplycmn.planning.Container;
import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.Offering;
import com.sas.dplycmn.planning.Placement;
import com.sas.dplycmn.planning.Plan;
import com.sas.dplycmn.planning.PlanDictionary;
import com.sas.dplycmn.planning.PlanWalker;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlanTextWriter
extends PlanWalker.Handler {
    public static final int OUTPUT_SDW_CONTENT = 0;
    public static final int OUTPUT_ALL_CONTENT = 1;
    private static final String INDENTATION = "  ";
    private static final String ITEM_SUFFIX = " ------------------------------------------------------------";
    private static final Set<String> SDW_VERBS = new HashSet<String>();
    private Plan plan;
    private Writer writer;
    private int outputType;
    private int indentationLevel = 0;
    private String prefix = PlanTextWriter.getPrefix(this.indentationLevel);
    private final List<PlanDictionary.Entry> childPlacementTypes;

    public PlanTextWriter(Plan plan, Writer writer, int outputType) {
        this.plan = plan;
        this.writer = writer;
        this.outputType = outputType;
        this.childPlacementTypes = new ArrayList<PlanDictionary.Entry>();
        this.childPlacementTypes.add(PlanWalker.PLACEMENT_PREREQ);
        this.childPlacementTypes.add(PlanWalker.PLACEMENT_INSTALL);
        this.childPlacementTypes.add(PlanWalker.PLACEMENT_CONFIGURED);
        if (1 == outputType) {
            this.childPlacementTypes.add(PlanWalker.PLACEMENT_CONTAINER);
        }
    }

    public void execute() throws Exception {
        PlanWalker.walk(this.plan, this);
        this.writer.flush();
    }

    public static void write(Plan plan, Writer writer, int outputType) throws Exception {
        PlanTextWriter planTextWriter = new PlanTextWriter(plan, writer, outputType);
        planTextWriter.execute();
    }

    private void addOutput(String output) throws IOException {
        this.writer.write(output);
    }

    private void increaseIndentation() {
        ++this.indentationLevel;
        this.prefix = PlanTextWriter.getPrefix(this.indentationLevel);
    }

    private void decreaseIndentation() {
        --this.indentationLevel;
        if (0 > this.indentationLevel) {
            this.indentationLevel = 0;
        }
        this.prefix = PlanTextWriter.getPrefix(this.indentationLevel);
    }

    @Override
    public void startPlan(Plan plan) throws IOException {
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Name: ", plan.getName()));
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Config Dir: ", plan.getConfigDirectory()));
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Description: ", plan.getPlanDescription()));
        if (1 == this.outputType) {
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Cust. name: ", plan.getCustomerName()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Order number: ", plan.getOrderNumber()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "TS site number:", plan.getTechSupportSiteNumber()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Site ID: ", plan.getSiteId()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Created by: ", plan.getCreatedBy()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "SAS Version: ", plan.getSasVersion()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "As of date: ", plan.getAsOfDate().toString()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Last modified: ", plan.getLastModified().toString()));
        }
    }

    @Override
    public void startOffering(Offering offering) throws IOException {
        if (0 == this.outputType) {
            return;
        }
        this.addOutput(this.prefix + " Offering" + ITEM_SUFFIX + "\n");
        this.increaseIndentation();
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Code: ", offering.getCode()));
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Name: ", offering.getName()));
        if (1 == this.outputType) {
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Ext. version: ", offering.getExternalVersion()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Int. version: ", offering.getInternalVersion()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Prod. status: ", offering.getProductionStatus()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "As of date: ", offering.getAsOfDate().toString()));
        }
    }

    @Override
    public void finishOffering(Offering offering) {
        if (0 == this.outputType) {
            return;
        }
        this.decreaseIndentation();
    }

    @Override
    public void startMachine(Machine machine) throws IOException {
        this.addOutput(this.prefix + " Machine" + ITEM_SUFFIX + "\n");
        this.increaseIndentation();
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Name: ", machine.getName()));
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Full Name: ", machine.getFullName()));
        for (Map.Entry<Integer, String> entry : machine.getSteps().entrySet()) {
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Step " + entry.getKey() + ": ", entry.getValue()));
        }
        if (1 == this.outputType) {
            for (String purpose : machine.getPurposes()) {
                this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Purpose: ", purpose));
            }
        }
        for (String derivedPurpose : machine.getDerivedPurposes()) {
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Derived purpose: ", derivedPurpose));
        }
    }

    @Override
    public void finishMachine(Machine machine) {
        this.decreaseIndentation();
    }

    @Override
    public List<PlanDictionary.Entry> getChildPlacementTypes() {
        return this.childPlacementTypes;
    }

    @Override
    public boolean includeChildPlacement(Container<Placement> container, Placement placement, PlanDictionary.Entry placementType) {
        if (1 == this.outputType) {
            return true;
        }
        if (0 == this.outputType) {
            if (PlanWalker.PLACEMENT_CONTAINER.equals((Object)placementType)) {
                return false;
            }
            if (container instanceof Machine) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void startPlacement(Placement placement, PlanDictionary.Entry placementType) throws IOException {
        this.addOutput(this.prefix + " " + placementType.getDisplayValue() + ITEM_SUFFIX + "\n");
        this.increaseIndentation();
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Code: ", placement.getCode()));
        this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Name: ", placement.getName()));
        if (1 == this.outputType) {
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Ext. version: ", placement.getExternalVersion()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Int. version: ", placement.getInternalVersion()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Prod. status: ", placement.getProductionStatus()));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Hidden?", String.valueOf(placement.isHidden())));
            this.addOutput(PlanTextWriter.textDumpLine(this.prefix, "Foundation?", String.valueOf(placement.isFoundation())));
        }
        if (PlanWalker.PLACEMENT_CONFIGURED.equals((Object)placementType)) {
            boolean stepsStarted = false;
            for (Integer stepNumber : placement.getStepNumbers()) {
                if (stepsStarted) {
                    this.addOutput(", " + stepNumber);
                    continue;
                }
                this.addOutput(this.prefix + INDENTATION + "in step " + stepNumber);
                stepsStarted = true;
            }
            if (stepsStarted) {
                this.addOutput("\n");
            }
        }
    }

    @Override
    public boolean includeRelationship(Component component, PlanDictionary.Entry placementType, ComponentRelationship relationship) throws Exception {
        boolean isInstalled = false;
        if (component instanceof Placement) {
            isInstalled = ((Placement)component).isInstalled();
        }
        if (PlanWalker.PLACEMENT_INSTALL.equals((Object)placementType) || PlanWalker.PLACEMENT_CONTAINER.equals((Object)placementType) || PlanWalker.PLACEMENT_CONFIGURED.equals((Object)placementType) && !isInstalled) {
            return relationship.getSubject().equals(component);
        }
        return false;
    }

    @Override
    public void startRelationship(ComponentRelationship relationship) throws IOException {
        List<String> verbs = relationship.getVerbs();
        Collections.sort(verbs);
        for (String verb : verbs) {
            if (0 == this.outputType && !SDW_VERBS.contains(verb)) continue;
            this.addOutput(this.prefix + INDENTATION + INDENTATION + relationship.getSubject().getCode() + " " + verb + " " + relationship.getPredicate().getCode() + "\n");
        }
    }

    @Override
    public void finishPlacement(Placement placement, PlanDictionary.Entry placementType) {
        this.decreaseIndentation();
    }

    private static String getPrefix(int prefixCount) {
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < prefixCount; ++i) {
            prefix.append(INDENTATION);
        }
        return prefix.toString();
    }

    private static String textDumpLine(String prefix, String key, String value) {
        return prefix + String.format("%-20s", key) + value + "\n";
    }

    static {
        SDW_VERBS.add("signals additional instance");
        SDW_VERBS.add("signals reconfiguration");
    }
}

