/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Component;
import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.MultiValueProps;
import com.sas.dplycmn.planning.Offering;
import com.sas.dplycmn.planning.Placement;
import com.sas.dplycmn.planning.Plan;
import com.sas.dplycmn.planning.PlanDictionary;
import com.sas.dplycmn.planning.PlanXml;
import com.sas.dplycmn.planning.StaxPlanXmlLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class PlanFactory {
    public static final String PLAN_XML_CHARSET = "UTF-8";

    private PlanFactory() {
    }

    public static Plan getPlanFromXml(InputStream planStream) throws ParseException {
        StaxPlanXmlLoader loader = new StaxPlanXmlLoader();
        Plan plan = loader.process(planStream);
        plan.alignStdTopoDefs();
        return plan;
    }

    public static Plan getPlanFromString(String planContent) throws ParseException, UnsupportedEncodingException {
        return PlanFactory.getPlanFromXml(new ByteArrayInputStream(planContent.getBytes(PLAN_XML_CHARSET)));
    }

    public static Plan getPlanFromFile(File planFile) throws FileNotFoundException, ParseException {
        return PlanFactory.getPlanFromXml(new FileInputStream(planFile));
    }

    static Date getDateOnlyProp(MultiValueProps props, String key) throws ParseException {
        String value = props.getValue(key);
        if (null == value) {
            return null;
        }
        return PlanXml.DateParser.DATEONLY.parse(value);
    }

    static Date getDateOnlyProp(Properties props, String key) throws ParseException {
        String value = props.getProperty(key);
        if (null == value) {
            return null;
        }
        return PlanXml.DateParser.DATEONLY.parse(value);
    }

    static Date getDateTimeProp(MultiValueProps props, String key) throws ParseException {
        String value = props.getValue(key);
        if (null == value) {
            return null;
        }
        return PlanXml.DateParser.DATETIME.parse(value);
    }

    static Date getDateTimeProp(Properties props, String key) throws ParseException {
        String value = props.getProperty(key);
        if (null == value) {
            return null;
        }
        return PlanXml.DateParser.DATETIME.parse(value);
    }

    static boolean getBooleanProp(Properties props, String key) {
        return Boolean.valueOf(props.getProperty(key));
    }

    static boolean getBooleanProp(MultiValueProps props, String key) {
        return Boolean.valueOf(props.getValue(key));
    }

    static int setPlanProperties(Plan plan, MultiValueProps properties) throws ParseException {
        String key;
        Date dateValue;
        int planPropsSeen = 0;
        String value = properties.getValue(PlanDictionary.Entry.PLAN_CONFIG_DIRECTORY.getXmlValue());
        if (null != value) {
            ++planPropsSeen;
            plan.setConfigDirectory(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_CREATED_BY.getXmlValue()))) {
            ++planPropsSeen;
            plan.setCreatedBy(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_CUSTOMER_NAME.getXmlValue()))) {
            ++planPropsSeen;
            plan.setCustomerName(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_ORDER_NUMBER.getXmlValue()))) {
            ++planPropsSeen;
            plan.setOrderNumber(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_DESCRIPTION.getXmlValue()))) {
            ++planPropsSeen;
            plan.setPlanDescription(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_TS_SITE_NUMBER.getXmlValue()))) {
            ++planPropsSeen;
            plan.setTechSupportSiteNumber(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_SITE_ID.getXmlValue()))) {
            ++planPropsSeen;
            plan.setSiteId(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_SAS_VERSION.getXmlValue()))) {
            ++planPropsSeen;
            plan.setSasVersion(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_SHIP_EVENT.getXmlValue()))) {
            ++planPropsSeen;
            plan.setShipEvent(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_MAINT_LEVEL.getXmlValue()))) {
            ++planPropsSeen;
            plan.setMaintLevel(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_STANDARD_TOPOLOGY.getXmlValue()))) {
            ++planPropsSeen;
            plan.setStandardTopology(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.PLAN_BUILD_DETAILS.getXmlValue()))) {
            ++planPropsSeen;
            plan.setBuildDetails(value);
        }
        if (null != (dateValue = PlanFactory.getDateOnlyProp(properties, PlanDictionary.Entry.PLAN_AS_OF_DATE.getXmlValue()))) {
            ++planPropsSeen;
            plan.setAsOfDate(dateValue);
        }
        if (null != (dateValue = PlanFactory.getDateTimeProp(properties, PlanDictionary.Entry.PLAN_LAST_MODIFIED.getXmlValue()))) {
            ++planPropsSeen;
            plan.setLastModified(dateValue);
        }
        if (properties.containsKey(key = PlanDictionary.Entry.PLAN_IS_VALID.getXmlValue())) {
            ++planPropsSeen;
            plan.setPlanValid(PlanFactory.getBooleanProp(properties, key));
        }
        if (properties.containsKey(key = PlanDictionary.Entry.PLAN_IS_POWER_MODE.getXmlValue())) {
            ++planPropsSeen;
            plan.setPowerMode(PlanFactory.getBooleanProp(properties, key));
        }
        if (properties.containsKey(key = PlanDictionary.Entry.PLAN_IS_SEQUENCE_ENSURED.getXmlValue())) {
            ++planPropsSeen;
            plan.setSequenceEnsured(PlanFactory.getBooleanProp(properties, key));
        }
        return planPropsSeen;
    }

    private static void setComponentProperties(Component component, MultiValueProps properties) {
        String value = properties.getValue(PlanDictionary.Entry.COMPONENT_CODE.getXmlValue());
        if (null != value) {
            component.setCode(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.COMPONENT_EXT_VERSION.getXmlValue()))) {
            component.setExternalVersion(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.COMPONENT_NAME.getXmlValue()))) {
            component.setName(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.COMPONENT_INT_VERSION.getXmlValue()))) {
            component.setInternalVersion(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.COMPONENT_PROD_STATUS.getXmlValue()))) {
            component.setProductionStatus(value);
        }
    }

    static void setOfferingProperties(Offering offering, MultiValueProps properties) throws ParseException {
        String key;
        PlanFactory.setComponentProperties(offering, properties);
        Date dateValue = PlanFactory.getDateOnlyProp(properties, PlanDictionary.Entry.OFFERING_AS_OF_DATE.getXmlValue());
        if (null != dateValue) {
            offering.setAsOfDate(dateValue);
        }
        if (properties.containsKey(key = PlanDictionary.Entry.OFFERING_USER_SELECTED.getXmlValue())) {
            offering.setUserSelected(PlanFactory.getBooleanProp(properties, key));
        }
    }

    static void setPlacementProperties(Placement placement, MultiValueProps properties) {
        List<String> stepNumbers;
        String key;
        PlanFactory.setComponentProperties(placement, properties);
        String value = properties.getValue(PlanDictionary.Entry.PLACEMENT_PLATFORM.getXmlValue());
        if (null != value) {
            placement.setPlatform(value);
        }
        if (properties.containsKey(key = PlanDictionary.Entry.PLACEMENT_IS_FOUNDATION.getXmlValue())) {
            placement.setFoundation(PlanFactory.getBooleanProp(properties, key));
        }
        if (properties.containsKey(key = PlanDictionary.Entry.PLACEMENT_IS_HIDDEN.getXmlValue())) {
            placement.setHidden(PlanFactory.getBooleanProp(properties, key));
        }
        if (properties.containsKey(key = PlanDictionary.Entry.PLACEMENT_IS_PREREQUISITE.getXmlValue())) {
            placement.setPrerequisite(PlanFactory.getBooleanProp(properties, key));
        }
        if (null != (stepNumbers = properties.getValues(PlanDictionary.Entry.PLACEMENT_STEP_NUMBER.getXmlValue()))) {
            for (String stepNumber : stepNumbers) {
                placement.addStepNumber(Integer.valueOf(stepNumber));
            }
        }
    }

    static void setMachineProperties(Machine machine, MultiValueProps properties) {
        List<String> list;
        Integer stepNumber;
        String value = properties.getValue(PlanDictionary.Entry.MACHINE_NAME.getXmlValue());
        if (null != value) {
            machine.setName(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_CPUS.getXmlValue()))) {
            machine.setCpus(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_DEPLOYMENT_DESC.getXmlValue()))) {
            machine.setDeploymentDescription(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_DETAILS.getXmlValue()))) {
            machine.setDetails(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_DISK_DESC.getXmlValue()))) {
            machine.setDiskDescription(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_FULL_NAME.getXmlValue()))) {
            machine.setFullName(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_IO_PATH_DESC.getXmlValue()))) {
            machine.setIoPathDescription(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_MODEL.getXmlValue()))) {
            machine.setModel(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_NETWORK_DESC.getXmlValue()))) {
            machine.setNetworkDescription(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_OS_VERSION.getXmlValue()))) {
            machine.setOsVersion(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_PLATFORM.getXmlValue()))) {
            machine.setPlatform(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_PLATFORM_NAME.getXmlValue()))) {
            machine.setPlatformName(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_RAM.getXmlValue()))) {
            machine.setRam(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_TYPE.getXmlValue()))) {
            machine.setType(value);
        }
        if (null != (value = properties.getValue(PlanDictionary.Entry.MACHINE_STD_TOPO_MACH_NAME.getXmlValue()))) {
            machine.setStdTopoMachName(value);
        }
        machine.setOptionalAllowed(PlanFactory.getBooleanProp(properties, PlanDictionary.Entry.MACHINE_IS_OPT_ALLOWED.getXmlValue()));
        machine.setOptional(PlanFactory.getBooleanProp(properties, PlanDictionary.Entry.MACHINE_IS_OPTIONAL.getXmlValue()));
        machine.setSupportsVaDistributed(PlanFactory.getBooleanProp(properties, PlanDictionary.Entry.MACHINE_SUPPORTS_VA_DISTRIBUTED.getXmlValue()));
        String prefix = PlanDictionary.Entry.MACHINE_STEP_LABEL_PREFIX.getXmlValue();
        int prefixLength = prefix.length();
        for (String string : properties.keySet()) {
            if (!string.startsWith(prefix)) continue;
            stepNumber = Integer.valueOf(string.substring(prefixLength));
            machine.addStep(stepNumber, properties.getValue(string));
        }
        prefix = PlanDictionary.Entry.MACHINE_STEP_FORCE_PREFIX.getXmlValue();
        prefixLength = prefix.length();
        for (String string : properties.keySet()) {
            if (!string.startsWith(prefix)) continue;
            stepNumber = Integer.valueOf(string.substring(prefixLength));
            machine.markStepAsForced(stepNumber);
        }
        List<String> purposes = properties.getValues(PlanDictionary.Entry.MACHINE_PURPOSE.getXmlValue());
        if (null != purposes) {
            for (String purpose : purposes) {
                machine.addPurpose(purpose);
            }
        }
        if (null != (list = properties.getValues(PlanDictionary.Entry.MACHINE_DERIVED_PURPOSE.getXmlValue()))) {
            for (String derivedPurpose : list) {
                machine.addDerivedPurpose(derivedPurpose);
            }
        }
    }
}

