/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Component;
import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.Offering;
import com.sas.dplycmn.planning.Placement;
import com.sas.dplycmn.planning.Plan;

public class PlanDictionary {
    private static final String PREFIX_PLAN = "PLAN_";
    private static final String PREFIX_MACHINE = "MACHINE_";
    private static final String PREFIX_OFFERING = "OFFERING_";
    private static final String PREFIX_COMPONENT = "COMPONENT_";
    private static final String PREFIX_PLACEMENT = "PLACEMENT_";

    private PlanDictionary() {
    }

    private static Entry find(String xmlValue, String prefix) {
        for (Entry entry : Entry.values()) {
            if (!xmlValue.equals(entry.xmlValue) || !entry.name().startsWith(prefix)) continue;
            return entry;
        }
        return null;
    }

    public static String getPlanValue(Plan plan, String lookup) {
        Entry entry = PlanDictionary.find(lookup, PREFIX_PLAN);
        if (null == entry) {
            return null;
        }
        return entry.getValue(plan);
    }

    public static String getMachineValue(Machine machine, String lookup) {
        Entry entry = PlanDictionary.find(lookup, PREFIX_MACHINE);
        if (null == entry) {
            return null;
        }
        return entry.getValue(machine);
    }

    public static String getOfferingValue(Offering offering, String lookup) {
        Entry entry = PlanDictionary.find(lookup, PREFIX_OFFERING);
        if (null == entry) {
            return PlanDictionary.getComponentValue(offering, lookup);
        }
        return entry.getValue(offering);
    }

    public static String getPlacementValue(Placement placement, String lookup) {
        Entry entry = PlanDictionary.find(lookup, PREFIX_PLACEMENT);
        if (null == entry) {
            return PlanDictionary.getComponentValue(placement, lookup);
        }
        return entry.getValue(placement);
    }

    public static String getComponentValue(Component component, String lookup) {
        Entry entry = PlanDictionary.find(lookup, PREFIX_COMPONENT);
        if (null == entry) {
            return null;
        }
        return entry.getValue(component);
    }

    public static enum Entry {
        PLAN_CONFIG_DIRECTORY("ConfigDirectory", "Configuration directory"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getConfigDirectory();
            }
        }
        ,
        PLAN_CREATED_BY("CreatedBy", "Created by"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getCreatedBy();
            }
        }
        ,
        PLAN_ORDER_NUMBER("OrderNumber", "Order number"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getOrderNumber();
            }
        }
        ,
        PLAN_CUSTOMER_NAME("CustomerName", "Customer name"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getCustomerName();
            }
        }
        ,
        PLAN_DESCRIPTION("PlanDetails", "Plan description"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getPlanDescription();
            }
        }
        ,
        PLAN_TS_SITE_NUMBER("TSSiteNumber", "Tech Support site number"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getTechSupportSiteNumber();
            }
        }
        ,
        PLAN_SITE_ID("SiteID", "Site ID"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getSiteId();
            }
        }
        ,
        PLAN_SAS_VERSION("SasVersion", "SAS version"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getSasVersion();
            }
        }
        ,
        PLAN_SHIP_EVENT("ShipEvent", "Ship event"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getShipEvent();
            }
        }
        ,
        PLAN_MAINT_LEVEL("MaintLevel", "Foundation Maintenance Level"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getMaintLevel();
            }
        }
        ,
        PLAN_AS_OF_DATE("AsOfDate", "Plan as-of date"),
        PLAN_LAST_MODIFIED("LastModified", "Last Modified"),
        PLAN_IS_VALID("IsPlanValid", "Valid plan"),
        PLAN_IS_POWER_MODE("PowerMode", "Power mode"),
        PLAN_IS_SEQUENCE_ENSURED("IsSequenceEnsured", "Sequence is ensured"),
        PLAN_STANDARD_TOPOLOGY("StandardTopology", "Standard Topology"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getStandardTopology().getName();
            }
        }
        ,
        PLAN_BUILD_DETAILS("BuildDetails", "Build details"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getBuildDetails();
            }
        }
        ,
        COMPONENT_CODE("ProductIdentifier", "Product code"){

            @Override
            public String getValue(Object object) {
                return ((Component)object).getCode();
            }
        }
        ,
        COMPONENT_EXT_VERSION("SoftwareVersion", "External version"){

            @Override
            public String getValue(Object object) {
                return ((Component)object).getExternalVersion();
            }
        }
        ,
        COMPONENT_NAME("ProductName", "Product name"){

            @Override
            public String getValue(Object object) {
                return ((Component)object).getName();
            }
        }
        ,
        COMPONENT_INT_VERSION("InternalVersion", "Internal version"){

            @Override
            public String getValue(Object object) {
                return ((Component)object).getInternalVersion();
            }
        }
        ,
        COMPONENT_PROD_STATUS("ProductionStatus", "Production status"){

            @Override
            public String getValue(Object object) {
                return ((Component)object).getProductionStatus();
            }
        }
        ,
        OFFERING_AS_OF_DATE("AsOfDate", "Offering as-of date"),
        OFFERING_USER_SELECTED("UserSelected", "Offering user selected"),
        PLACEMENT_PLATFORM("Platform", "Placement platform"){

            @Override
            public String getValue(Object object) {
                return ((Placement)object).getPlatform();
            }
        }
        ,
        PLACEMENT_IS_FOUNDATION("IsFoundation", "Part of Foundation"),
        PLACEMENT_IS_HIDDEN("Hide", "Hide"),
        PLACEMENT_IS_PREREQUISITE("Prerequisite", "Prerequisite component"),
        PLACEMENT_STEP_NUMBER("StepNumber", "Placement deployment step number(s)"),
        PLACEMENT_INSTALL_SEQUENCE("Install Sequence", "Install Sequence"),
        PLACEMENT_CONFIG_SEQUENCE("Config Sequence", "Config Sequence"),
        MACHINE_NAME("Name", "Machine name"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getName();
            }
        }
        ,
        MACHINE_STD_TOPO_MACH_NAME("MachTopoName", "Standard Topology machine name"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getStdTopoMachName();
            }
        }
        ,
        MACHINE_CPUS("CPUs", "Machine CPU details"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getCpus();
            }
        }
        ,
        MACHINE_DEPLOYMENT_DESC("Deployment", "Machine deployment description"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getDeploymentDescription();
            }
        }
        ,
        MACHINE_DETAILS("MachineDetails", "Machine details"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getDetails();
            }
        }
        ,
        MACHINE_DISK_DESC("Disk", "Machine disk description"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getDiskDescription();
            }
        }
        ,
        MACHINE_FULL_NAME("Full Name", "Machine full name"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getFullName();
            }
        }
        ,
        MACHINE_IO_PATH_DESC("I/O Paths", "Machine I/O path description"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getIoPathDescription();
            }
        }
        ,
        MACHINE_MODEL("Model", "Machine model"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getModel();
            }
        }
        ,
        MACHINE_NETWORK_DESC("Network", "Machine network description"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getNetworkDescription();
            }
        }
        ,
        MACHINE_OS_VERSION("OS Version", "Machine OS version"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getOsVersion();
            }
        }
        ,
        MACHINE_PLATFORM("Platform", "Machine platform"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getPlatform();
            }
        }
        ,
        MACHINE_PLATFORM_NAME("PlatformName", "Machine platform name"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getPlatformName();
            }
        }
        ,
        MACHINE_RAM("RAM", "Machine RAM description"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getRam();
            }
        }
        ,
        MACHINE_TYPE("Type", "Machine type"){

            @Override
            public String getValue(Object object) {
                return ((Machine)object).getType();
            }
        }
        ,
        MACHINE_IS_OPT_ALLOWED("IsOptAllowed", "Machine allowed to be optional"){

            @Override
            public String getValue(Object object) {
                return Boolean.toString(((Machine)object).isOptionalAllowed());
            }
        }
        ,
        MACHINE_IS_OPTIONAL("IsOptional", "Machine optional"){

            @Override
            public String getValue(Object object) {
                return Boolean.toString(((Machine)object).isOptional());
            }
        }
        ,
        MACHINE_SUPPORTS_VA_DISTRIBUTED("SupportsVaDistributed", "Supports distributed VA"){

            @Override
            public String getValue(Object object) {
                return Boolean.toString(((Machine)object).supportsVaDistributed());
            }
        }
        ,
        MACHINE_PURPOSE("Purpose", "Machine purpose(s)"),
        MACHINE_DERIVED_PURPOSE("DerivedPurpose", "Machine derived purpose(s)"),
        MACHINE_STEP_LABEL_PREFIX("StepLabel_", "Machine step label prefix"),
        MACHINE_STEP_FORCE_PREFIX("StepForce_", "Machine force flag prefix"),
        PLAN_NAME("Name", "Plan name"){

            @Override
            public String getValue(Object object) {
                return ((Plan)object).getName();
            }
        }
        ,
        COMPONENT_ASOFDATE("AsOfDate", "Component as-of date"),
        RELATIONSHIP_VERBS("Desc", "Relationship verb(s)"),
        RELATIONSHIP_DELIVERS("ChangeState", "Relationship delivers"),
        INSTALLED_COMPONENT("DeployedComponent", "Installed component"),
        CONFIGURED_COMPONENT("ConfiguredComponent", "Configured component"),
        CONTAINER_ONLY_COMPONENT("SoftwareComponent", "Container-only component"),
        MACHINE("Machine", "Machine"),
        RELATIONSHIP_SUBJECT(null, "Subject"),
        RELATIONSHIP_PREDICATE(null, "Predicate"),
        RELATIONSHIP_PREDICATE_MACHINE(null, "Predicate machine name"),
        RELATIONSHIP(null, "Relationship"),
        OFFERING(null, "Offering"),
        PLACEMENT(null, "Placement"),
        PLAN(null, "Plan"),
        MACHINE_STEP_NUMBER("StepNumber", "Machine deployment step number(s)"),
        PREREQUISITE_COMPONENT(null, "Prerequisite component"),
        MACHINE_STEP_LABEL(null, "Machine deployment step label(s)"),
        MACHINE_STEP_FORCED(null, "Machine deployment forced step(s)");

        private final String xmlValue;
        private final String displayValue;

        public String getValue(Object object) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not implemented");
        }

        private Entry(String xmlValue, String displayValue) {
            this.xmlValue = xmlValue;
            this.displayValue = displayValue;
        }

        public String getXmlValue() {
            return this.xmlValue;
        }

        public String getDisplayValue() {
            return this.displayValue;
        }

        public String getName() {
            return this.name();
        }

        public String getKey() {
            return this.getName();
        }

        public static void main(String[] args) {
            for (Entry entry : Entry.values()) {
                System.out.println("[entry] name: " + entry.name() + ", XML value: " + entry.getXmlValue() + ", display value: " + entry.getDisplayValue());
            }
        }
    }
}

