/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.MachinePurpose;
import com.sas.dplycmn.planning.MachineTopology;
import com.sas.dplycmn.planning.MachineTopologyMachDef;
import com.sas.dplycmn.planning.Offering;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Plan {
    private String name = "";
    private String configDirectory = "";
    private String customerName = "";
    private String orderNumber = "";
    private String tsSiteNumber = "";
    private String siteId = "";
    private String createdBy = "";
    private String sasVersion = "9.2";
    private String shipEvent = "";
    private String maintLevel = "";
    private String planDescription = "";
    private String buildDetails = "";
    private Date asOfDate = new Date();
    private Date lastModified = new Date();
    private boolean isPlanValid = false;
    private boolean isSequenceEnsured = false;
    private boolean isPowerMode = false;
    private MachineTopology standardTopology = null;
    private List<Machine> machines = new ArrayList<Machine>();
    private SortedSet<Offering> offerings = new TreeSet<Offering>();

    boolean addMachine(Machine machine) {
        return this.machines.add(machine);
    }

    public List<Machine> getMachines() {
        return new ArrayList<Machine>(this.machines);
    }

    boolean addOffering(Offering offering) {
        return this.offerings.add(offering);
    }

    public SortedSet<Offering> getOfferings() {
        return new TreeSet<Offering>(this.offerings);
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getConfigDirectory() {
        return this.configDirectory;
    }

    void setConfigDirectory(String configDirectory) {
        this.configDirectory = configDirectory;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getTechSupportSiteNumber() {
        return this.tsSiteNumber;
    }

    void setTechSupportSiteNumber(String tsSiteNumber) {
        this.tsSiteNumber = tsSiteNumber;
    }

    public String getSiteId() {
        return this.siteId;
    }

    void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getSasVersion() {
        return this.sasVersion;
    }

    void setSasVersion(String sasVersion) {
        this.sasVersion = sasVersion;
    }

    public String getShipEvent() {
        return this.shipEvent;
    }

    public void setShipEvent(String shipEvent) {
        this.shipEvent = shipEvent;
    }

    public String getMaintLevel() {
        return this.maintLevel;
    }

    public void setMaintLevel(String maintLevel) {
        this.maintLevel = maintLevel;
    }

    public String getBuildDetails() {
        return this.buildDetails;
    }

    public void setBuildDetails(String buildDetails) {
        this.buildDetails = buildDetails;
    }

    public String getPlanDescription() {
        return this.planDescription;
    }

    void setPlanDescription(String planDescription) {
        this.planDescription = planDescription;
    }

    public Date getAsOfDate() {
        return (Date)this.asOfDate.clone();
    }

    void setAsOfDate(Date asOfDate) {
        this.asOfDate = asOfDate;
    }

    public Date getLastModified() {
        return (Date)this.lastModified.clone();
    }

    void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isPlanValid() {
        return this.isPlanValid;
    }

    void setPlanValid(boolean isPlanValid) {
        this.isPlanValid = isPlanValid;
    }

    public boolean isSequenceEnsured() {
        return this.isSequenceEnsured;
    }

    void setSequenceEnsured(boolean isSequenceEnsured) {
        this.isSequenceEnsured = isSequenceEnsured;
    }

    public boolean isPowerMode() {
        return this.isPowerMode;
    }

    void setPowerMode(boolean isPowerMode) {
        this.isPowerMode = isPowerMode;
    }

    public MachineTopology getStandardTopology() {
        return this.standardTopology;
    }

    void setStandardTopology(String standardTopologyName) {
        for (MachineTopology checkTopo : MachineTopology.values()) {
            if (!checkTopo.getName().equals(standardTopologyName)) continue;
            this.standardTopology = checkTopo;
            return;
        }
        this.standardTopology = null;
    }

    void alignStdTopoDefs() {
        Map<String, String> dedicatedNameMap = MachinePurpose.getDedicatedPurposeNames();
        if (null == this.standardTopology) {
            HashSet<String> machNames = new HashSet<String>();
            for (Machine machine : this.machines) {
                machNames.add(machine.getName());
            }
            this.standardTopology = Plan.findBestMatchTopo(machNames);
            Map<String, MachineTopologyMachDef> machMap = this.standardTopology.getMatchingMachDefs(machNames);
            for (Machine machine : this.machines) {
                String machName = machine.getName();
                if (machMap.containsKey(machName)) {
                    machine.setStdTopoMachName(machMap.get(machName).getMachineName());
                    continue;
                }
                machine.setStdTopoMachName(dedicatedNameMap.get(machName));
            }
        } else {
            Map<String, String> stdTopoMachNames = this.standardTopology.getCurrentMachineNameMap();
            for (Machine machine : this.machines) {
                String desiredStdTopoName = machine.getStdTopoMachName();
                if (stdTopoMachNames.containsKey(desiredStdTopoName)) {
                    machine.setStdTopoMachName(stdTopoMachNames.get(desiredStdTopoName));
                    continue;
                }
                machine.setStdTopoMachName(dedicatedNameMap.get(desiredStdTopoName));
            }
        }
    }

    public static MachineTopology findBestMatchTopo(Set<String> machNames) {
        MachineTopology bestMatch = null;
        int bestMatchCount = 0;
        for (MachineTopology checkTopo : MachineTopology.values()) {
            Map<String, MachineTopologyMachDef> matches = checkTopo.getMatchingMachDefs(machNames);
            int matchSize = matches.size();
            int machCount = checkTopo.getMachineDefs().size();
            boolean isBetterMatch = false;
            if (null == bestMatch) {
                isBetterMatch = true;
            } else if (matchSize > bestMatchCount) {
                isBetterMatch = true;
            } else if (matchSize == bestMatchCount) {
                int bestMachCount = bestMatch.getMachineDefs().size();
                if (machCount < bestMachCount) {
                    isBetterMatch = true;
                } else if (machCount == bestMachCount && checkTopo.isDefault()) {
                    isBetterMatch = true;
                }
            } else if (0 == bestMatchCount && checkTopo.isDefault()) {
                isBetterMatch = true;
            }
            if (!isBetterMatch) continue;
            bestMatchCount = matchSize;
            bestMatch = checkTopo;
        }
        return bestMatch;
    }

    public SortedMap<Integer, Machine> getStepsToMachines() {
        TreeMap<Integer, Machine> stepsToMachines = new TreeMap<Integer, Machine>();
        for (Machine machine : this.getMachines()) {
            for (Integer stepNum : machine.getSteps().keySet()) {
                stepsToMachines.put(stepNum, machine);
            }
        }
        return stepsToMachines;
    }

    public String createOfferingListString() {
        StringBuilder sb = new StringBuilder();
        for (Offering offering : this.offerings) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(offering.getName());
            String extVersion = offering.getExternalVersion();
            if (null == extVersion || extVersion.trim().equals("")) continue;
            sb.append(" " + extVersion);
        }
        return sb.toString();
    }
}

