/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Component;
import com.sas.dplycmn.planning.ComponentRelationship;
import com.sas.dplycmn.planning.Container;
import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.Offering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Placement
extends Component
implements Container<Placement> {
    private Container<Placement> container = null;
    private String platform = "";
    private boolean isFoundation = false;
    private boolean isHidden = false;
    private boolean isPrerequisite = false;
    private boolean isInstalled = false;
    private boolean isConfigured = false;
    private int installSequence = -1;
    private int configSequence = -1;
    private SortedSet<Integer> stepNumbers = new TreeSet<Integer>();
    private SortedSet<Placement> placements = new TreeSet<Placement>();
    private static final Set<String> ADDITIONAL_CONFIG_VERBS = new HashSet<String>(Arrays.asList("signals reconfiguration", "signals additional instance"));
    static final Comparator<Placement> INSTALL_COMPARATOR = new Comparator<Placement>(){

        @Override
        public int compare(Placement a, Placement b) {
            int installDiff = a.getInstallSequence() - b.getInstallSequence();
            if (0 != installDiff) {
                return installDiff;
            }
            return SIMPLE_COMPARATOR.compare(a, b);
        }
    };
    static final Comparator<Placement> CONFIG_COMPARATOR = new Comparator<Placement>(){

        @Override
        public int compare(Placement a, Placement b) {
            int configDiff = a.getConfigSequence() - b.getConfigSequence();
            if (0 != configDiff) {
                return configDiff;
            }
            return SIMPLE_COMPARATOR.compare(a, b);
        }
    };
    static final Comparator<Placement> SIMPLE_COMPARATOR = new Comparator<Placement>(){

        @Override
        public int compare(Placement a, Placement b) {
            int result = a.getName().compareTo(b.getName());
            if (0 != result) {
                return result;
            }
            result = a.getExternalVersion().compareTo(b.getExternalVersion());
            if (0 != result) {
                return result;
            }
            result = a.getPlatform().compareTo(b.getPlatform());
            if (0 != result) {
                return result;
            }
            result = a.compareTo(b);
            if (0 != result) {
                return result;
            }
            return a.hashCode() - b.hashCode();
        }
    };

    void setContainer(Container<Placement> container) {
        this.container = container;
    }

    public Container<Placement> getContainer() {
        return this.container;
    }

    public Machine getContainingMachine() {
        Container<Placement> curr = this.container;
        while (curr instanceof Placement) {
            curr = ((Placement)curr).getContainer();
        }
        if (curr instanceof Machine) {
            return (Machine)curr;
        }
        return null;
    }

    @Override
    public boolean addContainedItem(Placement placement) {
        placement.setContainer(this);
        return this.placements.add(placement);
    }

    @Override
    public boolean removeContainedItem(Placement placement) {
        placement.setContainer(null);
        return this.placements.remove(placement);
    }

    @Override
    public SortedSet<Placement> getContainedItems() {
        return new TreeSet<Placement>(this.placements);
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public boolean isFoundation() {
        return this.isFoundation;
    }

    public void setFoundation(boolean isFoundation) {
        this.isFoundation = isFoundation;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isPrerequisite() {
        return this.isPrerequisite;
    }

    public void setPrerequisite(boolean isPrerequisite) {
        this.isPrerequisite = isPrerequisite;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public void setConfigured(boolean isConfigured) {
        this.isConfigured = isConfigured;
    }

    public int getInstallSequence() {
        return this.installSequence;
    }

    public void setInstallSequence(int installSequence) {
        this.installSequence = installSequence;
    }

    public int getConfigSequence() {
        return this.configSequence;
    }

    public void setConfigSequence(int configSequence) {
        this.configSequence = configSequence;
    }

    public boolean isContainerOnly() {
        return !this.isInstalled() && !this.isConfigured();
    }

    public boolean isTier() {
        if (!this.isContainerOnly()) {
            return false;
        }
        for (ComponentRelationship rel : this.getRelationships()) {
            if (!this.equals(rel.getPredicate()) || !rel.isDelivers() || !(rel.getSubject() instanceof Offering)) continue;
            return true;
        }
        return false;
    }

    public void addStepNumber(Integer stepNumber) {
        this.stepNumbers.add(stepNumber);
    }

    public boolean isInStepNumber(Integer stepNumber) {
        return this.stepNumbers.contains(stepNumber);
    }

    public SortedSet<Integer> getStepNumbers() {
        return new TreeSet<Integer>(this.stepNumbers);
    }

    public List<Placement> getInstalledPlacements() {
        return Machine.getInstalledPlacements(this);
    }

    public List<Placement> getConfiguredPlacements() {
        return Machine.getAllConfiguredPlacements(this);
    }

    private boolean isRelAddlConfig(ComponentRelationship rel) {
        for (String verb : rel.getVerbs()) {
            if (!rel.getPredicate().isConfigured() || !ADDITIONAL_CONFIG_VERBS.contains(verb)) continue;
            return true;
        }
        return false;
    }

    public Set<Placement> getSignaledConfigurations() {
        HashSet<Placement> signaledPlcs = new HashSet<Placement>();
        if (!this.isConfigured()) {
            return signaledPlcs;
        }
        for (ComponentRelationship rel : this.getRelationships()) {
            if (!this.equals(rel.getSubject()) || !this.isRelAddlConfig(rel)) continue;
            signaledPlcs.add(rel.getPredicate());
        }
        return signaledPlcs;
    }
}

