/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.MachinePurpose;
import com.sas.dplycmn.planning.MachineTopologyTarget;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class MachineTopologyMachDef {
    private final String machineName;
    private final SortedSet<MachineTopologyTarget> topologyTargets;
    private final Set<String> aliases = new HashSet<String>();

    MachineTopologyMachDef(String machineName, MachineTopologyTarget ... topologyTargets) {
        this.machineName = machineName;
        this.topologyTargets = new TreeSet<MachineTopologyTarget>(Arrays.asList(topologyTargets));
    }

    public MachineTopologyMachDef addAliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    public Set<String> getAliases() {
        return new HashSet<String>(this.aliases);
    }

    public String getMachineName() {
        return this.machineName;
    }

    public SortedSet<MachineTopologyTarget> getTopologyTargets() {
        return new TreeSet<MachineTopologyTarget>(this.topologyTargets);
    }

    public SortedSet<MachinePurpose> getPurposes() {
        TreeSet<MachinePurpose> purposes = new TreeSet<MachinePurpose>();
        block0: for (MachinePurpose purpose : MachinePurpose.values()) {
            SortedSet<MachineTopologyTarget> purposeTargets = purpose.getTopologyTargets();
            for (MachineTopologyTarget target : this.topologyTargets) {
                if (!purposeTargets.contains((Object)target)) continue;
                purposes.add(purpose);
                continue block0;
            }
        }
        return purposes;
    }
}

