/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Machine;

public enum MachineDescriptionItem {
    TYPE("Type", "Type", false){

        @Override
        public String getValue(Machine machine) {
            return machine.getType();
        }
    }
    ,
    MODEL("Model", "Model", false){

        @Override
        public String getValue(Machine machine) {
            return machine.getModel();
        }
    }
    ,
    OS_VERSION("OSVersion", "OS Version", false, true){

        @Override
        public String getValue(Machine machine) {
            return machine.getOsVersion();
        }
    }
    ,
    CPUS("CPUs", "CPU(s)", false, true){

        @Override
        public String getValue(Machine machine) {
            return machine.getCpus();
        }
    }
    ,
    RAM("RAM", "RAM", false, true){

        @Override
        public String getValue(Machine machine) {
            return machine.getRam();
        }
    }
    ,
    DISK("Disk", "Disk", false, true){

        @Override
        public String getValue(Machine machine) {
            return machine.getDiskDescription();
        }
    }
    ,
    NETWORK("Network", "Network", false){

        @Override
        public String getValue(Machine machine) {
            return machine.getNetworkDescription();
        }
    }
    ,
    IO_PATHS("IOPaths", "I/O Paths", true){

        @Override
        public String getValue(Machine machine) {
            return machine.getIoPathDescription();
        }
    }
    ,
    DEPLOYMENT("Deployment", "Deployment", true){

        @Override
        public String getValue(Machine machine) {
            return machine.getDeploymentDescription();
        }
    };

    private final String canonicalName;
    private final String displayName;
    private final boolean isMultiline;
    private final boolean isAlwaysPresent;

    public abstract String getValue(Machine var1);

    private MachineDescriptionItem(String canonicalName, String displayName, boolean isMultiline, boolean isAlwaysPresent) {
        this.canonicalName = canonicalName;
        this.displayName = displayName;
        this.isMultiline = isMultiline;
        this.isAlwaysPresent = isAlwaysPresent;
    }

    private MachineDescriptionItem(String canonicalName, String displayName, boolean isMultiline) {
        this(canonicalName, displayName, isMultiline, false);
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public boolean isAlwaysPresent() {
        return this.isAlwaysPresent;
    }

    public static MachineDescriptionItem getItem(String lookup) {
        MachineDescriptionItem fallback = null;
        for (MachineDescriptionItem descItem : MachineDescriptionItem.values()) {
            if (descItem.getCanonicalName().equals(lookup)) {
                return descItem;
            }
            if (!descItem.getDisplayName().equals(lookup)) continue;
            fallback = descItem;
        }
        return fallback;
    }
}

