/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Component;
import com.sas.dplycmn.planning.Placement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ComponentRelationship {
    public static final String VERB_DEPLOYS_UNDER = "deploys under";
    private Component subject = null;
    private List<String> verbs = null;
    private Placement predicate = null;
    private boolean delivers = false;

    ComponentRelationship(Component subject, List<String> verbs, Placement predicate, boolean delivers) {
        this.subject = subject;
        this.verbs = null == verbs ? new ArrayList<String>() : new ArrayList<String>(verbs);
        this.predicate = predicate;
        this.delivers = delivers;
    }

    ComponentRelationship(Component subject, String verbs, Placement predicate, boolean delivers) {
        this(subject, (List<String>)null, predicate, delivers);
        this.setVerbs(verbs);
    }

    public Component getSubject() {
        return this.subject;
    }

    void setSubject(Component subject) {
        this.subject = subject;
    }

    public Placement getPredicate() {
        return this.predicate;
    }

    void setPredicate(Placement predicate) {
        this.predicate = predicate;
    }

    public List<String> getVerbs() {
        return new ArrayList<String>(this.verbs);
    }

    void setVerbs(String verbs) {
        if (null == verbs) {
            this.verbs = new ArrayList<String>();
            return;
        }
        if (verbs.contains(",")) {
            this.setVerbs(Arrays.asList(verbs.trim().split("\\s*,\\s*")));
        } else {
            this.verbs = new ArrayList<String>();
            this.verbs.add(verbs.trim());
        }
    }

    void setVerbs(List<String> verbs) {
        if (null == verbs) {
            this.verbs = new ArrayList<String>();
            return;
        }
        this.verbs = new ArrayList<String>(verbs);
    }

    public boolean isDelivers() {
        return this.delivers;
    }

    void setDelivers(boolean delivers) {
        this.delivers = delivers;
    }
}

