/*
 * Decompiled with CFR 0.152.
 */
package com.sas.web.services.common;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.web.services.common.BIWebServiceClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;

public class WebServiceMaker {
    public static final String METADATA_NAME = "WebServiceMaker";
    public static final String REGISTERED_SAS_APPLICATION_IDENTIFIER = "Registered SAS Application";
    public static final String BIWEBSERVICES_DOTNET_IDENTIFIER = "BI Web Services for .NET 9.2";
    public static final String BIWEBSERVICES_JAVA_IDENTIFIER = "BI Web Services for Java 9.4";
    public static final String WSSECURITY_XML_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSSECURITY_PASS_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    protected DeployedComponent deployedComponent;
    protected URL endpoint;

    public WebServiceMaker(DeployedComponent deployedComponent) {
        this.deployedComponent = deployedComponent;
    }

    public WebServiceMaker(URL endpoint) {
        this.endpoint = endpoint;
    }

    public URL getEndpoint() throws RemoteException, MdException {
        if (this.endpoint == null && this.deployedComponent != null) {
            TCPIPConnection tcpipConnection = null;
            boolean useJavaInference = false;
            int numConnections = this.deployedComponent.getSourceConnections().size();
            if (this.deployedComponent.getSourceConnections() != null && numConnections > 0) {
                for (Object connection : this.deployedComponent.getSourceConnections()) {
                    if (!(connection instanceof TCPIPConnection)) continue;
                    tcpipConnection = (TCPIPConnection)connection;
                    break;
                }
            } else {
                SoftwareComponent parentSC = this.deployedComponent.getDescriptiveComponent();
                if (parentSC != null && parentSC.getName().equals(BIWEBSERVICES_JAVA_IDENTIFIER)) {
                    Iterator it = parentSC.getDeployedComponents().iterator();
                    while (it.hasNext()) {
                        DeployedComponent dc = (DeployedComponent)it.next();
                        if (!dc.getName().equals(REGISTERED_SAS_APPLICATION_IDENTIFIER)) continue;
                        if (dc.getSourceConnections() != null) {
                            Object connection;
                            Iterator scIt = dc.getSourceConnections().iterator();
                            if (it.hasNext() && (connection = scIt.next()) instanceof TCPIPConnection) {
                                tcpipConnection = (TCPIPConnection)connection;
                                useJavaInference = true;
                            }
                        }
                        if (tcpipConnection == null) continue;
                        break;
                    }
                }
            }
            if (tcpipConnection != null) {
                try {
                    String path = tcpipConnection.getService();
                    if (useJavaInference) {
                        if (!path.endsWith("/")) {
                            path = path + "/";
                        }
                        path = path + "services/WebServiceMaker";
                    }
                    this.endpoint = new URL(tcpipConnection.getCommunicationProtocol(), tcpipConnection.getHostName(), tcpipConnection.getPort(), path);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return this.endpoint;
    }

    public void deleteService(String serviceName, String username, String password) throws RemoteException, MdException, AxisFault {
        BIWebServiceClient client = new BIWebServiceClient(this.getEndpoint(), "http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2/RemoveWebService", username, password);
        SOAPHeaderBlock securityElement = WebServiceMaker.getSecurityElement(username, password);
        client.addHeader(securityElement);
        OMElement payload = WebServiceMaker.GetRemoveWebServiceElement(serviceName);
        client.sendReceive(payload);
    }

    public void deleteService(String serviceName, UserContextInterface userContext) throws ServiceException, RemoteException, MdException {
        Credentials creds = WebServiceMaker.GetOTP(userContext);
        this.deleteService(serviceName, creds.username, creds.password);
    }

    public URL makeWebService(String webServiceName, String[] stps, String namespace, String[] keywords, String username, String password, boolean createMetadata) throws AxisFault, RemoteException, MdException, MalformedURLException {
        if (stps == null || stps.length < 1) {
            throw new IllegalArgumentException("You must include stored processes to create a web service");
        }
        BIWebServiceClient client = new BIWebServiceClient(this.getEndpoint(), "http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2/MakeWebService", username, password);
        SOAPHeaderBlock securityElement = WebServiceMaker.getSecurityElement(username, password);
        client.addHeader(securityElement);
        OMElement payload = WebServiceMaker.getMakeWebServiceElement(webServiceName, stps, namespace, keywords, createMetadata);
        OMElement result = client.sendReceive(payload);
        if (result != null) {
            OMElement elem = result.getFirstElement();
            String wsUrl = elem.getText();
            if (wsUrl != null && wsUrl.length() > 0) {
                return new URL(wsUrl);
            }
            return null;
        }
        throw new AxisFault("Web Service Maker did not return a result");
    }

    public URL makeWebService(String webServiceName, String[] stps, String namespace, String[] keywords, UserContextInterface userContext, boolean createMetadata) throws AxisFault, RemoteException, MdException, MalformedURLException, ServiceException {
        if (stps == null || stps.length < 1) {
            throw new IllegalArgumentException("You must include stored processes to create a web service");
        }
        Credentials creds = WebServiceMaker.GetOTP(userContext);
        return this.makeWebService(webServiceName, stps, namespace, keywords, creds.username, creds.password, createMetadata);
    }

    public List listWebServices(UserContextInterface userContext) throws AxisFault, RemoteException, MdException, ServiceException {
        ArrayList<String> retList = new ArrayList<String>();
        Credentials creds = WebServiceMaker.GetOTP(userContext);
        BIWebServiceClient client = new BIWebServiceClient(this.getEndpoint(), "http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2/ListWebServices", creds.username, creds.password);
        SOAPHeaderBlock securityElement = WebServiceMaker.getSecurityElement(creds.username, creds.password);
        OMElement payload = WebServiceMaker.getListWebServicesElement();
        client.addHeader(securityElement);
        OMElement result = client.sendReceive(payload);
        if (result != null) {
            OMElement listResult = result.getFirstElement();
            Iterator children = listResult.getChildren();
            while (children.hasNext()) {
                OMElement elem = (OMElement)children.next();
                if (!elem.getLocalName().equals("string")) continue;
                String serviceName = elem.getText();
                retList.add(serviceName);
            }
        }
        return retList;
    }

    public static OMElement GetRemoveWebServiceElement(String serviceName) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2", "");
        OMElement method = fac.createOMElement("RemoveWebService", omNs);
        OMElement serviceNameEl = fac.createOMElement("serviceName", omNs);
        OMText serviceNameText = fac.createOMText((OMContainer)serviceNameEl, serviceName);
        serviceNameEl.addChild((OMNode)serviceNameText);
        method.addChild((OMNode)serviceNameEl);
        return method;
    }

    protected static Credentials GetOTP(UserContextInterface userContext) throws ServiceException, RemoteException {
        Credentials creds = new Credentials();
        ServerInterface authServer = userContext.getAuthServer();
        UserIdentityInterface id = authServer.generatePassword(null);
        creds.username = id.getPrincipal().toString();
        creds.password = id.getCredential().toString();
        return creds;
    }

    public static OMElement getMakeWebServiceElement(String webServiceName, String[] stps, String namespace, String[] keywords, boolean createMetadata) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2", "");
        OMElement method = fac.createOMElement("MakeWebService", omNs);
        OMElement stringElement = null;
        OMText stringElementText = null;
        OMElement storedProcessPaths = fac.createOMElement("storedProcessPaths", omNs);
        for (int i = 0; i < stps.length; ++i) {
            stringElement = fac.createOMElement("string", omNs);
            stringElementText = fac.createOMText((OMContainer)stringElement, stps[i]);
            stringElementText.setOptimize(false);
            stringElement.addChild((OMNode)stringElementText);
            storedProcessPaths.addChild((OMNode)stringElement);
        }
        method.addChild((OMNode)storedProcessPaths);
        OMElement serviceName = fac.createOMElement("serviceName", omNs);
        OMText serviceNameText = fac.createOMText((OMContainer)serviceName, webServiceName);
        serviceNameText.setOptimize(false);
        serviceName.addChild((OMNode)serviceNameText);
        method.addChild((OMNode)serviceName);
        OMElement serviceNamespace = fac.createOMElement("serviceNamespace", omNs);
        if (namespace != null) {
            OMText serviceNamespaceText = fac.createOMText((OMContainer)serviceNamespace, namespace);
            serviceNamespaceText.setOptimize(false);
            serviceNamespace.addChild((OMNode)serviceNamespaceText);
        }
        method.addChild((OMNode)serviceNamespace);
        OMElement keywordsEl = fac.createOMElement("keywords", omNs);
        if (keywords != null) {
            for (int i = 0; i < keywords.length; ++i) {
                stringElement = fac.createOMElement("string", omNs);
                stringElementText = fac.createOMText((OMContainer)stringElement, keywords[i]);
                stringElementText.setOptimize(false);
                stringElement.addChild((OMNode)stringElementText);
                keywordsEl.addChild((OMNode)stringElement);
            }
        }
        method.addChild((OMNode)keywordsEl);
        OMElement publishMetadataEl = fac.createOMElement("publishMetadata", omNs);
        OMText publishMetadataText = fac.createOMText((OMContainer)publishMetadataEl, String.valueOf(createMetadata));
        publishMetadataEl.addChild((OMNode)publishMetadataText);
        method.addChild((OMNode)publishMetadataEl);
        return method;
    }

    public static OMElement getListWebServicesElement() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2", "");
        OMElement method = fac.createOMElement("ListWebServices", omNs);
        return method;
    }

    public static SOAPHeaderBlock getSecurityElement(String userName, String password) {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        OMNamespace securityOMNamespace = soapFactory.createOMNamespace(WSSECURITY_XML_NAMESPACE, "wsse");
        SOAPHeaderBlock soapHeader = soapFactory.createSOAPHeaderBlock("Security", securityOMNamespace);
        SOAPHeaderBlock userTokenSOAPHeaderBlock = soapFactory.createSOAPHeaderBlock("UsernameToken", securityOMNamespace);
        SOAPHeaderBlock userNameSOAPHeaderBlock = soapFactory.createSOAPHeaderBlock("Username", securityOMNamespace);
        userNameSOAPHeaderBlock.setText(userName);
        SOAPHeaderBlock passwordNameSOAPHeaderBlock = soapFactory.createSOAPHeaderBlock("Password", securityOMNamespace);
        passwordNameSOAPHeaderBlock.addAttribute("Type", WSSECURITY_PASS_TYPE, null);
        passwordNameSOAPHeaderBlock.setText(password);
        userTokenSOAPHeaderBlock.addChild((OMNode)userNameSOAPHeaderBlock);
        userTokenSOAPHeaderBlock.addChild((OMNode)passwordNameSOAPHeaderBlock);
        soapHeader.addChild((OMNode)userTokenSOAPHeaderBlock);
        return soapHeader;
    }

    protected static class Credentials {
        public String username;
        public String password;

        protected Credentials() {
        }
    }
}

