/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.util.validators;

import com.sas.taglib.util.validators.RB;
import com.sas.taglib.util.validators.ValidationInterface;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CoreTagLibraryValidator
extends TagLibraryValidator {
    public static final String RB_KEY = "CoreTagLibraryValidator.";
    protected Document subtagXML;
    protected String subtagXMLFile;
    protected ArrayList messageList = new ArrayList();

    public ValidationMessage[] validate(String prefix, String uri, PageData pageData) {
        Map initParams = this.getInitParameters();
        this.subtagXMLFile = (String)initParams.get("short-name") + "TLV.xml";
        this.subtagXML = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document originalDoc = db.parse(pageData.getInputStream());
            if (this.subtagXMLFile == null || this.subtagXMLFile.length() <= 0) {
                return null;
            }
            this.subtagXML = db.parse(((Object)((Object)this)).getClass().getResourceAsStream(this.subtagXMLFile));
            Element root = originalDoc.getDocumentElement();
            NodeList nl = root.getChildNodes();
            int length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                Node currentNode = nl.item(i);
                String currentNodeName = currentNode.getNodeName();
                if (!currentNodeName.startsWith(prefix + ":")) continue;
                this.validateNode(prefix, uri, currentNode);
            }
        }
        catch (Exception e) {
            String message = RB.getStringResource(RB_KEY, "exception.txt");
            this.messageList.add(new ValidationMessage("", MessageFormat.format(message, e.getMessage())));
        }
        if (this.messageList.isEmpty()) {
            return null;
        }
        return this.messageList.toArray(new ValidationMessage[0]);
    }

    public void validateNode(String prefix, String uri, Node node) {
        String message;
        Element xmlRoot = this.subtagXML.getDocumentElement();
        NodeList xmlNodeList = xmlRoot.getChildNodes();
        Element xmlNode = null;
        String nodeName = node.getNodeName().substring(prefix.length() + 1);
        HashSet multipleSet = new HashSet(1);
        int xmlNodeListLength = xmlNodeList.getLength();
        for (int i = 0; i < xmlNodeListLength; ++i) {
            if (!xmlNodeList.item(i).getNodeName().equals("tag") || !((Element)xmlNodeList.item(i)).getAttribute("name").equals(nodeName)) continue;
            xmlNode = (Element)xmlNodeList.item(i);
            break;
        }
        if (xmlNode == null) {
            return;
        }
        NodeList vList = xmlNode.getElementsByTagName("tag-validator-class");
        if (vList != null && vList.getLength() > 0) {
            Node n = vList.item(0).getFirstChild();
            String vclass = null;
            if (n.getNodeType() == 3) {
                vclass = ((Text)n).getData();
            }
            try {
                Class<?> c = Class.forName(vclass);
                Constructor<?> cons = c.getConstructor(null);
                ValidationInterface v = (ValidationInterface)cons.newInstance(null);
                v.validate(prefix, uri, node, this.messageList);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
        NamedNodeMap attrMap = node.getAttributes();
        Node idNode = attrMap.getNamedItem("id");
        Node instantiateNode = attrMap.getNamedItem("instantiate");
        Node refNode = attrMap.getNamedItem("ref");
        if (idNode == null) {
            if (instantiateNode != null) {
                message = RB.getStringResource(RB_KEY, "instantiateError.txt");
                this.messageList.add(new ValidationMessage("", MessageFormat.format(message, node.getNodeName())));
            } else if (refNode != null && refNode.getNodeValue().length() == 0) {
                message = RB.getStringResource(RB_KEY, "emptyStringError.txt");
                this.messageList.add(new ValidationMessage("", MessageFormat.format(message, node.getNodeName(), "ref")));
            }
        } else if (idNode.getNodeValue().length() == 0) {
            message = RB.getStringResource(RB_KEY, "emptyStringError.txt");
            this.messageList.add(new ValidationMessage("", MessageFormat.format(message, node.getNodeName(), "id")));
        }
        NodeList children = node.getChildNodes();
        int childrenLength = children.getLength();
        for (int j = 0; j < childrenLength; ++j) {
            String message2;
            Node currentSubtag = children.item(j);
            if (!currentSubtag.getNodeName().startsWith(prefix + ":")) continue;
            if (multipleSet != null && multipleSet.remove(currentSubtag.getNodeName().substring(prefix.length() + 1))) {
                message2 = RB.getStringResource(RB_KEY, "multipleNestError.txt");
                this.messageList.add(new ValidationMessage("", MessageFormat.format(message2, currentSubtag.getNodeName(), node.getNodeName())));
                continue;
            }
            if (!this.isValidSubtag(xmlNode, currentSubtag.getNodeName().substring(prefix.length() + 1), multipleSet)) {
                message2 = RB.getStringResource(RB_KEY, "nestError.txt");
                this.messageList.add(new ValidationMessage("", MessageFormat.format(message2, currentSubtag.getNodeName(), node.getNodeName())));
            }
            if (!currentSubtag.hasChildNodes()) continue;
            this.validateNode(prefix, uri, currentSubtag);
        }
    }

    public boolean isValidSubtag(Element tag, String subtag, HashSet multipleSet) {
        NodeList allow = tag.getElementsByTagName("allow-all");
        if (allow != null && allow.getLength() > 0) {
            return true;
        }
        if (tag.hasChildNodes()) {
            NodeList nl = tag.getChildNodes();
            int length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                if (!nl.item(i).getNodeName().equals("subtag") || !((Element)nl.item(i)).getAttribute("name").equals(subtag)) continue;
                if (((Element)nl.item(i)).getAttribute("multiple").equals("false")) {
                    multipleSet.add(subtag);
                }
                return true;
            }
        }
        return false;
    }
}

