/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.servlet.tbeans.tableview;

import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.taglib.BaseBodyTag;
import com.sas.taglib.servlet.tbeans.tableview.TableViewTag;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;

public class ColumnsTag
extends BaseBodyTag {
    private Boolean orderColumns;
    private ArrayList order;
    private String sortOrder;
    ArrayList heldLeft = new ArrayList();
    ArrayList heldRight = new ArrayList();
    List sortColumns = new ArrayList();
    List sortDirections = new ArrayList();

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.orderColumns = null;
            this.order = null;
            this.sortOrder = null;
        }
        this.heldLeft = new ArrayList();
        this.heldRight = new ArrayList();
        this.sortColumns = new ArrayList();
        this.sortDirections = new ArrayList();
    }

    public void setOrderColumns(boolean orderColumns) {
        this.orderColumns = orderColumns ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isOrderColumns() {
        if (this.orderColumns != null) {
            return this.orderColumns;
        }
        return false;
    }

    public void setOrder(ArrayList indexList) {
        this.order = indexList;
    }

    public ArrayList getOrder() {
        return this.order;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public int doEndTag() throws JspException {
        ArrayList order = this.getOrder();
        if (this.isOrderColumns() && order != null) {
            TableView table = (TableView)((TableViewTag)this.getParent()).getWrappedObject();
            TableColumnModel cm = table.getColumnModel();
            int numColumns = cm.getColumnCount();
            int[] setOrderList = new int[numColumns];
            Object[] orderListColumnModelIndexes = order.toArray();
            int nonOrderedColumnsCurrentIndex = orderListColumnModelIndexes.length;
            for (int i = 0; i < numColumns; ++i) {
                int modelIndex = cm.getColumn(i).getModelIndex();
                boolean found = false;
                for (int j = 0; j < orderListColumnModelIndexes.length; ++j) {
                    int temp = (Integer)orderListColumnModelIndexes[j];
                    if (modelIndex != temp) continue;
                    setOrderList[j] = i;
                    found = true;
                    break;
                }
                if (found) continue;
                setOrderList[nonOrderedColumnsCurrentIndex] = i;
                ++nonOrderedColumnsCurrentIndex;
            }
            cm.setColumnOrder(setOrderList);
        }
        this.doHoldColumns();
        this.doSortColumns();
        return 6;
    }

    public void addHeld(String hold, TableColumn column) {
        if (hold == null || hold.length() == 0) {
            return;
        }
        if (hold.equals("LEFT")) {
            this.heldLeft.add(column);
        } else if (hold.equals("RIGHT")) {
            this.heldRight.add(column);
        }
    }

    private void doHoldColumns() throws JspException {
        TableView table = (TableView)((TableViewTag)this.getParent()).getWrappedObject();
        if (this.heldLeft.size() > 0 || this.heldRight.size() > 0) {
            table.getColumnHeader().setHoldingEnabled(true);
        }
        List heldLeftIndices = this.findHeldIndices(table, this.heldLeft);
        List heldRightIndices = this.findHeldIndices(table, this.heldRight);
        this.doHolds(table, heldLeftIndices, 2);
        this.doHolds(table, heldRightIndices, 4);
        table.initializeColumnNumbers();
    }

    private List findHeldIndices(TableView table, List held) {
        ArrayList<Integer> heldIndices = new ArrayList<Integer>(held.size());
        for (int i = 0; i < held.size(); ++i) {
            TableColumn col = (TableColumn)held.get(i);
            heldIndices.add(new Integer(col.getModelIndex()));
        }
        return heldIndices;
    }

    private void doHolds(TableView table, List held, int side) {
        for (int i = 0; i < held.size(); ++i) {
            Integer col = (Integer)held.get(i);
            table.getColumnHeader().hold(col.intValue(), side);
        }
    }

    public void addSort(String sort, TableColumn column) {
        if (sort == null || sort.length() == 0) {
            return;
        }
        this.sortColumns.add(new Integer(column.getModelIndex()));
        if (sort.equalsIgnoreCase("ASCENDING")) {
            this.sortDirections.add(new Integer(0));
        } else if (sort.equalsIgnoreCase("DESCENDING")) {
            this.sortDirections.add(new Integer(1));
        }
    }

    private void doSortColumns() throws JspException {
        TableView table = (TableView)((TableViewTag)this.getParent()).getWrappedObject();
        if (this.sortOrder != null && this.sortOrder.length() > 0) {
            ArrayList sortOrderedColumns = new ArrayList();
            ArrayList sortOrderedDirections = new ArrayList();
            StringTokenizer st = new StringTokenizer(this.sortOrder, ",");
            while (st.hasMoreTokens()) {
                Integer columnValue;
                String token = st.nextToken();
                if (this.sortColumns.size() > 0 && this.sortDirections.size() > 0) {
                    columnValue = new Integer(token);
                    int index = this.sortColumns.indexOf(columnValue);
                    if (index > -1) {
                        sortOrderedColumns.add(this.sortColumns.get(index));
                        sortOrderedDirections.add(this.sortDirections.get(index));
                        continue;
                    }
                    sortOrderedColumns.add(columnValue);
                    sortOrderedDirections.add(new Integer(0));
                    continue;
                }
                columnValue = new Integer(token);
                sortOrderedColumns.add(columnValue);
                sortOrderedDirections.add(new Integer(0));
            }
            if (sortOrderedColumns.size() > 0 && sortOrderedDirections.size() > 0) {
                table.setSortedColumns(sortOrderedColumns, sortOrderedDirections);
            }
        } else if (this.sortColumns.size() > 0 && this.sortDirections.size() > 0) {
            table.setSortedColumns(this.sortColumns, this.sortDirections);
        }
    }
}

