/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.servlet.tbeans.tableview;

import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.taglib.BaseBodyTag;
import com.sas.taglib.servlet.tbeans.tableview.ColumnsTag;
import com.sas.taglib.servlet.tbeans.tableview.TableViewTag;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.jsp.JspException;

public class ColumnTag
extends BaseBodyTag {
    private Integer modelIndex;
    private String headerValue;
    private String hold;
    private String sort;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.modelIndex = null;
            this.headerValue = null;
            this.hold = null;
            this.sort = null;
        }
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = new Integer(modelIndex);
    }

    public int getModelIndex() {
        if (this.modelIndex != null) {
            return this.modelIndex;
        }
        return 0;
    }

    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    @Override
    protected void applyAttributes() throws JspException {
        try {
            super.applyAttributes();
            TableColumn column = (TableColumn)this.getWrappedObject();
            if (this.modelIndex != null) {
                column.setModelIndex(this.modelIndex.intValue());
            }
            if (this.headerValue != null) {
                column.setHeaderValue(this.headerValue);
            }
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.servlet.tbeans.tableview.TableColumn");
        }
        try {
            return super.doStartTag();
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
    }

    public int doEndTag() throws JspException {
        TableColumn column;
        ColumnsTag parent = (ColumnsTag)this.getParent();
        TableView table = (TableView)((TableViewTag)parent.getParent()).getWrappedObject();
        if (!table.getAutoCreateColumnsFromModel()) {
            column = (TableColumn)this.getWrappedObject();
            table.addColumn(column);
        } else {
            if (parent.isOrderColumns()) {
                ArrayList<Integer> order = parent.getOrder();
                if (order == null) {
                    order = new ArrayList<Integer>();
                    parent.setOrder(order);
                }
                order.add(this.modelIndex);
            }
            TableColumnModel cm = table.getColumnModel();
            column = this.getColumnFromColumnModel(this.getModelIndex(), cm);
            if (column == null) {
                column = (TableColumn)this.getWrappedObject();
                table.addColumn(column);
            } else {
                TableColumn wObject;
                if (this.headerValue != null) {
                    column.setHeaderValue(this.getHeaderValue());
                }
                if ((wObject = (TableColumn)this.getWrappedObject()).getHeaderRenderer() != null) {
                    column.setHeaderRenderer(wObject.getHeaderRenderer());
                }
                if (wObject.getCellRenderer() != null) {
                    column.setCellRenderer(wObject.getCellRenderer());
                }
                if (wObject.getCellEditor() != null) {
                    column.setCellEditor(wObject.getCellEditor());
                }
            }
        }
        parent.addHeld(this.hold, column);
        parent.addSort(this.sort, column);
        return 6;
    }

    private TableColumn getColumnFromColumnModel(int index, TableColumnModel cm) {
        Enumeration columns = cm.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn c = (TableColumn)columns.nextElement();
            if (index != c.getModelIndex()) continue;
            return c;
        }
        return null;
    }

    public String getHold() {
        return this.hold;
    }

    public void setHold(String hold) {
        this.hold = hold;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }
}

