/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.servlet.tbeans;

import com.sas.beans.Util;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.taglib.BaseBodyTag;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.TransformException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;

@SASScope(value="ALL")
public class SetPropertyTag
extends BodyTagSupport {
    private String property;
    private BaseBodyTag parentObject;

    public int doStartTag() throws JspException {
        try {
            Tag parent = this.getParent();
            if (parent != null) {
                this.parentObject = (BaseBodyTag)parent;
            }
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return super.doStartTag();
    }

    public int doAfterBody() throws JspException {
        Object tbean = this.parentObject.getWrappedObject(false);
        String value = this.getBodyContent().getString().trim();
        try {
            if (tbean instanceof BaseTransformation) {
                BaseTransformation tbeanobj = (BaseTransformation)tbean;
                if (this.property != null) {
                    String originalProperty = tbeanobj.getObjectDataProperty();
                    tbeanobj.setObjectDataProperty(this.property);
                    tbeanobj.setObjectData((Object)value);
                    tbeanobj.setObjectDataProperty(originalProperty);
                } else {
                    tbeanobj.setObjectData((Object)value);
                }
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SetPropertyTag.setProperty(tbean, this.property, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static boolean setProperty(Object obj, String property, Object value) throws TransformException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor pd = Util.getPropertyDescriptor(obj.getClass(), (String)property);
        Class<?> clazz = pd.getPropertyType();
        Object transformedValue = BaseTransforms.defaultInstance.transform(value, clazz);
        pd.getWriteMethod().invoke(obj, transformedValue);
        return true;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }
}

