/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.servlet.tbeans;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.html.Calendar;
import com.sas.servlet.tbeans.html.DatePicker;
import com.sas.taglib.servlet.tbeans.BaseTransformationBodyTag;
import java.util.Date;
import javax.servlet.jsp.JspException;

@SASScope
public class DatePickerTag
extends BaseTransformationBodyTag {
    protected Boolean displayTodayLine;
    protected Boolean displayWeekNumbers;
    protected Boolean startOnMonday;
    protected Date selectionStartDate;
    protected Date selectionEndDate;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.displayTodayLine = null;
            this.displayWeekNumbers = null;
            this.startOnMonday = null;
            this.selectionStartDate = null;
            this.selectionEndDate = null;
        }
    }

    public void setStartOnMonday(boolean start) {
        this.startOnMonday = new Boolean(start);
    }

    public void setDisplayWeekNumbers(boolean display) {
        this.displayWeekNumbers = new Boolean(display);
    }

    public void setDisplayTodayLine(boolean display) {
        this.displayTodayLine = new Boolean(display);
    }

    public void setSelectionEndDate(Date date) {
        this.selectionEndDate = date instanceof Date ? new Date(date.getTime()) : null;
    }

    public void setSelectionStartDate(Date date) {
        this.selectionStartDate = date instanceof Date ? new Date(date.getTime()) : null;
    }

    public boolean isStartOnMonday() {
        return this.startOnMonday;
    }

    public boolean isDisplayWeekNumbers() {
        return this.displayWeekNumbers;
    }

    public boolean isDisplayTodayLine() {
        return this.displayTodayLine;
    }

    public Date getSelectionEndDate() {
        if (this.selectionEndDate != null) {
            return new Date(this.selectionEndDate.getTime());
        }
        return null;
    }

    public Date getSelectionStartDate() {
        if (this.selectionStartDate != null) {
            return new Date(this.selectionStartDate.getTime());
        }
        return null;
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.servlet.tbeans." + this.getRenderType() + ".DatePicker");
        }
        return super.doStartTag();
    }

    @Override
    protected void applyAttributes() throws JspException {
        super.applyAttributes();
        DatePicker datePicker = (DatePicker)this.getWrappedObject();
        Calendar cal = (Calendar)datePicker.getComponent("CALENDAR_COMPONENT");
        if (this.displayTodayLine != null) {
            cal.setDisplayToday(this.displayTodayLine.booleanValue());
        }
        if (this.displayWeekNumbers != null) {
            cal.setDisplayWeekNumbers(this.displayWeekNumbers.booleanValue());
        }
        if (this.startOnMonday != null) {
            if (this.startOnMonday.booleanValue()) {
                cal.setWeekStartingDay(2);
            } else {
                cal.setWeekStartingDay(1);
            }
        }
        cal.setSelectionDateRange(this.selectionStartDate, this.selectionEndDate);
    }
}

