/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.taglib.graphics.components.BaseBasicStrokeTag;
import com.sas.taglib.graphics.components.BaseDashSegmentTag;
import java.awt.BasicStroke;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

@SASScope(value="DEFAULT")
public class DashSegmentTag
extends BaseDashSegmentTag {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int doStartTag() throws JspException {
        try {
            Tag parent = this.getParent();
            if (parent != null && !(parent instanceof BaseBasicStrokeTag)) return super.doStartTag();
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        try {
            Tag parent = this.getParent();
            Tag grandParent = null;
            if (parent != null && parent instanceof BaseBasicStrokeTag) {
                BasicStroke basicStroke = (BasicStroke)((BaseBasicStrokeTag)parent).getWrappedObject();
                grandParent = this.getParent().getParent();
                boolean dashSegmentsChanged = ((BaseBasicStrokeTag)parent).isDashSegmentsChanged();
                float[] dashSegments = basicStroke.getDashArray();
                if (!dashSegmentsChanged) {
                    ((BaseBasicStrokeTag)parent).setDashSegmentsChanged(true);
                    dashSegments = new float[1];
                } else {
                    float[] tempDashSegments = dashSegments;
                    dashSegments = new float[dashSegments.length + 1];
                    System.arraycopy(tempDashSegments, 0, dashSegments, 0, tempDashSegments.length);
                }
                dashSegments[dashSegments.length - 1] = ((Double)this.getWrappedObject()).floatValue();
                basicStroke = new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), dashSegments, basicStroke.getDashPhase());
                if (grandParent != null && grandParent instanceof StrokeLineStyle) {
                    ((StrokeLineStyle)grandParent).setStroke(basicStroke);
                }
            }
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return 6;
    }
}

