/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ShadowStyle;
import com.sas.measures.BaseLength;
import com.sas.taglib.BaseBodyTag;
import com.sas.taglib.graphics.components.StringToColor;
import java.awt.Color;
import javax.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BaseShadowStyleTag
extends BaseBodyTag {
    private Boolean visible;
    private String color;
    private String offsetX;
    private String offsetY;
    private Double softness;
    private ShadowStyle underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.visible = null;
            this.color = null;
            this.offsetX = null;
            this.offsetY = null;
            this.softness = null;
        }
        this.underlyingObject = null;
    }

    @Override
    protected void applyAttributes() throws JspException {
        Color c;
        super.applyAttributes();
        this.underlyingObject = (ShadowStyle)this.getWrappedObject();
        if (this.visible != null) {
            this.underlyingObject.setVisible(this.visible.booleanValue());
        }
        if (this.color != null && (c = StringToColor.getColorForName(this.color)) != null) {
            this.underlyingObject.setColor(c);
        }
        if (this.offsetX != null) {
            this.underlyingObject.setOffsetX(new BaseLength(this.offsetX));
        }
        if (this.offsetY != null) {
            this.underlyingObject.setOffsetY(new BaseLength(this.offsetY));
        }
        if (this.softness != null) {
            this.underlyingObject.setSoftness(this.softness.doubleValue());
        }
    }

    public String getColor() {
        return this.color;
    }

    public String getOffsetX() {
        return this.offsetX;
    }

    public String getOffsetY() {
        return this.offsetY;
    }

    public Double getSoftness() {
        return this.softness;
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setOffsetX(String offsetX) {
        this.offsetX = offsetX;
    }

    public void setOffsetY(String offsetY) {
        this.offsetY = offsetY;
    }

    public void setSoftness(Double softness) {
        this.softness = softness;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.ShadowStyle");
        }
        super.doStartTag();
        return 2;
    }
}

