/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.scatterplot.ScatterPlotModel;
import com.sas.measures.BaseLength;
import com.sas.taglib.graphics.components.BaseGraphModelTag;
import javax.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BaseScatterPlotModelTag
extends BaseGraphModelTag {
    private Boolean interpolationEnabled;
    private Boolean fillAreaEnabled;
    private Boolean markerEnabled;
    private Boolean skipMissing;
    private Double xBaseline;
    private Double yBaseline;
    private Double y2Baseline;
    private Boolean matchNeedleColor;
    private Boolean matchErrorColor;
    private Boolean matchMarkerLabelColor;
    private String minMarkerSize;
    private String maxMarkerSize;
    private String topMarkerLabelContent;
    private String bottomMarkerLabelContent;
    private ScatterPlotModel underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.interpolationEnabled = null;
            this.fillAreaEnabled = null;
            this.markerEnabled = null;
            this.skipMissing = null;
            this.xBaseline = null;
            this.yBaseline = null;
            this.y2Baseline = null;
            this.matchNeedleColor = null;
            this.matchErrorColor = null;
            this.matchMarkerLabelColor = null;
            this.minMarkerSize = null;
            this.maxMarkerSize = null;
        }
        this.underlyingObject = null;
    }

    public Boolean isFillAreaEnabled() {
        return this.fillAreaEnabled;
    }

    public Boolean isInterpolationEnabled() {
        return this.interpolationEnabled;
    }

    public Boolean isMarkerEnabled() {
        return this.markerEnabled;
    }

    public String getMaxMarkerSize() {
        return this.maxMarkerSize;
    }

    public String getMinMarkerSize() {
        return this.minMarkerSize;
    }

    public Boolean isSkipMissing() {
        return this.skipMissing;
    }

    public Boolean isMatchErrorColor() {
        return this.matchErrorColor;
    }

    public Boolean isMatchNeedleColor() {
        return this.matchNeedleColor;
    }

    public Boolean isMatchMarkerLabelColor() {
        return this.matchMarkerLabelColor;
    }

    public Double getXBaseline() {
        return this.xBaseline;
    }

    public Double getY2Baseline() {
        return this.y2Baseline;
    }

    public Double getYBaseline() {
        return this.yBaseline;
    }

    public void setFillAreaEnabled(Boolean fillAreaEnabled) {
        this.fillAreaEnabled = fillAreaEnabled;
    }

    public void setInterpolationEnabled(Boolean interpolationEnabled) {
        this.interpolationEnabled = interpolationEnabled;
    }

    public void setMarkerEnabled(Boolean markerEnabled) {
        this.markerEnabled = markerEnabled;
    }

    public void setMaxMarkerSize(String maxMarkerSize) {
        this.maxMarkerSize = maxMarkerSize;
    }

    public void setMinMarkerSize(String minMarkerSize) {
        this.minMarkerSize = minMarkerSize;
    }

    public void setSkipMissing(Boolean skipMissing) {
        this.skipMissing = skipMissing;
    }

    public void setMatchErrorColor(Boolean useErrorColor) {
        this.matchErrorColor = useErrorColor;
    }

    public void setMatchNeedleColor(Boolean useNeedleColor) {
        this.matchNeedleColor = useNeedleColor;
    }

    public void setMatchMarkerLabelColor(Boolean useLabelColor) {
        this.matchMarkerLabelColor = useLabelColor;
    }

    public void setXBaseline(Double xBaseline) {
        this.xBaseline = xBaseline;
    }

    public void setY2Baseline(Double y2Baseline) {
        this.y2Baseline = y2Baseline;
    }

    public void setYBaseline(Double yBaseline) {
        this.yBaseline = yBaseline;
    }

    public String getBottomMarkerLabelContent() {
        return this.bottomMarkerLabelContent;
    }

    public String getTopMarkerLabelContent() {
        return this.topMarkerLabelContent;
    }

    public void setBottomMarkerLabelContent(String bottomMarkerLabelContent) {
        this.bottomMarkerLabelContent = bottomMarkerLabelContent;
    }

    public void setTopMarkerLabelContent(String topMarkerLabelContent) {
        this.topMarkerLabelContent = topMarkerLabelContent;
    }

    @Override
    protected void applyAttributes() throws JspException {
        super.applyAttributes();
        this.underlyingObject = (ScatterPlotModel)this.getWrappedObject();
        if (this.interpolationEnabled != null) {
            this.underlyingObject.setInterpolationEnabled(this.interpolationEnabled.booleanValue());
        }
        if (this.fillAreaEnabled != null) {
            this.underlyingObject.setFillAreaEnabled(this.fillAreaEnabled.booleanValue());
        }
        if (this.markerEnabled != null) {
            this.underlyingObject.setMarkerEnabled(this.markerEnabled.booleanValue());
        }
        if (this.skipMissing != null) {
            this.underlyingObject.setSkipMissing(this.skipMissing.booleanValue());
        }
        if (this.xBaseline != null) {
            this.underlyingObject.setXAxisBaseline(this.xBaseline.doubleValue());
        }
        if (this.yBaseline != null) {
            this.underlyingObject.setYAxisBaseline(this.yBaseline.doubleValue());
        }
        if (this.y2Baseline != null) {
            this.underlyingObject.setY2AxisBaseline(this.yBaseline.doubleValue());
        }
        if (this.matchNeedleColor != null) {
            this.underlyingObject.setMatchNeedleColor(this.matchNeedleColor.booleanValue());
        }
        if (this.matchErrorColor != null) {
            this.underlyingObject.setMatchErrorColor(this.matchErrorColor.booleanValue());
        }
        if (this.matchMarkerLabelColor != null) {
            this.underlyingObject.setMatchMarkerLabelColor(this.matchMarkerLabelColor.booleanValue());
        }
        if (this.minMarkerSize != null) {
            this.underlyingObject.setMinimumMarkerSize(new BaseLength(this.minMarkerSize));
        }
        if (this.maxMarkerSize != null) {
            this.underlyingObject.setMaximumMarkerSize(new BaseLength(this.maxMarkerSize));
        }
        if (this.topMarkerLabelContent != null) {
            this.underlyingObject.setTopMarkerLabelContent(GraphConstants.DATA_LABEL.valueOfJSPAttribute(this.topMarkerLabelContent));
        }
        if (this.bottomMarkerLabelContent != null) {
            this.underlyingObject.setBottomMarkerLabelContent(GraphConstants.DATA_LABEL.valueOfJSPAttribute(this.bottomMarkerLabelContent));
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.scatterplot.ScatterPlotModel");
        }
        super.doStartTag();
        return 2;
    }
}

