/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.piechart.OtherThreshold;
import com.sas.graphics.components.piechart.PieChartModel;
import com.sas.taglib.graphics.components.BaseGraphModelTag;
import com.sas.taglib.graphics.components.StringToColor;
import java.awt.Color;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BasePieChartModelTag
extends BaseGraphModelTag {
    private String explodedCategories;
    private String invisibleCategories;
    private Double startAngle;
    private String sliceOrder;
    private Double otherThreshold;
    private String otherColor;
    private String otherSliceLabel;
    private Boolean labelInsideResponse;
    private Boolean labelInsidePercent;
    private Boolean labelInsideCategory;
    private Boolean labelOutsideResponse;
    private Boolean labelOutsidePercent;
    private Boolean labelOutsideCategory;
    private Integer across;
    private Integer down;
    private String responseLabelVisiblePolicy;
    private Integer donutHoleSize;
    private String donutHoleLabel;
    private Boolean reverseDirection;
    private String outsideSliceLabelPlacement;
    private String insideSliceLabelPlacement;
    private String insideSliceLabelContent;
    private String outsideSliceLabelContent;
    private String dimension;
    private String missingPolicy;
    private PieChartModel underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.explodedCategories = null;
            this.invisibleCategories = null;
            this.startAngle = null;
            this.sliceOrder = null;
            this.otherThreshold = null;
            this.otherColor = null;
            this.otherSliceLabel = null;
            this.labelInsideResponse = null;
            this.labelInsidePercent = null;
            this.labelInsideCategory = null;
            this.labelOutsideResponse = null;
            this.labelOutsidePercent = null;
            this.labelOutsideCategory = null;
            this.across = null;
            this.down = null;
            this.responseLabelVisiblePolicy = null;
            this.donutHoleSize = null;
            this.donutHoleLabel = null;
            this.reverseDirection = null;
            this.outsideSliceLabelPlacement = null;
            this.insideSliceLabelPlacement = null;
            this.insideSliceLabelContent = null;
            this.outsideSliceLabelContent = null;
            this.dimension = null;
            this.missingPolicy = null;
        }
        this.underlyingObject = null;
    }

    public Integer getAcross() {
        return this.across;
    }

    public String getDonutHoleLabel() {
        return this.donutHoleLabel;
    }

    public Integer getDonutHoleSize() {
        return this.donutHoleSize;
    }

    public Integer getDown() {
        return this.down;
    }

    public String getExplodedCategories() {
        return this.explodedCategories;
    }

    public String getInvisibleCategories() {
        return this.invisibleCategories;
    }

    public String getOtherColor() {
        return this.otherColor;
    }

    public String getOtherSliceLabel() {
        return this.otherSliceLabel;
    }

    public Double getOtherThreshold() {
        return this.otherThreshold;
    }

    public String getResponseLabelVisiblePolicy() {
        return this.responseLabelVisiblePolicy;
    }

    public String getSliceOrder() {
        return this.sliceOrder;
    }

    public Double getStartAngle() {
        return this.startAngle;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setAcross(Integer across) {
        this.across = across;
    }

    public void setDonutHoleLabel(String donutHoleLabel) {
        this.donutHoleLabel = donutHoleLabel;
    }

    public void setDonutHoleSize(Integer donutHoleSize) {
        this.donutHoleSize = donutHoleSize;
    }

    public void setDown(Integer down) {
        this.down = down;
    }

    public void setExplodedCategories(String explodedCategories) {
        this.explodedCategories = explodedCategories;
    }

    public void setInvisibleCategories(String invisibleCategories) {
        this.invisibleCategories = invisibleCategories;
    }

    public void setOtherColor(String otherColor) {
        this.otherColor = otherColor;
    }

    public void setOtherSliceLabel(String otherSliceLabel) {
        this.otherSliceLabel = otherSliceLabel;
    }

    public void setOtherThreshold(Double otherThreshold) {
        this.otherThreshold = otherThreshold;
    }

    public void setSliceOrder(String sliceOrder) {
        this.sliceOrder = sliceOrder;
    }

    public void setStartAngle(Double startAngle) {
        this.startAngle = startAngle;
    }

    public Boolean isLabelInsideCategory() {
        return this.labelInsideCategory;
    }

    public Boolean isLabelInsidePercent() {
        return this.labelInsidePercent;
    }

    public Boolean isLabelInsideResponse() {
        return this.labelInsideResponse;
    }

    public Boolean isLabelOutsideCategory() {
        return this.labelOutsideCategory;
    }

    public Boolean isLabelOutsidePercent() {
        return this.labelOutsidePercent;
    }

    public Boolean isLabelOutsideResponse() {
        return this.labelOutsideResponse;
    }

    public void setLabelInsideCategory(Boolean labelInsideCategory) {
        this.labelInsideCategory = labelInsideCategory;
    }

    public void setLabelInsidePercent(Boolean labelInsidePercent) {
        this.labelInsidePercent = labelInsidePercent;
    }

    public void setLabelInsideResponse(Boolean labelInsideResponse) {
        this.labelInsideResponse = labelInsideResponse;
    }

    public void setLabelOutsideCategory(Boolean labelOutsideCategory) {
        this.labelOutsideCategory = labelOutsideCategory;
    }

    public void setLabelOutsidePercent(Boolean labelOutsidePercent) {
        this.labelOutsidePercent = labelOutsidePercent;
    }

    public void setLabelOutsideResponse(Boolean labelOutsideResponse) {
        this.labelOutsideResponse = labelOutsideResponse;
    }

    public String getOutsideSliceLabelPlacement() {
        return this.outsideSliceLabelPlacement;
    }

    public Boolean isReverseDirection() {
        return this.reverseDirection;
    }

    public void setOutsideSliceLabelPlacement(String outsideSliceLabelPlacement) {
        this.outsideSliceLabelPlacement = outsideSliceLabelPlacement;
    }

    public void setReverseDirection(Boolean reverseDirection) {
        this.reverseDirection = reverseDirection;
    }

    public String getInsideSliceLabelContent() {
        return this.insideSliceLabelContent;
    }

    public String getInsideSliceLabelPlacement() {
        return this.insideSliceLabelPlacement;
    }

    public String getOutsideSliceLabelContent() {
        return this.outsideSliceLabelContent;
    }

    public void setInsideSliceLabelContent(String insideSliceLabelContent) {
        this.insideSliceLabelContent = insideSliceLabelContent;
    }

    public void setInsideSliceLabelPlacement(String insideSliceLabelPlacement) {
        this.insideSliceLabelPlacement = insideSliceLabelPlacement;
    }

    public void setOutsideSliceLabelContent(String outsideSliceLabelContent) {
        this.outsideSliceLabelContent = outsideSliceLabelContent;
    }

    public void setResponseLabelVisiblePolicy(String responseLabelVisiblePolicy) {
        this.responseLabelVisiblePolicy = responseLabelVisiblePolicy;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getMissingPolicy() {
        return this.missingPolicy;
    }

    public void setMissingPolicy(String string) {
        this.missingPolicy = string;
    }

    @Override
    protected void applyAttributes() throws JspException {
        Color c;
        int i;
        String[] indexes;
        int count;
        StringTokenizer tk;
        super.applyAttributes();
        this.underlyingObject = (PieChartModel)this.getWrappedObject();
        if (this.explodedCategories != null && this.explodedCategories.length() > 0) {
            tk = new StringTokenizer(this.explodedCategories.trim(), " ", false);
            count = tk.countTokens();
            indexes = new String[count];
            for (i = 0; i < count; ++i) {
                indexes[i] = tk.nextToken();
            }
            this.underlyingObject.setExplodedCategories(indexes);
        }
        if (this.invisibleCategories != null && this.invisibleCategories.length() > 0) {
            tk = new StringTokenizer(this.invisibleCategories.trim(), " ", false);
            count = tk.countTokens();
            indexes = new String[count];
            for (i = 0; i < count; ++i) {
                indexes[i] = tk.nextToken();
            }
            this.underlyingObject.setInvisibleCategories(indexes);
        }
        if (this.startAngle != null) {
            this.underlyingObject.setStartAngle(this.startAngle.doubleValue());
        }
        if (this.sliceOrder != null) {
            this.underlyingObject.setSliceOrder(GraphConstants.SORT.valueOfJSPAttribute(this.sliceOrder));
        }
        if (this.otherThreshold != null) {
            OtherThreshold ot = this.underlyingObject.getOtherThreshold();
            ot = new OtherThreshold(this.otherThreshold.doubleValue(), ot.getUnitName());
            this.underlyingObject.setOtherThreshold(ot);
        }
        if (this.otherColor != null && (c = StringToColor.getColorForName(this.otherColor)) != null) {
            this.underlyingObject.setOtherColor(c);
        }
        if (this.otherSliceLabel != null) {
            this.underlyingObject.setOtherSliceLabel(this.otherSliceLabel);
        }
        if (this.across != null) {
            this.underlyingObject.setAcross(this.across.intValue());
        }
        if (this.down != null) {
            this.underlyingObject.setDown(this.down.intValue());
        }
        int RESPONSE = 4;
        int CATEGORY = 2;
        int PERCENT = 8;
        int outsideContent = 0;
        int insideContent = 0;
        if (this.labelInsideResponse != null) {
            insideContent += 4;
        }
        if (this.labelInsidePercent != null) {
            insideContent += 8;
        }
        if (this.labelInsideCategory != null) {
            insideContent += 2;
        }
        if (this.labelOutsideResponse != null) {
            outsideContent += 4;
        }
        if (this.labelOutsidePercent != null) {
            outsideContent += 8;
        }
        if (this.labelOutsideCategory != null) {
            outsideContent += 2;
        }
        if (outsideContent > 0) {
            this.underlyingObject.setOutsideSliceLabelContent(BasePieChartModelTag.getContent(outsideContent));
        }
        if (insideContent > 0) {
            this.underlyingObject.setInsideSliceLabelContent(BasePieChartModelTag.getContent(insideContent));
        }
        if (this.responseLabelVisiblePolicy != null) {
            this.underlyingObject.setResponseLabelVisiblePolicy(GraphConstants.TRI.valueOfJSPAttribute(this.responseLabelVisiblePolicy));
        }
        if (this.donutHoleSize != null) {
            this.underlyingObject.setDonutHoleSize(this.donutHoleSize.intValue());
        }
        if (this.donutHoleLabel != null) {
            this.underlyingObject.setDonutHoleLabel(this.donutHoleLabel);
        }
        if (this.reverseDirection != null) {
            this.underlyingObject.setReverseDirection(this.reverseDirection.booleanValue());
        }
        if (this.outsideSliceLabelPlacement != null) {
            this.underlyingObject.setOutsideSliceLabelPlacement(GraphConstants.PLACEMENT.valueOfJSPAttribute(this.outsideSliceLabelPlacement));
        }
        if (this.insideSliceLabelPlacement != null) {
            this.underlyingObject.setInsideSliceLabelPlacement(GraphConstants.PLACEMENT.valueOfJSPAttribute(this.insideSliceLabelPlacement));
        }
        if (this.insideSliceLabelContent != null) {
            this.underlyingObject.setInsideSliceLabelContent(GraphConstants.DATA_LABEL.valueOfJSPAttribute(this.insideSliceLabelContent));
        }
        if (this.outsideSliceLabelContent != null) {
            this.underlyingObject.setOutsideSliceLabelContent(GraphConstants.DATA_LABEL.valueOfJSPAttribute(this.outsideSliceLabelContent));
        }
        if (this.dimension != null) {
            this.underlyingObject.setDimension(GraphConstants.DIMENSION.valueOfJSPAttribute(this.dimension));
        }
        if (this.missingPolicy != null) {
            this.underlyingObject.setMissingPolicy(GraphConstants.TRI.valueOfJSPAttribute(this.missingPolicy));
        }
    }

    private static int getContent(int value) {
        int content = 10601;
        switch (value) {
            case 0: {
                content = 10601;
                break;
            }
            case 2: {
                content = 10602;
                break;
            }
            case 4: {
                content = 10603;
                break;
            }
            case 8: {
                content = 10608;
                break;
            }
            case 6: {
                content = 10609;
                break;
            }
            case 10: {
                content = 10610;
                break;
            }
            case 12: {
                content = 10612;
                break;
            }
            case 14: {
                content = 10611;
            }
        }
        return content;
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.piechart.PieChartModel");
        }
        super.doStartTag();
        return 2;
    }
}

