/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.LineStyle;
import com.sas.measures.BaseLength;
import com.sas.taglib.BaseBodyTag;
import com.sas.taglib.graphics.components.StringToColor;
import java.awt.Color;
import javax.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BaseLineStyleTag
extends BaseBodyTag {
    private String color;
    private String thickness;
    private String visibilityPolicy;
    private LineStyle underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.color = null;
            this.thickness = null;
            this.visibilityPolicy = null;
        }
        this.underlyingObject = null;
    }

    public String getColor() {
        return this.color;
    }

    public String getThickness() {
        return this.thickness;
    }

    public String getVisibilityPolicy() {
        return this.visibilityPolicy;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setThickness(String thickness) {
        this.thickness = thickness;
    }

    public void setVisibilityPolicy(String visibilityPolicy) {
        this.visibilityPolicy = visibilityPolicy;
    }

    @Override
    protected void applyAttributes() throws JspException {
        Color c;
        super.applyAttributes();
        this.underlyingObject = (LineStyle)this.getWrappedObject();
        if (this.color != null && (c = StringToColor.getColorForName(this.color)) != null) {
            this.underlyingObject.setColor(c);
        }
        if (this.thickness != null) {
            this.underlyingObject.setThickness(new BaseLength(this.thickness));
        }
        if (this.visibilityPolicy != null) {
            this.underlyingObject.setVisibilityPolicy(GraphConstants.TRI.valueOfJSPAttribute(this.visibilityPolicy));
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.LineStyle");
        }
        super.doStartTag();
        return 2;
    }
}

