/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphStyle;
import com.sas.taglib.BaseBodyTag;
import com.sas.taglib.graphics.components.StringToColor;
import java.awt.Color;
import javax.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BaseGraphStyleTag
extends BaseBodyTag {
    private String styleName;
    private String selectionColor;
    private GraphStyle underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.styleName = null;
            this.selectionColor = null;
        }
        this.underlyingObject = null;
    }

    public String getSelectionColor() {
        return this.selectionColor;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setSelectionColor(String selectionColor) {
        this.selectionColor = selectionColor;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    @Override
    protected void applyAttributes() throws JspException {
        Color c;
        super.applyAttributes();
        this.underlyingObject = (GraphStyle)this.getWrappedObject();
        if (this.styleName != null) {
            this.underlyingObject = new GraphStyle(GraphStyle.STYLE.valueOfJSPAttribute(this.styleName));
        }
        if (this.selectionColor != null && (c = StringToColor.getColorForName(this.selectionColor)) != null) {
            this.underlyingObject.setSelectionColor(c);
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.GraphStyle");
        }
        super.doStartTag();
        return 2;
    }
}

