/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.TextStyle;
import com.sas.taglib.BaseBodyTag;
import java.awt.Font;
import javax.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BaseFontTag
extends BaseBodyTag {
    private Double size;
    private String family;
    private Boolean bold;
    private Boolean italic;
    private Font underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.size = null;
            this.family = null;
            this.bold = null;
            this.italic = null;
        }
        this.underlyingObject = null;
    }

    @Override
    protected void applyAttributes() throws JspException {
        super.applyAttributes();
        this.underlyingObject = (Font)this.getWrappedObject();
        float s = this.underlyingObject.getSize();
        String f = this.underlyingObject.getFamily();
        int style = this.underlyingObject.getStyle();
        if (this.size != null) {
            s = this.size.floatValue();
        }
        if (this.family != null) {
            f = this.family;
        }
        if (this.bold != null) {
            if (style == 0 && this.bold.booleanValue()) {
                style = 1;
            } else if (style == 2 && this.bold.booleanValue()) {
                ++style;
            } else if (style == 1 && !this.bold.booleanValue()) {
                style = 0;
            } else if (style == 3 && !this.bold.booleanValue()) {
                style = 2;
            }
        }
        if (this.italic != null) {
            if (style == 0 && this.italic.booleanValue()) {
                style = 2;
            } else if (style == 1 && this.italic.booleanValue()) {
                style += 2;
            } else if (style == 2 && !this.italic.booleanValue()) {
                style = 0;
            } else if (style == 3 && !this.italic.booleanValue()) {
                style = 1;
            }
        }
        this.underlyingObject = new Font(f, style, (int)s);
        this.setWrappedObject(this.underlyingObject);
    }

    public Boolean isBold() {
        return this.bold;
    }

    public String getFamily() {
        return this.family;
    }

    public Boolean isItalic() {
        return this.italic;
    }

    public Double getSize() {
        return this.size;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public void setSize(Double size) {
        this.size = size;
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedObject() == null) {
            TextStyle ts = new TextStyle();
            Font f = new Font(ts.getFont().getFamily(), ts.getFont().getStyle(), ts.getFont().getSize());
            this.setWrappedObject(f);
        }
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("java.awt.Font");
        }
        this.setInstantiate(false);
        super.doStartTag();
        return 2;
    }
}

