/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.taglib.BaseBodyTag;
import java.awt.BasicStroke;
import javax.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BaseBasicStrokeTag
extends BaseBodyTag {
    Double lineWidth;
    String endCap;
    String lineJoin;
    Double miterLimit;
    Double dashPhase;
    private BasicStroke underlyingObject;
    private boolean dashSegmentsChanged;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        this.dashSegmentsChanged = false;
        if (includeAttributes) {
            this.lineWidth = null;
            this.endCap = null;
            this.lineJoin = null;
            this.miterLimit = null;
            this.dashPhase = null;
        }
        this.underlyingObject = null;
    }

    @Override
    protected void applyAttributes() throws JspException {
        super.applyAttributes();
        this.underlyingObject = (BasicStroke)this.getWrappedObject();
        float w = this.underlyingObject.getLineWidth();
        int c = this.underlyingObject.getEndCap();
        int j = this.underlyingObject.getLineJoin();
        float ml = this.underlyingObject.getMiterLimit();
        float dp = this.underlyingObject.getDashPhase();
        float[] dash = this.underlyingObject.getDashArray();
        if (this.lineWidth != null) {
            w = this.lineWidth.floatValue();
        }
        if (this.endCap != null) {
            if (this.endCap.equalsIgnoreCase("Butt")) {
                c = 0;
            }
            if (this.endCap.equalsIgnoreCase("Round")) {
                c = 1;
            }
            if (this.endCap.equalsIgnoreCase("Square")) {
                c = 2;
            }
        }
        if (this.lineJoin != null) {
            if (this.lineJoin.equalsIgnoreCase("Bevel")) {
                j = 2;
            }
            if (this.lineJoin.equalsIgnoreCase("Miter")) {
                j = 0;
            }
            if (this.lineJoin.equalsIgnoreCase("Round")) {
                j = 1;
            }
        }
        if (this.miterLimit != null) {
            ml = this.miterLimit.floatValue();
        }
        if (this.dashPhase != null) {
            dp = this.dashPhase.floatValue();
        }
        this.underlyingObject = new BasicStroke(w, c, j, ml, dash, dp);
    }

    public Double getDashPhase() {
        return this.dashPhase;
    }

    public String getEndCap() {
        return this.endCap;
    }

    public String getLineJoin() {
        return this.lineJoin;
    }

    public Double getLineWidth() {
        return this.lineWidth;
    }

    public Double getMiterLimit() {
        return this.miterLimit;
    }

    public void setDashPhase(Double dashPhase) {
        this.dashPhase = dashPhase;
    }

    public void setEndCap(String endCap) {
        this.endCap = endCap;
    }

    public void setLineJoin(String lineJoin) {
        this.lineJoin = lineJoin;
    }

    public void setLineWidth(Double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setMiterLimit(Double miterLimit) {
        this.miterLimit = miterLimit;
    }

    public boolean isDashSegmentsChanged() {
        return this.dashSegmentsChanged;
    }

    public void setDashSegmentsChanged(boolean dashSegmentsChanged) {
        this.dashSegmentsChanged = dashSegmentsChanged;
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("java.awt.BasicStroke");
        }
        super.doStartTag();
        return 2;
    }
}

