/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib;

import com.sas.framework.themes.client.BrowserType;
import com.sas.framework.themes.client.Theme;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.session.SessionContextInterface;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.taglib.BaseBodyTag;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class StyleSheetTag
extends BaseBodyTag {
    private CommonLoggerInterface logger = null;
    private String styleNames;

    public int doEndTag() throws JspException {
        if (null == this.getTheme()) {
            this.writeLinksViaCPM();
        } else {
            this.getLogger().debug("Obtaining stylesheets from theme:", this.getTheme().getName());
            this.getLogger().debug("Writing links for AppDev Studio plus:", this.styleNames);
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            BrowserType browserType = (BrowserType)request.getAttribute("sas.framework.browsertype");
            try {
                JspWriter out = this.pageContext.getOut();
                out.println(BaseUtil.getStyleSheetLinks((Theme)this.getTheme(), (BrowserType)browserType, (String)this.styleNames));
            }
            catch (IOException ioe) {
                throw new JspException((Throwable)ioe);
            }
        }
        return super.doEndTag();
    }

    private void writeLinksViaCPM() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance((HttpServletRequest)request);
        Enumeration bodyStrings = this.getBodyStrings();
        Vector v = null;
        if (bodyStrings != null) {
            v = new Vector(3);
            while (bodyStrings.hasMoreElements()) {
                v.add(bodyStrings.nextElement());
            }
        }
        try {
            JspWriter out = this.pageContext.getOut();
            out.println(cpm.getStyleSheetLinks(v));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            String _loggingContext = ((Object)((Object)this)).getClass().getName();
            this.logger = null != this.getSessionContext() ? LoggerRepository2.getLogger((String)_loggingContext, (LoggerFactoryInterface)PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)this.getSessionContext())) : LoggerRepository2.getLogger((String)_loggingContext, (LoggerFactoryInterface)new Log4JFactory2());
        }
        return this.logger;
    }

    private SessionContextInterface getSessionContext() {
        HttpSession session = this.pageContext.getSession();
        return (SessionContextInterface)session.getAttribute("com.sas.services.session.SessionContextInterface");
    }

    private Theme getTheme() {
        ServletRequest request = this.pageContext.getRequest();
        Object o = request.getAttribute("sas.framework.themeobject");
        Theme theme = null;
        if (null != o && o instanceof Theme) {
            theme = (Theme)o;
        }
        if (null == theme) {
            this.getLogger().warn("StyleSheetTag.getTheme() did not find a theme on the servlet request.");
        }
        return theme;
    }

    @Override
    public void release() {
        this.logger = null;
        this.styleNames = null;
        super.release();
    }

    public void setStyleNames(String styleNames) {
        this.styleNames = styleNames;
    }
}

