/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib;

import com.sas.servlet.tbeans.CompositeComponentInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.taglib.BaseBodyTag;
import com.sas.taglib.RB;
import com.sas.text.Message;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public class BaseTag
extends TagSupport
implements TryCatchFinally {
    public static final String RB_KEY = "BaseTag.";
    public static final String PAGE = "page";
    public static final String REQUEST = "request";
    public static final String SESSION = "session";
    public static final String APPLICATION = "application";
    private String ref;
    private String scope;
    private String wrappedClassName;
    private boolean instantiate = true;
    private boolean applyAttributes = true;
    private int tagScope = 1;
    private Object wrappedObject;
    private Locale locale;
    private String compositeComponentKey;

    protected void setCompositeComponentKey(String compositeComponentKey) {
        this.compositeComponentKey = compositeComponentKey;
    }

    public void setInstantiate(boolean instantiate) {
        this.instantiate = instantiate;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    protected void setApplyAttributes(boolean applyAttributes) {
        this.applyAttributes = applyAttributes;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setScope(String scope) {
        this.scope = scope;
        this.tagScope = BaseTag.convertScope(this.getLocale(), scope);
    }

    public static int convertScope(Locale theLocale, String scope) {
        if (PAGE.equalsIgnoreCase(scope)) {
            return 1;
        }
        if (REQUEST.equalsIgnoreCase(scope)) {
            return 2;
        }
        if (SESSION.equalsIgnoreCase(scope)) {
            return 3;
        }
        if (APPLICATION.equalsIgnoreCase(scope)) {
            return 4;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "scopeError.txt", theLocale));
    }

    public final void setTagScope(int tagScope) {
        this.tagScope = tagScope;
    }

    protected String getCompositeComponentKey() {
        return this.compositeComponentKey;
    }

    public boolean getInstantiate() {
        return this.instantiate;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            if (request == null || BaseTag.getLocaleNotExist()) {
                return Locale.getDefault();
            }
            return request.getLocale();
        }
        return this.locale;
    }

    private static boolean getLocaleNotExist() {
        Class<HttpServletRequest> c = HttpServletRequest.class;
        try {
            Method m = c.getMethod("getLocale", null);
            return m == null;
        }
        catch (Exception ex) {
            return true;
        }
    }

    protected final boolean getApplyAttributes() {
        return this.applyAttributes;
    }

    protected PageContext getPageContext() {
        return this.pageContext;
    }

    public String getRef() {
        return this.ref;
    }

    public String getScope() {
        return this.scope;
    }

    public final int getTagScope() {
        return this.tagScope;
    }

    protected void initialize(boolean includeAttributes) {
        if (includeAttributes) {
            this.ref = null;
            this.scope = null;
            this.instantiate = true;
            this.tagScope = 1;
        }
        this.wrappedClassName = null;
        this.applyAttributes = true;
        this.wrappedObject = null;
        this.locale = null;
    }

    public void loadBeanInstance() {
        if (this.ref != null && this.getId() == null) {
            this.setWrappedObject(this.pageContext.getAttribute(this.ref, this.tagScope));
            String key = this.getCompositeComponentKey();
            if (this.wrappedObject != null && key != null) {
                BaseTag.setComponentOnParentComposite(this.wrappedObject, key, (BaseBodyTag)this.getParent());
            }
        } else if (this.getId() != null) {
            this.setWrappedObject(this.pageContext.getAttribute(this.getId(), this.tagScope));
            if (this.wrappedObject != null) {
                this.setApplyAttributes(false);
                String key = this.getCompositeComponentKey();
                if (key != null) {
                    BaseTag.setComponentOnParentComposite(this.wrappedObject, key, (BaseBodyTag)this.getParent());
                }
            }
        }
    }

    public void removeFromScope() {
        if (this.getId() != null) {
            this.pageContext.removeAttribute(this.getId(), this.tagScope);
        } else if (this.ref != null) {
            this.pageContext.removeAttribute(this.ref, this.tagScope);
        }
    }

    public Object searchContext(String var) {
        Object rv = null;
        if (var == null) {
            return null;
        }
        for (int i = this.tagScope; i <= 4 && rv == null; ++i) {
            rv = this.pageContext.getAttribute(var, i);
        }
        return rv;
    }

    public void setVariableWithinScope() {
        if (this.id != null && this.pageContext.getAttribute(this.getId(), this.tagScope) == null) {
            this.pageContext.setAttribute(this.getId(), this.wrappedObject, this.tagScope);
        }
    }

    public void validate(Object obj, String item) throws IllegalArgumentException {
        if (obj == null) {
            String message = RB.getStringResource(RB_KEY, "validateError.txt", this.getLocale());
            throw new IllegalArgumentException(Message.format((String)message, (Object)item));
        }
    }

    protected void applyAttributes() throws JspException {
    }

    public void setWrappedClassName(String wrappedClassName) {
        this.wrappedClassName = wrappedClassName;
    }

    public void setWrappedObject(Object wrappedObject) {
        this.wrappedObject = wrappedObject;
    }

    public String getWrappedClassName() {
        return this.wrappedClassName;
    }

    public Object getWrappedObject() throws JspException {
        return this.getWrappedObject(this.instantiate);
    }

    public Object getWrappedObject(boolean forceCreation) throws JspException {
        if (this.wrappedObject == null && forceCreation) {
            this.setWrappedObject(this.newInstance());
        }
        return this.wrappedObject;
    }

    public Object newInstance() throws JspException {
        String key = this.getCompositeComponentKey();
        if (key != null) {
            Object o = BaseTag.getComponentFromParentComposite(key, (BaseBodyTag)this.getParent());
            if (o == null) {
                String message = RB.getStringResource(RB_KEY, "compositeError.txt", this.getLocale());
                throw new JspException(Message.format((String)message, (Object)this.getParent().getClass().getName()));
            }
            return o;
        }
        try {
            Class<?> classObj = Class.forName(this.wrappedClassName);
            try {
                return classObj.newInstance();
            }
            catch (Exception e) {
                String message = RB.getStringResource(RB_KEY, "instanceError.txt", this.getLocale());
                throw new JspException(Message.format((String)message, (Object)this.wrappedClassName));
            }
        }
        catch (ClassNotFoundException cnfe) {
            String message = RB.getStringResource(RB_KEY, "classLoadError.txt", this.getLocale());
            throw new JspException(Message.format((String)message, (Object)this.wrappedClassName));
        }
    }

    public static void setComponentOnParentComposite(Object wrappedObject, String key, BaseBodyTag parent) {
        try {
            Object o;
            if (parent != null && wrappedObject instanceof TransformationInterface && (o = parent.getWrappedObject()) instanceof CompositeComponentInterface) {
                ((CompositeComponentInterface)o).setComponent(key, (TransformationInterface)wrappedObject);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getComponentFromParentComposite(String key, BaseBodyTag parent) {
        try {
            Object o;
            TransformationInterface rv = null;
            if (parent != null && (o = parent.getWrappedObject()) instanceof CompositeComponentInterface) {
                rv = ((CompositeComponentInterface)o).getComponent(key);
            }
            return rv;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int doStartTag() throws JspException {
        this.loadBeanInstance();
        if (this.id == null && this.ref != null && this.wrappedObject == null) {
            throw new JspException(RB.getStringResource(RB_KEY, "noRefError.txt", this.getLocale()));
        }
        if (this.wrappedClassName != null) {
            if (this.getWrappedObject(this.getInstantiate()) == null) {
                if (!this.instantiate) {
                    throw new JspException(RB.getStringResource(RB_KEY, "idNotFoundError.txt", this.getLocale()));
                }
                throw new JspException(RB.getStringResource(RB_KEY, "wrappedObjectError.txt", this.getLocale()));
            }
            if (this.getApplyAttributes()) {
                this.applyAttributes();
            }
            this.setVariableWithinScope();
        }
        return 0;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        this.initialize(false);
    }

    public void release() {
        super.release();
        this.initialize(true);
    }
}

