/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.XmlEntity;
import org.apache.jackrabbit.webdav.security.AclProperty;

public class HttpAcl
extends BaseDavRequest {
    public HttpAcl(URI uri, AclProperty aclProperty) throws IOException {
        super(uri);
        super.setEntity(XmlEntity.create(aclProperty));
    }

    public HttpAcl(String uri, AclProperty aclProperty) throws IOException {
        this(URI.create(uri), aclProperty);
    }

    public String getMethod() {
        return "ACL";
    }

    @Override
    public boolean succeeded(HttpResponse response) {
        StatusLine statusLine;
        boolean isSuccessful = false;
        if (null != response && null != (statusLine = response.getStatusLine())) {
            int statusCode = statusLine.getStatusCode();
            isSuccessful = 200 == statusCode;
        }
        return isSuccessful;
    }
}

