/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.responses;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.messages.MIR.MIRSDK;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.oem.OEM;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.responses.BridgeInformationResponse;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.RunMimbResponse;
import MITI.mimb.executable.responses.SaveBridgeParametersResponse;
import MITI.server.services.common.LogEvent;
import MITI.util.DateUtil;
import MITI.util.XmlUtil;
import MITI.util.log.MIRLogger;
import MITI.util.text.MessageLiteral;
import MITI.util.xml.SoapUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Response {
    protected MimbExecutable.MIMBReturnCode res;
    protected Document document;
    protected Element element;
    protected String xml;
    protected String language;
    protected String userIdentity;

    protected Response() {
    }

    protected Response(String string, Element element) {
        this.xml = string;
        this.element = element;
        this.language = this.element.getAttribute("language");
        this.userIdentity = this.element.getAttribute("userIdentity");
    }

    public MimbExecutable.MIMBReturnCode getReturnCode() {
        return this.res;
    }

    public static Response parse(String string, MIRLogger mIRLogger) {
        Document document;
        try {
            document = MIRBridgeLib.parseXmlString((String)string, (MIRLogger)mIRLogger);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            MIRSDK.XML_PARSER_INIT.log(mIRLogger, parserConfigurationException, parserConfigurationException.getMessage());
            return null;
        }
        catch (SAXException sAXException) {
            BLIB.DBG_DEBUG.log(mIRLogger, sAXException.toString());
            return null;
        }
        catch (IOException iOException) {
            BLIB.DBG_DEBUG.log(mIRLogger, iOException.toString());
            return null;
        }
        Element element = document.getDocumentElement();
        return Response.parse(element, string, mIRLogger);
    }

    public static Response parse(Element element, String string, MIRLogger mIRLogger) {
        if (element == null) {
            BLIB.DBG_DEBUG.log(mIRLogger, "MIMB failed with no response");
            return null;
        }
        if (element.getNodeName().equals("MimbErrorResponse")) {
            return new ErrorResponse(string, element);
        }
        BLIB.DBG_DEBUG.log(mIRLogger, "MIMB completed successfully");
        if (element.getNodeName().equals("GetBridgeInformationResponse")) {
            return new BridgeInformationResponse(string, element);
        }
        if (element.getNodeName().equals("RunMimbResponse")) {
            return new RunMimbResponse(string, element);
        }
        if (element.getNodeName().equals("SaveBridgeParametersResponse")) {
            return new SaveBridgeParametersResponse(string, element);
        }
        return null;
    }

    public abstract Element printTo(Node var1, Collection<LogEvent> var2);

    public abstract void printTo(StringBuffer var1);

    protected void printLogEvent(Element element, LogEvent logEvent) {
        Element element2 = this.addChildElement(element, SoapUtil.NS_COMMON, "Message");
        if (logEvent.getThreadId() != null) {
            element2.setAttribute("threadId", logEvent.getThreadId());
        }
        element2.setAttribute("type", MessageLiteral.convertLevelToText(logEvent.getLevel()));
        element2.setAttribute("code", logEvent.getCode());
        element2.setAttribute("timestamp", DateUtil.formatUtcDate(logEvent.getTime()));
        if (logEvent.getStackTrace() != null) {
            element2.setAttribute("stackTrace", logEvent.getStackTrace());
        }
        XmlUtil.setElementValue(element2, logEvent.getText());
    }

    public String toXmlString(Collection<LogEvent> collection) {
        if (this.xml == null) {
            try {
                this.document = XmlUtil.getDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return null;
            }
            OEMCode oEMCode = OEM.getEnvOemCode();
            this.element = this.printTo(this.document, !this.includeLogMessages(oEMCode) ? null : collection);
            this.xml = Response.toString(this.element);
        }
        return this.xml;
    }

    private boolean includeLogMessages(OEMCode oEMCode) {
        boolean bl;
        switch (oEMCode) {
            case OEM_MICROSOFT_DATACATALOG: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public static String toString(Element element) {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(element.getOwnerDocument());
            try {
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {}
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public void setUserIdentity(String string) {
        this.userIdentity = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    private Element addChildElement(Node node, XmlUtil.NsName nsName, String string) {
        Element element = XmlUtil.appendNewElement(node, nsName, string);
        return element;
    }
}

