/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.responses;

import MITI.bridges.mimb.BridgeLibrary;
import MITI.mimb.executable.responses.Response;
import MITI.server.services.common.LogEvent;
import MITI.util.XmlUtil;
import MITI.util.text.BridgeSpecificationLiteral;
import MITI.util.xml.SoapUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeListResponse
extends Response {
    private String lastBridge = "";
    private Map<BridgeLibrary, BridgeSpecificationLiteral> bridges = new LinkedHashMap<BridgeLibrary, BridgeSpecificationLiteral>();
    private boolean isExport = false;
    private boolean withSpecification = false;

    public void setLastBridge(String string) {
        this.lastBridge = string;
    }

    public void addBridge(BridgeLibrary bridgeLibrary, BridgeSpecificationLiteral bridgeSpecificationLiteral) {
        this.bridges.put(bridgeLibrary, bridgeSpecificationLiteral);
    }

    public BridgeSpecificationLiteral getBridgeSpec(BridgeLibrary bridgeLibrary) {
        return this.bridges.get(bridgeLibrary);
    }

    public void setIsExport(boolean bl) {
        this.isExport = bl;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public String lastBridge() {
        return this.lastBridge;
    }

    public Collection<BridgeLibrary> getBridges() {
        return this.bridges.keySet();
    }

    public void setWithSpecification(boolean bl) {
        this.withSpecification = bl;
    }

    public boolean getWithSpecification() {
        return this.withSpecification;
    }

    @Override
    public Element printTo(Node node, Collection<LogEvent> collection) {
        Element element = XmlUtil.appendNewElement(node == null ? this.document : node, null, "GetBridgeListResponse");
        element.setAttribute("xmlns", SoapUtil.NS_MIMB_EXE.getUri());
        element.setAttribute("direction", this.isExport() ? "EXPORT" : "IMPORT");
        for (Map.Entry<BridgeLibrary, BridgeSpecificationLiteral> entry : this.bridges.entrySet()) {
            BridgeLibrary bridgeLibrary = entry.getKey();
            Element element2 = XmlUtil.appendNewElement(element, null, "Bridge");
            element2.setAttribute("bridgeIdentifier", bridgeLibrary.getBridgeId());
            element2.setAttribute("direction", this.isExport() ? "EXPORT" : "IMPORT");
            Element element3 = XmlUtil.appendNewElement(element2, null, "DisplayName");
            element3.setAttribute("bridgeDisplayName", bridgeLibrary.getDisplayName());
            if (bridgeLibrary.getDisplayName().equals(this.lastBridge())) {
                element3.setAttribute("lastUsed", "true");
            }
            if (!this.getWithSpecification()) continue;
            Element element4 = XmlUtil.appendNewElement(element2, null, "Specification");
            BridgeSpecificationLiteral bridgeSpecificationLiteral = entry.getValue();
            if (bridgeSpecificationLiteral != null) {
                element4.setAttribute("version", bridgeSpecificationLiteral.getTool_Versions());
                element4.setAttribute("methodology", bridgeSpecificationLiteral.getMethodology_Summary());
                element4.setAttribute("productName", bridgeSpecificationLiteral.getTool_Name());
                element4.setAttribute("productVersion", bridgeSpecificationLiteral.getTool_Versions());
                element4.setAttribute("productCompany", bridgeSpecificationLiteral.getVendor_Name());
                element4.setAttribute("productWeb", bridgeSpecificationLiteral.getTool_Web());
                element4.setAttribute("isMultiModel", bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel() ? "true" : "false");
                continue;
            }
            element4.setAttribute("version", "UNDEFINED");
            element4.setAttribute("methodology", "UNDEFINED");
            element4.setAttribute("productName", "UNDEFINED");
            element4.setAttribute("productVersion", "UNDEFINED");
            element4.setAttribute("productCompany", "UNDEFINED");
            element4.setAttribute("productWeb", "http://UNDEFINED");
            element4.setAttribute("isMultiModel", "false");
        }
        return element;
    }

    @Override
    public void printTo(StringBuffer stringBuffer) {
        for (Map.Entry<BridgeLibrary, BridgeSpecificationLiteral> entry : this.bridges.entrySet()) {
            BridgeLibrary bridgeLibrary = entry.getKey();
            stringBuffer.append(bridgeLibrary.getBridgeId()).append("\n");
        }
    }
}

