/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.responses;

import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.mimb.executable.responses.Response;
import MITI.server.services.common.LogEvent;
import MITI.util.XmlUtil;
import MITI.util.xml.SoapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeInformationResponse
extends Response {
    private String bridgeId;
    private String bridgeDisplayName;
    private String bridgeDescription = "";
    private boolean isExport;
    private BridgeSpecification specification;
    private Parameters parameters;

    public BridgeInformationResponse() {
    }

    /*
     * WARNING - void declaration
     */
    public BridgeInformationResponse(String string, Element element) {
        super(string, element);
        this.bridgeId = element.getAttribute("bridgeIdentifier");
        this.bridgeDisplayName = element.getAttribute("bridgeDisplayName");
        this.isExport = element.getAttribute("direction").equals("EXPORT");
        this.bridgeDescription = element.getAttribute("description");
        Element element2 = XmlUtil.getFirstElement(element, "Specification");
        if (element2 != null) {
            this.specification = new BridgeSpecification(element2.getAttribute("productWeb"), element2.getAttribute("productCompany"), element2.getAttribute("productName"), element2.getAttribute("productVersion"), "", "", "", element2.getAttribute("methodology"), this.bridgeId, element2.getAttribute("version"), element2.getAttribute("bridgeTooltip"), element2.getAttribute("isMultiModel").equals("true"), element2.getAttribute("isDriverLiveDownloadEnabled").equals("true"));
        }
        this.parameters = new Parameters();
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, "BridgeParameter");
        if (arrayList != null) {
            for (Element element3 : arrayList) {
                void var19_21;
                Object object;
                Object object2;
                String[] stringArray;
                String string2 = element3.getAttribute("bridgeParameterIdentifier");
                String string3 = element3.getAttribute("displayName");
                Parameter.Type type = Parameter.Type.valueOf((String)element3.getAttribute("type"));
                boolean bl = element3.getAttribute("mandatory").equals("true");
                String string4 = element3.getAttribute("description");
                boolean bl2 = element3.getAttribute("transferable").equals("true");
                Parameter.OpenMode openMode = Parameter.OpenMode.DEFAULT;
                if (type == Parameter.Type.FILE || type == Parameter.Type.DIRECTORY) {
                    openMode = Parameter.OpenMode.valueOf((String)element3.getAttribute("openMode"));
                }
                LinkedHashMap<String[], String> linkedHashMap = new LinkedHashMap<String[], String>();
                ArrayList<Element> arrayList3 = XmlUtil.getChildElements(element3, "PossibleValue");
                if (arrayList3 != null) {
                    for (Element element4 : arrayList3) {
                        stringArray = element4.getAttribute("identifier");
                        String string5 = XmlUtil.getElementValue(element4);
                        linkedHashMap.put(stringArray, string5);
                    }
                }
                ArrayList arrayList4 = new ArrayList();
                ArrayList<Element> arrayList22 = XmlUtil.getChildElements(element3, "FileExtension");
                if (arrayList22 != null) {
                    for (Element element5 : arrayList22) {
                        arrayList4.add(XmlUtil.getElementValue(element5));
                    }
                }
                stringArray = new String[arrayList4.size()];
                stringArray = arrayList4.toArray(stringArray);
                String string6 = "";
                Element element6 = XmlUtil.getFirstElement(element3, "DefaultValue");
                if (element6 != null && (object2 = XmlUtil.getElementValue(element6)) != null) {
                    String string7 = object2;
                }
                object2 = null;
                Element element7 = XmlUtil.getFirstElement(element3, "SavedValue");
                if (element7 != null && (object = XmlUtil.getElementValue(element7)) != null) {
                    object2 = object;
                }
                object = new ArrayList();
                ArrayList<Element> arrayList2 = XmlUtil.getChildElements(element3, "HistoricalValue");
                if (arrayList2 != null) {
                    for (Element element8 : arrayList2) {
                        String string8 = XmlUtil.getElementValue(element8);
                        if (string8 == null) continue;
                        object.add(string8);
                    }
                }
                Parameter parameter = new Parameter(string2, string3, string4, (String)var19_21, type, bl, stringArray, openMode, bl2, linkedHashMap, (String)object2, (List)object);
                this.parameters.addParameter(parameter);
            }
        }
    }

    public void setBridgeId(String string) {
        this.bridgeId = string;
    }

    public void setBridgeDisplayName(String string) {
        this.bridgeDisplayName = string;
    }

    public void setIsExport(boolean bl) {
        this.isExport = bl;
    }

    public void setSpecification(BridgeSpecification bridgeSpecification) {
        this.specification = bridgeSpecification;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public String getBridgeDisplayName() {
        return this.bridgeDisplayName;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public BridgeSpecification getSpecification() {
        return this.specification;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public String getBridgeDescription() {
        if (this.bridgeDescription.isEmpty()) {
            this.bridgeDescription = this.bridgeDescription + BLIB.BRIDGE_SPEC_COMMON_SPECIFICATIONS.getMessage(this.specification.getProductCompany(), this.specification.getProductName(), this.specification.getProductVersion(), this.specification.getProductInterface(), this.specification.getProductWeb(), this.specification.getProductCategory(), this.specification.getProductCoverage(), this.bridgeId, this.specification.getBridgeVersion()) + "\n";
            if (this.specification.getDriverLiveDownloadEnabled()) {
                this.bridgeDescription = this.bridgeDescription + "\n";
                this.bridgeDescription = this.bridgeDescription + BLIB.BRIDGE_SPEC_COMMON_DISCLAIMER.getMessage(new Object[0]) + "\n";
            }
            this.bridgeDescription = this.bridgeDescription + "\n";
            this.bridgeDescription = this.bridgeDescription + BLIB.BRIDGE_SPEC_COMMON_OVERVIEW.getMessage(new Object[0]) + "\n";
            this.bridgeDescription = this.bridgeDescription + this.specification.getBridgeToolTip();
        }
        return this.bridgeDescription;
    }

    @Override
    public Element printTo(Node node, Collection<LogEvent> collection) {
        Element element = XmlUtil.appendNewElement(node == null ? this.document : node, null, "GetBridgeInformationResponse");
        element.setAttribute("xmlns", SoapUtil.NS_MIMB_EXE.getUri());
        element.setAttribute("bridgeIdentifier", this.getBridgeId());
        element.setAttribute("bridgeDisplayName", this.getBridgeDisplayName());
        element.setAttribute("direction", this.isExport ? "EXPORT" : "IMPORT");
        element.setAttribute("description", this.getBridgeDescription());
        Element element2 = XmlUtil.appendNewElement(element, null, "Specification");
        element2.setAttribute("version", this.specification.getBridgeVersion());
        element2.setAttribute("methodology", this.specification.getProductMethodology());
        element2.setAttribute("productName", this.specification.getProductName());
        element2.setAttribute("productVersion", this.specification.getProductVersion());
        element2.setAttribute("productCompany", this.specification.getProductCompany());
        element2.setAttribute("productWeb", this.specification.getProductWeb());
        element2.setAttribute("isMultiModel", this.specification.getMultiModel() ? "true" : "false");
        element2.setAttribute("isDriverLiveDownloadEnabled", this.specification.getDriverLiveDownloadEnabled() ? "true" : "false");
        for (Parameter parameter : this.parameters) {
            Object object;
            Element element3;
            Object object2;
            Object object32;
            Object object4;
            Element element4 = XmlUtil.appendNewElement(element, null, "BridgeParameter");
            element4.setAttribute("bridgeParameterIdentifier", parameter.getName());
            element4.setAttribute("displayName", parameter.getDisplayName());
            element4.setAttribute("type", parameter.getType().toString());
            element4.setAttribute("mandatory", parameter.isMandatory() ? "true" : "false");
            element4.setAttribute("description", parameter.getDescription());
            if (parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) {
                element4.setAttribute("transferable", parameter.isTransferable() ? "true" : "false");
                element4.setAttribute("openMode", parameter.getOpenMode().toString());
            }
            if (parameter.getType() == Parameter.Type.ENUMERATED) {
                object4 = parameter.getPossibleValues();
                if (object4 != null) {
                    for (Object object32 : object4.keySet()) {
                        object2 = (String)object4.get(object32);
                        element3 = XmlUtil.appendNewElement(element4, null, "PossibleValue");
                        element3.setAttribute("identifier", (String)object32);
                        XmlUtil.setElementValue(element3, (String)object2);
                    }
                }
            } else if ((parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) && (object4 = parameter.getFileExtensions()) != null) {
                object = object4.iterator();
                while (object.hasNext()) {
                    object32 = (String)object.next();
                    object2 = XmlUtil.appendNewElement(element4, null, "FileExtension");
                    XmlUtil.setElementValue((Element)object2, (String)object32);
                }
            }
            object4 = XmlUtil.appendNewElement(element4, null, "DefaultValue");
            XmlUtil.setElementValue((Element)object4, parameter.getDefaultValue());
            if (parameter.getSavedValue() != null) {
                object = XmlUtil.appendNewElement(element4, null, "SavedValue");
                XmlUtil.setElementValue((Element)object, parameter.getSavedValue());
            }
            object = parameter.getHistoricalValues();
            object32 = object.iterator();
            while (object32.hasNext()) {
                object2 = (String)object32.next();
                element3 = XmlUtil.appendNewElement(element4, null, "HistoricalValue");
                XmlUtil.setElementValue(element3, (String)object2);
            }
        }
        return element;
    }

    @Override
    public void printTo(StringBuffer stringBuffer) {
        BridgeSpecification bridgeSpecification = this.getSpecification();
        Parameters parameters = this.getParameters();
        String string = this.getBridgeDescription();
        stringBuffer.append("[" + this.getBridgeId() + "]").append("\n");
        stringBuffer.append(string).append("\n");
        stringBuffer.append("[Bridge Specification]").append("\n");
        stringBuffer.append("  version:" + bridgeSpecification.getBridgeVersion()).append("\n");
        stringBuffer.append("  methodology:" + bridgeSpecification.getProductMethodology()).append("\n");
        stringBuffer.append("  productName:" + bridgeSpecification.getProductName()).append("\n");
        stringBuffer.append("  productVersion:" + bridgeSpecification.getProductVersion()).append("\n");
        stringBuffer.append("  productCompany:" + bridgeSpecification.getProductCompany()).append("\n");
        stringBuffer.append("  productWeb:" + bridgeSpecification.getProductWeb());
        stringBuffer.append("  isMultiModel:" + (bridgeSpecification.getMultiModel() ? "1" : "0")).append("\n");
        stringBuffer.append("[Bridge Parameters]");
        for (Parameter parameter : parameters) {
            Iterator<Object> iterator;
            String string22;
            Object object;
            stringBuffer.append("  [" + parameter.getName() + "]").append("\n");
            stringBuffer.append("    displayName:" + parameter.getDisplayName()).append("\n");
            stringBuffer.append("    type:" + parameter.getType().toString()).append("\n");
            stringBuffer.append("    mandatory:" + (parameter.isMandatory() ? "true" : "false")).append("\n");
            stringBuffer.append("    description:" + parameter.getDescription()).append("\n");
            if (parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) {
                stringBuffer.append("    transferable:" + (parameter.isTransferable() ? "true" : "false")).append("\n");
                stringBuffer.append("    openMode:" + parameter.getOpenMode().toString()).append("\n");
            }
            if (parameter.getType() == Parameter.Type.ENUMERATED) {
                stringBuffer.append("    [Possible Values]").append("\n");
                object = parameter.getPossibleValues();
                if (object != null) {
                    for (String string22 : object.keySet()) {
                        stringBuffer.append("      " + string22).append("\n");
                    }
                }
            } else if (parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) {
                stringBuffer.append("    file extensions:");
                object = parameter.getFileExtensions();
                if (object != null) {
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        string22 = (String)iterator.next();
                        stringBuffer.append(string22 + " ");
                    }
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("    default value:" + parameter.getDefaultValue()).append("\n");
            if (parameter.getSavedValue() != null) {
                stringBuffer.append("    saved value:" + parameter.getSavedValue()).append("\n");
            }
            if ((object = parameter.getHistoricalValues()) == null || object.isEmpty()) continue;
            stringBuffer.append("    [Historical Values]").append("\n");
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string22 = (String)iterator.next();
                stringBuffer.append("      " + string22).append("\n");
            }
            stringBuffer.append("\n");
        }
    }
}

