/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.requests;

import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.Request;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.XmlUtil;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RunMimbExtendedRequest
extends Request {
    private BridgeRunRequest importRequest;
    private BridgeRunRequest exportRequest;
    private MIRValidationLevel.Enum validationLevel = MIRValidationLevel.BASIC;
    private String commandLineFile = "";
    private String logLevel = "";
    private String resetCache = "";

    public void setImportRequest(BridgeRunRequest bridgeRunRequest) {
        this.importRequest = bridgeRunRequest;
    }

    public BridgeRunRequest getImportRequest() {
        return this.importRequest;
    }

    public void setExportRequest(BridgeRunRequest bridgeRunRequest) {
        this.exportRequest = bridgeRunRequest;
    }

    public BridgeRunRequest getExportRequest() {
        return this.exportRequest;
    }

    public MIRValidationLevel.Enum getValidationLevel() {
        return this.validationLevel;
    }

    public void setValidationLevel(MIRValidationLevel.Enum enum_) {
        this.validationLevel = enum_;
    }

    public void setCommandLineFile(String string) {
        this.commandLineFile = string;
    }

    public String getCommandLineFile() {
        return this.commandLineFile;
    }

    public void setLogLevel(String string) {
        this.logLevel = string;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getResetCache() {
        return this.resetCache;
    }

    public void setResetCache(String string) {
        this.resetCache = string;
    }

    @Override
    public void parse(Element element) {
        super.parse(element);
        this.commandLineFile = element.getAttribute("commandLineFile");
        this.validationLevel = MIRValidationLevel.getByName(element.getAttribute("validationLevel"));
        this.logLevel = element.getAttribute("logLevel");
        this.resetCache = element.getAttribute("resetCache");
        for (Element element2 : XmlUtil.getChildElements(element)) {
            String string = element2.getLocalName() == null ? element2.getTagName() : element2.getLocalName();
            if (string.equals("Import")) {
                this.importRequest = new BridgeRunRequest();
                this.importRequest.parse(element2);
                continue;
            }
            if (!string.equals("Export")) continue;
            this.exportRequest = new BridgeRunRequest();
            this.exportRequest.parse(element2);
        }
    }

    protected void serialize(Document document, Element element) {
        element.setAttribute("userIdentity", this.userIdentity);
        element.setAttribute("validationLevel", this.validationLevel.getName());
        element.setAttribute("language", this.language);
        element.setAttribute("commandLineFile", this.commandLineFile);
        element.setAttribute("logLevel", this.logLevel);
        element.setAttribute("resetCache", this.resetCache);
        Element element2 = document.createElement("Import");
        element.appendChild(element2);
        this.importRequest.serialize(document, element2);
        Element element3 = document.createElement("Export");
        element.appendChild(element3);
        this.exportRequest.serialize(document, element3);
    }

    @Override
    public String toString() {
        Document document;
        try {
            document = XmlUtil.getDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return parserConfigurationException.toString();
        }
        Element element = document.createElement("RunMimbExtendedRequest");
        document.appendChild(element);
        this.serialize(document, element);
        String string = this.toString(document, element);
        return string;
    }
}

