/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.requests;

import MITI.mimb.executable.requests.BrowseRequest;
import MITI.mimb.executable.requests.DataQualityRequest;
import MITI.mimb.executable.requests.GetBridgeInformationRequest;
import MITI.mimb.executable.requests.GetBridgeListRequest;
import MITI.mimb.executable.requests.GetBridgeSpecsRequest;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.requests.SaveBridgeParametersRequest;
import MITI.mimb.executable.requests.TestRequest;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Request {
    protected String userIdentity = "";
    protected String language = "";

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public void setUserIdentity(String string) {
        this.userIdentity = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public static Request decodeXmlRequest(Element element) {
        String string = element.getLocalName() == null ? element.getTagName() : element.getLocalName();
        if (string.equals("GetBridgeListRequest")) {
            GetBridgeListRequest getBridgeListRequest = new GetBridgeListRequest();
            getBridgeListRequest.parse(element);
            return getBridgeListRequest;
        }
        if (string.equals("GetBridgeSpecsRequest")) {
            GetBridgeSpecsRequest getBridgeSpecsRequest = new GetBridgeSpecsRequest();
            getBridgeSpecsRequest.parse(element);
            return getBridgeSpecsRequest;
        }
        if (string.equals("GetBridgeInformationRequest")) {
            GetBridgeInformationRequest getBridgeInformationRequest = new GetBridgeInformationRequest();
            getBridgeInformationRequest.parse(element);
            return getBridgeInformationRequest;
        }
        if (string.equals("SaveBridgeParametersRequest")) {
            SaveBridgeParametersRequest saveBridgeParametersRequest = new SaveBridgeParametersRequest();
            saveBridgeParametersRequest.parse(element);
            return saveBridgeParametersRequest;
        }
        if (string.equals("BrowseRequest")) {
            BrowseRequest browseRequest = new BrowseRequest();
            browseRequest.parse(element);
            return browseRequest;
        }
        if (string.equals("TestMimbRequest")) {
            TestRequest testRequest = new TestRequest();
            testRequest.parse(element);
            return testRequest;
        }
        if (string.equals("RunMimbRequest") || string.equals("RunMimbExtendedRequest")) {
            RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
            runMimbExtendedRequest.parse(element);
            return runMimbExtendedRequest;
        }
        if (string.equals("RunMimbDataProfilingRequest")) {
            DataQualityRequest dataQualityRequest = new DataQualityRequest();
            dataQualityRequest.parse(element);
            return dataQualityRequest;
        }
        return null;
    }

    public void parse(Element element) {
        this.userIdentity = element.getAttribute("userIdentity");
        this.language = element.getAttribute("language");
    }

    public abstract String toString();

    public String toString(Document document, Element element) {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            try {
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {}
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return stringWriter.toString();
    }
}

