/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.requests;

import MITI.mimb.executable.requests.Request;
import MITI.util.XmlUtil;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetBridgeSpecsRequest
extends Request {
    private String bridgeId;
    private boolean isExport;

    public GetBridgeSpecsRequest() {
    }

    public GetBridgeSpecsRequest(String string, boolean bl) {
        this.bridgeId = string;
        this.isExport = bl;
    }

    @Override
    public void parse(Element element) {
        super.parse(element);
        this.bridgeId = element.getAttribute("bridgeIdentifier");
        this.isExport = element.getAttribute("direction").equals("EXPORT");
    }

    private void serialize(Document document, Element element) {
        if (this.bridgeId != null && !this.bridgeId.isEmpty()) {
            element.setAttribute("bridgeIdentifier", this.bridgeId);
            element.setAttribute("direction", this.isExport ? "EXPORT" : "IMPORT");
        }
        element.setAttribute("userIdentity", this.userIdentity);
        element.setAttribute("language", this.language);
    }

    @Override
    public String toString() {
        Document document;
        try {
            document = XmlUtil.getDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return parserConfigurationException.toString();
        }
        Element element = document.createElement("GetBridgeSpecsRequest");
        document.appendChild(element);
        this.serialize(document, element);
        String string = this.toString(document, element);
        return string;
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public boolean isExport() {
        return this.isExport;
    }
}

