/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.printers;

import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.printers.Printer;
import MITI.mimb.executable.responses.BridgeInformationResponse;
import MITI.mimb.executable.responses.BridgeListResponse;
import MITI.mimb.executable.responses.BridgeSpecsResponse;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.RunMimbResponse;
import MITI.mimb.executable.responses.SaveBridgeParametersResponse;
import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.MIRLogger;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class XmlPrinter
extends Printer {
    public XmlPrinter(PrintStream printStream, MIRLogger mIRLogger, BufferedLogEventHandler bufferedLogEventHandler) throws UnsupportedEncodingException {
        super(printStream, mIRLogger, bufferedLogEventHandler);
    }

    @Override
    public MimbExecutable.MIMBReturnCode printBridgeList(BridgeListResponse bridgeListResponse) {
        String string = bridgeListResponse.toXmlString(this.bufferedlogEvents.getEvents());
        if (string != null) {
            this.ps.println(string);
            return MimbExecutable.MIMBReturnCode.SUCCESS;
        }
        return MimbExecutable.MIMBReturnCode.ERROR_EXE;
    }

    @Override
    public MimbExecutable.MIMBReturnCode printExtendedBridgeSpecs(BridgeSpecsResponse bridgeSpecsResponse) {
        String string = bridgeSpecsResponse.toXmlString(this.bufferedlogEvents.getEvents());
        if (string != null) {
            this.ps.println(string);
            return MimbExecutable.MIMBReturnCode.SUCCESS;
        }
        return MimbExecutable.MIMBReturnCode.ERROR_EXE;
    }

    @Override
    public MimbExecutable.MIMBReturnCode printBridgeInformation(BridgeInformationResponse bridgeInformationResponse) {
        String string = bridgeInformationResponse.toXmlString(this.bufferedlogEvents.getEvents());
        if (string != null) {
            this.ps.println(string);
            return MimbExecutable.MIMBReturnCode.SUCCESS;
        }
        return MimbExecutable.MIMBReturnCode.ERROR_EXE;
    }

    @Override
    public MimbExecutable.MIMBReturnCode printMetamodelMapping() {
        return MimbExecutable.MIMBReturnCode.SUCCESS;
    }

    @Override
    public MimbExecutable.MIMBReturnCode printError(ErrorResponse errorResponse) {
        MIMB.TOOL_FAILED.log(this.logger, errorResponse.getReturnCode().name());
        String string = errorResponse.toXmlString(this.bufferedlogEvents.getEvents());
        if (string != null) {
            this.ps.println(string);
            return errorResponse.getReturnCode();
        }
        return MimbExecutable.MIMBReturnCode.ERROR_EXE;
    }

    @Override
    public MimbExecutable.MIMBReturnCode printSuccess(RunMimbResponse runMimbResponse) {
        String string = runMimbResponse.toXmlString(this.bufferedlogEvents.getEvents());
        if (string != null) {
            this.ps.println(string);
            return MimbExecutable.MIMBReturnCode.SUCCESS;
        }
        return MimbExecutable.MIMBReturnCode.ERROR_EXE;
    }

    @Override
    public MimbExecutable.MIMBReturnCode printSuccessSaveOptions(SaveBridgeParametersResponse saveBridgeParametersResponse) {
        String string = saveBridgeParametersResponse.toXmlString(this.bufferedlogEvents.getEvents());
        if (string != null) {
            this.ps.println(string);
            return MimbExecutable.MIMBReturnCode.SUCCESS;
        }
        return MimbExecutable.MIMBReturnCode.ERROR_EXE;
    }
}

