/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.printers;

import MITI.MIRException;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.responses.BridgeInformationResponse;
import MITI.mimb.executable.responses.BridgeListResponse;
import MITI.mimb.executable.responses.BridgeSpecsResponse;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.executable.responses.RunMimbResponse;
import MITI.mimb.executable.responses.SaveBridgeParametersResponse;
import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.MIRLogger;
import java.io.PrintStream;

public abstract class Printer {
    protected PrintStream ps;
    protected MIRLogger logger;
    protected BufferedLogEventHandler bufferedlogEvents;

    public Printer(PrintStream printStream, MIRLogger mIRLogger, BufferedLogEventHandler bufferedLogEventHandler) {
        this.ps = printStream;
        this.logger = mIRLogger;
        this.bufferedlogEvents = bufferedLogEventHandler;
    }

    public abstract MimbExecutable.MIMBReturnCode printBridgeList(BridgeListResponse var1);

    public abstract MimbExecutable.MIMBReturnCode printExtendedBridgeSpecs(BridgeSpecsResponse var1);

    public abstract MimbExecutable.MIMBReturnCode printBridgeInformation(BridgeInformationResponse var1);

    public abstract MimbExecutable.MIMBReturnCode printMetamodelMapping();

    public abstract MimbExecutable.MIMBReturnCode printError(ErrorResponse var1);

    public abstract MimbExecutable.MIMBReturnCode printSuccess(RunMimbResponse var1);

    public abstract MimbExecutable.MIMBReturnCode printSuccessSaveOptions(SaveBridgeParametersResponse var1);

    public MimbExecutable.MIMBReturnCode printReply(Response response) {
        MimbExecutable.MIMBReturnCode mIMBReturnCode;
        block8: {
            mIMBReturnCode = MimbExecutable.MIMBReturnCode.SUCCESS;
            try {
                if (response instanceof BridgeListResponse) {
                    mIMBReturnCode = this.printBridgeList((BridgeListResponse)response);
                    break block8;
                }
                if (response instanceof BridgeSpecsResponse) {
                    mIMBReturnCode = this.printExtendedBridgeSpecs((BridgeSpecsResponse)response);
                    break block8;
                }
                if (response instanceof BridgeInformationResponse) {
                    mIMBReturnCode = this.printBridgeInformation((BridgeInformationResponse)response);
                    break block8;
                }
                if (response instanceof SaveBridgeParametersResponse) {
                    mIMBReturnCode = this.printSuccessSaveOptions((SaveBridgeParametersResponse)response);
                    break block8;
                }
                if (response instanceof RunMimbResponse) {
                    mIMBReturnCode = this.printSuccess((RunMimbResponse)response);
                    break block8;
                }
                if (response instanceof ErrorResponse) {
                    mIMBReturnCode = this.printError((ErrorResponse)response);
                    break block8;
                }
                throw new MIRException("Unsupported response");
            }
            catch (Exception exception) {
                ErrorResponse errorResponse = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                mIMBReturnCode = this.printError(errorResponse);
            }
        }
        this.ps.flush();
        return mIMBReturnCode;
    }
}

