/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.oem;

import MITI.messages.MIRModelBridge.BLIB;
import MITI.mimb.executable.oem.OEMCode;
import MITI.util.Encryption;
import MITI.util.file.FileUtil;

public class OEM {
    public static OEMCode getEnvOemCode() {
        String string = OEM.decryptOemToken(System.getenv("MITI_OEM_CALLER_ID"));
        return OEM.getOemCode(string);
    }

    public static OEMCode getOemCode(String string) {
        OEMCode oEMCode = OEMCode.NOT_OEM;
        if (string == null || string.isEmpty()) {
            OEM.displayDebugMessage("CallerId is empty");
        } else {
            for (OEMCode oEMCode2 : OEMCode.values()) {
                if (!oEMCode2.matches(string)) continue;
                oEMCode = oEMCode2;
                break;
            }
            if (oEMCode == OEMCode.NOT_OEM) {
                OEM.displayDebugMessage("CallerId is invalid");
            }
        }
        return oEMCode;
    }

    public static String getOemToken(OEMCode oEMCode) {
        if (oEMCode != null) {
            return OEM.encryptOemToken(oEMCode.getCallerId());
        }
        return "";
    }

    public static boolean isDebugOem() {
        String string = System.getenv("MITI_DEBUG_OEM");
        return string != null && !string.isEmpty();
    }

    private static void displayDebugMessage(String string) {
        if (OEM.isDebugOem()) {
            BLIB.DBG_DEBUG.log(string);
        }
    }

    private static String encryptOemToken(String string) {
        if (string != null && !string.isEmpty()) {
            byte[] byArray = string.getBytes(FileUtil.UTF8);
            byte[] byArray2 = new byte[byArray.length + 8];
            Encryption.convertLongToBytes(System.currentTimeMillis(), byArray2, 0);
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i + 8] = byArray[i];
            }
            byte[] byArray3 = Encryption.encrypt(byArray2);
            return Encryption.bytesToHex(byArray3);
        }
        return "";
    }

    private static String decryptOemToken(String string) {
        if (string != null && !string.isEmpty()) {
            byte[] byArray = Encryption.hexToBytes(string);
            byte[] byArray2 = Encryption.decrypt(byArray);
            byte[] byArray3 = new byte[byArray2.length - 8];
            for (int i = 0; i < byArray2.length - 8; ++i) {
                byArray3[i] = byArray2[i + 8];
            }
            return new String(byArray3, FileUtil.UTF8);
        }
        return "";
    }

    public static boolean isMIMBDesktop(String string) {
        return OEMCode.MIMB_WEB.getCallerId().equals(string);
    }

    public static boolean isInternalMimb() {
        return false;
    }
}

