/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.debug;

import MITI.bridges.mimb.MIRSetup;
import MITI.mimb.executable.debug.NullRequest;
import MITI.mimb.executable.debug.NullResponse;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.responses.Response;
import MITI.server.services.common.LogEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;

public class Conversation {
    private static int globalRequestSeq = 0;
    private int requestSeq = ++globalRequestSeq;
    private File conversationDir = null;

    public Conversation(MIRSetup mIRSetup) {
        String string = mIRSetup.getModelBridgeXmlConversationDirectory();
        if (string != null && !string.isEmpty()) {
            this.conversationDir = new File(string);
        }
    }

    public void logRequest(Request request) {
        if (this.conversationDir != null) {
            if (request == null) {
                request = new NullRequest();
            }
            try (OutputStreamWriter outputStreamWriter = this.getOutputStream(request);){
                Conversation.writeScrubbedContent(outputStreamWriter, request.toString());
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void logResponse(Response response, Collection<LogEvent> collection) {
        if (this.conversationDir != null) {
            if (response == null) {
                response = new NullResponse();
            }
            try (OutputStreamWriter outputStreamWriter = this.getOutputStream(response);){
                Conversation.writeScrubbedContent(outputStreamWriter, response.toXmlString(collection));
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private OutputStreamWriter getOutputStream(Object object) throws IOException {
        File file = File.createTempFile(object.getClass().getSimpleName() + "_" + this.requestSeq + "_", ".xml", this.conversationDir);
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
    }

    private static void writeScrubbedContent(OutputStreamWriter outputStreamWriter, String string) throws IOException {
        int n = 0;
        int n2 = 0;
        do {
            boolean bl;
            if ((n = string.indexOf("<BridgeParameter", n2)) < n2) continue;
            outputStreamWriter.write(string.substring(n2, n));
            n2 = string.indexOf(">", n);
            int n3 = string.indexOf("Password", n);
            boolean bl2 = bl = n3 > n && n3 < n2;
            if (string.charAt(n2 - 1) != '/') {
                n2 = string.indexOf("</BridgeParameter", n2 + 1);
                n2 = string.indexOf(">", n2 + 1);
            }
            ++n2;
            if (bl) continue;
            outputStreamWriter.write(string.substring(n, n2));
        } while (n != -1);
        outputStreamWriter.write(string.substring(n2));
    }
}

