/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.configuration;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class Configuration {
    protected String userIdentity;
    protected File file;
    protected DocumentBuilderFactory docBuilderFactory;
    protected DocumentBuilder docBuilder;
    protected Document doc;
    protected Element root;

    public Configuration(String string) {
        this.userIdentity = string;
    }

    protected boolean load(File file, String string, MIRLogger mIRLogger) {
        File file2 = new File(file, this.userIdentity);
        if (!file2.exists()) {
            file2.mkdir();
        }
        this.file = new File(file2, string);
        if (!this.file.exists()) {
            return false;
        }
        File file3 = new File(file2, string + ".bkp");
        try {
            this.doc = MIRBridgeLib.parseXmlFile((File)this.file, (MIRLogger)mIRLogger);
        }
        catch (IOException iOException) {
            FileUtil.move(this.file, file3);
            return false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FileUtil.move(this.file, file3);
            return false;
        }
        catch (SAXException sAXException) {
            FileUtil.move(this.file, file3);
            return false;
        }
        this.root = this.doc.getDocumentElement();
        return true;
    }

    public void initializeDocument(String string) {
        if (this.docBuilderFactory == null) {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        if (this.docBuilder == null) {
            try {
                this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return;
            }
        }
        if (this.doc == null) {
            this.doc = this.docBuilder.newDocument();
        }
        this.root = this.doc.getDocumentElement();
        if (this.root == null) {
            this.root = this.doc.createElement(string);
            this.doc.appendChild(this.root);
        }
    }

    public boolean save() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(this.doc);
            StreamResult streamResult = new StreamResult(this.file);
            try {
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {
                return false;
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            return false;
        }
        return true;
    }
}

