/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.configuration;

import MITI.mimb.executable.configuration.Configuration;
import MITI.util.XmlUtil;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BridgeConfiguration
extends Configuration {
    private static final int MAX_HISTORICAL_VALUES = 10;

    public BridgeConfiguration(String string) {
        super(string);
    }

    public boolean loadBridgeConfiguration(MIRLogger mIRLogger, File file, String string, boolean bl) {
        String string2 = "MIR" + string + (bl ? "Export.xml" : "Import.xml");
        if (!this.load(file, string2, mIRLogger)) {
            this.initializeDocument("MimbBridgeHistoryPreferences");
            this.root.setAttribute("direction", bl ? "EXPORT" : "IMPORT");
            this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.root.setAttribute("xsi:noNamespaceSchemaLocation", "MIMB_5.xsd");
            this.root.setAttribute("bridgeIdentifier", string);
            return false;
        }
        return true;
    }

    private Element getParameter(String string) {
        Element element = null;
        ArrayList<Element> arrayList = XmlUtil.getChildElements(this.root, "BridgeParameter");
        if (arrayList != null) {
            for (Element element2 : arrayList) {
                if (!element2.getAttribute("bridgeParameterIdentifier").equals(string)) continue;
                element = element2;
                break;
            }
        }
        if (element == null) {
            element = this.doc.createElement("BridgeParameter");
            element.setAttribute("bridgeParameterIdentifier", string);
            this.root.appendChild(element);
        }
        this.minimizeEmptyTextLines(this.root);
        return element;
    }

    private Element getSavedValue(Element element) {
        Element element2 = null;
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, "SavedValue");
        if (arrayList != null && arrayList.size() >= 1) {
            element2 = arrayList.get(0);
        }
        return element2;
    }

    public void setSavedValue(String string, String string2) {
        Element element = this.getParameter(string);
        Element element2 = this.getSavedValue(element);
        if (element2 == null) {
            element2 = this.doc.createElement("SavedValue");
            element.appendChild(element2);
            Text text = this.doc.createTextNode(string2);
            element2.appendChild(text);
        } else {
            NodeList nodeList = element2.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    element2.removeChild(node);
                }
            }
            Text text = this.doc.createTextNode(string2);
            element2.appendChild(text);
        }
    }

    public String getSavedValue(String string) {
        Element element = this.getParameter(string);
        Element element2 = this.getSavedValue(element);
        if (element2 == null) {
            return "";
        }
        return XmlUtil.getElementValue(element2);
    }

    public boolean hasSavedValue(String string) {
        Element element = this.getParameter(string);
        Element element2 = this.getSavedValue(element);
        return element2 != null;
    }

    public void setHistoricalValue(String string, String string2) {
        Object object;
        Node node2;
        Element element = this.getParameter(string);
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, "HistoricalValue");
        if (arrayList != null) {
            for (Node node2 : arrayList) {
                object = XmlUtil.getElementValue(node2);
                if (object == null) {
                    object = "";
                }
                if (!string2.equals(object)) continue;
                this.removeSiblingTextIndentationNodes((Element)node2);
                element.removeChild(node2);
            }
        }
        Element element2 = this.doc.createElement("HistoricalValue");
        node2 = this.doc.createTextNode(string2);
        element2.appendChild(node2);
        object = XmlUtil.getFirstElement(element, "HistoricalValue");
        if (object == null) {
            object = this.getSavedValue(element);
        }
        if (object == null) {
            element.appendChild(element2);
        } else {
            element.insertBefore(element2, (Node)object);
        }
        arrayList = XmlUtil.getChildElements(element, "HistoricalValue");
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Element element3 = arrayList.get(i);
                if (i <= 10) continue;
                element.removeChild(element3);
            }
        }
        this.minimizeEmptyTextLines(element);
    }

    private boolean isTextIndentationNode(Node node) {
        if (node != null && node.getNodeType() == 3) {
            String string = ((Text)node).getNodeValue();
            return string.trim().isEmpty();
        }
        return false;
    }

    private void removeSiblingTextIndentationNodes(Element element) {
        Node node = element.getNextSibling();
        do {
            if (!this.isTextIndentationNode(node)) continue;
            element.getParentNode().removeChild(node);
        } while ((node = element.getNextSibling()) != null && node.getNodeType() == 3);
    }

    private void minimizeEmptyTextLines(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.isTextIndentationNode(node)) continue;
            ((Text)node).replaceWholeText("\n");
        }
    }

    public List<String> getHistoricalValues(String string) {
        ArrayList<Element> arrayList;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Element element = this.getParameter(string);
        if (element != null && (arrayList = XmlUtil.getChildElements(element, "HistoricalValue")) != null) {
            for (Element element2 : arrayList) {
                String string2 = XmlUtil.getElementValue(element2);
                if (string2 == null) {
                    string2 = "";
                }
                arrayList2.add(string2);
            }
        }
        return arrayList2;
    }

    public boolean isHidden(String string) {
        if (string.startsWith("__")) {
            return true;
        }
        Element element = this.getParameter(string);
        return element.getAttribute("hidden").equalsIgnoreCase("true");
    }
}

