/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridgeInterface;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.TestRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.MachineInfo;
import MITI.util.VersionInfo;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class TestAction
extends Action {
    protected String bridgeId;
    protected String bridgeDisplayName;
    protected boolean isExport;
    protected String language;
    protected String logLevel;

    public TestAction(BridgeLoader bridgeLoader, MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, TestRequest testRequest, OEMCode oEMCode) {
        super(bridgeLoader, mIRSetup, mIRModelBridges, testRequest.getUserIdentity(), oEMCode);
        this.bridgeId = testRequest.getBridgeId();
        this.bridgeDisplayName = testRequest.getBridgeDisplayName();
        this.isExport = testRequest.isExport();
        this.userOptions = testRequest.getUserOptions();
        this.vaultOptions = testRequest.getVaultOptions();
        this.disableLog = testRequest.getDisablelog();
        this.logLevel = testRequest.getLogLevel();
        this.language = testRequest.getLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MIRLogger mIRLogger = MIRLogger.getLogger();
        try {
            Object object2;
            BridgeLibrary bridgeLibrary = this.modelBridges.loadBridgeLibrary(this.bridgeId, this.isExport);
            if (bridgeLibrary == null) {
                if (this.isExport) {
                    MIMB.TOOL_EXPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                } else {
                    MIMB.TOOL_IMPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                }
                this.result = MimbExecutable.MIMBReturnCode.ERROR_TEST;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                return;
            }
            if (this.bridgeDisplayName.isEmpty()) {
                this.bridgeDisplayName = bridgeLibrary.getDisplayName();
            }
            this.bridgeInterface = this.bridgeLoader.loadBridge(this.bridgeId, this.isExport);
            if (this.bridgeInterface == null) {
                if (MachineInfo.isWindows()) {
                    String string;
                    TestRequest testRequest = new TestRequest();
                    testRequest.setUserIdentity(this.userIdentity);
                    testRequest.setLanguage(this.language);
                    testRequest.setBridgeId(this.bridgeId);
                    testRequest.setBridgeDisplayName(this.bridgeDisplayName);
                    testRequest.setDisableLog(this.disableLog);
                    testRequest.setUserOptions(this.userOptions);
                    testRequest.setIsExport(this.isExport);
                    testRequest.setLogLevel(this.logLevel);
                    String string2 = testRequest.toString();
                    MimbUtf8PrintStream mimbUtf8PrintStream = new MimbUtf8PrintStream((OutputStream)new MimbMessageLogOutputStream(mIRLogger));
                    try {
                        string = MIRModelBridgeInterface.execute((String)string2, (String)this.language, (PrintStream)mimbUtf8PrintStream, (MIRSetup)this.setup, (String)this.getOemToken());
                    }
                    catch (IOException iOException) {
                        BLIB.DBG_DEBUG.log(mIRLogger, iOException, iOException.toString());
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_TEST;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                        this.bridgeLoader.unloadBridge(this.bridgeInterface);
                        return;
                    }
                    this.response = Response.parse(string, mIRLogger);
                    if (this.response == null) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_TEST;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                        return;
                    }
                    if (this.response instanceof ErrorResponse) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_TEST;
                        return;
                    }
                    this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
                    return;
                }
                MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(mIRLogger, this.bridgeId, MachineInfo.getOperatingSystemName());
                this.result = MimbExecutable.MIMBReturnCode.ERROR_TEST;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                return;
            }
            this.getBridgeOptions(this.bridgeId, this.isExport, mIRLogger);
            for (Object object2 : this.userOptions) {
                this.setBridgeOption((MimbOption)object2);
            }
            if (!this.checkMandatoryOptions(true)) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_TEST;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                return;
            }
            VersionInfo versionInfo = VersionInfo.loadMitiJar(this.bridgeInterface.getClass());
            object2 = MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)this.isExport);
            this.displayBridgeInfo(this.bridgeParameters, this.bridgeId, this.bridgeDisplayName, this.isExport, (BridgeSpecificationLiteral)object2, versionInfo, mIRLogger);
            MIMB.CALLING_TEST_METHOD.log(mIRLogger, new Object[0]);
            BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(this.setup, this.getOemToken(), MIRValidationLevel.NONE);
            boolean bl = this.bridgeInterface.test(this.bridgeId, this.bridgeOptions, bridgeEnvironment, mIRLogger);
            if (!bl) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_TEST;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
                return;
            }
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(mIRLogger, throwable, throwable.getMessage());
            this.result = MimbExecutable.MIMBReturnCode.ERROR_TEST;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_TEST);
            return;
        }
        finally {
            this.bridgeLoader.unloadBridge(this.bridgeInterface);
        }
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
    }
}

