/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridgeInterface;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.SaveBridgeParametersRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.util.Encryption;
import MITI.util.log.MIRLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class SaveBridgeParametersAction
extends Action {
    protected String bridgeId;
    protected String bridgeDisplayName;
    protected boolean isExport;
    protected String language;

    public SaveBridgeParametersAction(BridgeLoader bridgeLoader, MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, SaveBridgeParametersRequest saveBridgeParametersRequest, OEMCode oEMCode) {
        super(bridgeLoader, mIRSetup, mIRModelBridges, saveBridgeParametersRequest.getUserIdentity(), oEMCode);
        this.bridgeId = saveBridgeParametersRequest.getBridgeId();
        this.bridgeDisplayName = "";
        this.isExport = saveBridgeParametersRequest.isExport();
        this.userOptions = saveBridgeParametersRequest.getUserOptions();
        this.language = saveBridgeParametersRequest.getLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MIRLogger mIRLogger = MIRLogger.getLogger();
        if (this.userIdentity == null || this.userIdentity.isEmpty()) {
            MIMB.TOOL_MISSING_USER_NAME.log(mIRLogger, new Object[0]);
            this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
            return;
        }
        try {
            BridgeLibrary bridgeLibrary = this.modelBridges.loadBridgeLibrary(this.bridgeId, this.isExport);
            if (bridgeLibrary == null) {
                if (this.isExport) {
                    MIMB.TOOL_EXPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                } else {
                    MIMB.TOOL_IMPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                }
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                return;
            }
            if (this.bridgeDisplayName.isEmpty()) {
                this.bridgeDisplayName = bridgeLibrary.getDisplayName();
            }
            this.bridgeInterface = this.bridgeLoader.loadBridge(this.bridgeId, this.isExport);
            if (this.bridgeInterface == null) {
                String string;
                SaveBridgeParametersRequest saveBridgeParametersRequest = new SaveBridgeParametersRequest();
                saveBridgeParametersRequest.setUserIdentity(this.userIdentity);
                saveBridgeParametersRequest.setLanguage(this.language);
                saveBridgeParametersRequest.setBridgeId(this.bridgeId);
                saveBridgeParametersRequest.setIsExport(this.isExport);
                saveBridgeParametersRequest.setUserOptions(this.userOptions);
                String string2 = saveBridgeParametersRequest.toString();
                MimbUtf8PrintStream mimbUtf8PrintStream = new MimbUtf8PrintStream((OutputStream)new MimbMessageLogOutputStream(mIRLogger));
                try {
                    string = MIRModelBridgeInterface.execute((String)string2, (String)this.language, (PrintStream)mimbUtf8PrintStream, (MIRSetup)this.setup, (String)this.getOemToken());
                }
                catch (IOException iOException) {
                    BLIB.DBG_DEBUG.log(mIRLogger, iOException, iOException.toString());
                    this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                    this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                    this.bridgeLoader.unloadBridge(this.bridgeInterface);
                    return;
                }
                this.response = Response.parse(string, mIRLogger);
                if (this.response == null) {
                    this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                    this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                    return;
                }
                if (this.response instanceof ErrorResponse) {
                    this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                    return;
                }
                this.result = MimbExecutable.MIMBReturnCode.SUCCESS_SAVE_OPTIONS;
                return;
            }
            this.getBridgeOptions(this.bridgeId, this.isExport, mIRLogger);
            for (MimbOption mimbOption : this.userOptions) {
                this.setBridgeOption(mimbOption);
            }
            for (MimbOption mimbOption : this.bridgeOptions) {
                Parameter parameter = mimbOption.getParameter();
                String string = mimbOption.getName();
                String string3 = mimbOption.getValue();
                if (parameter.getType() == Parameter.Type.PASSWORD) {
                    string3 = Encryption.encrypt(mimbOption.getValue());
                } else if (!(parameter.getType() != Parameter.Type.FILE && parameter.getType() != Parameter.Type.DIRECTORY || mimbOption.getClientSpecifiedText().isEmpty())) {
                    string3 = mimbOption.getClientSpecifiedText();
                }
                this.config.setSavedValue(string, string3);
            }
            this.config.save();
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(mIRLogger, throwable, throwable.getMessage());
            this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
            return;
        }
        finally {
            this.bridgeLoader.unloadBridge(this.bridgeInterface);
        }
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS_SAVE_OPTIONS;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
    }
}

