/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.MIRModelBridgeInterface;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.configuration.Configuration;
import MITI.mimb.executable.configuration.MIMBConfiguration;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.Encryption;
import MITI.util.MachineInfo;
import MITI.util.VersionInfo;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ImportAction
extends Action {
    private String bridgeId;
    private String bridgeDisplayName;
    private MIRValidationLevel.Enum validationLevel;
    private String language;
    private String logLevel;

    public ImportAction(BridgeLoader bridgeLoader, MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, BridgeRunRequest bridgeRunRequest, MIRValidationLevel.Enum enum_, String string, String string2, OEMCode oEMCode) {
        super(bridgeLoader, mIRSetup, mIRModelBridges, bridgeRunRequest.getUserIdentity(), oEMCode);
        this.bridgeId = bridgeRunRequest.getBridgeId();
        this.bridgeDisplayName = bridgeRunRequest.getBridgeDisplayName();
        this.userOptions = bridgeRunRequest.getUserOptions();
        this.vaultOptions = bridgeRunRequest.getVaultOptions();
        this.disableLog = bridgeRunRequest.getDisablelog();
        this.validationLevel = enum_;
        this.logLevel = string;
        this.language = string2;
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public String getBridgeDisplayName() {
        return this.bridgeDisplayName;
    }

    public BridgeSpecificationLiteral getBridgeSpec() {
        return MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        MIRLogger mIRLogger = MIRLogger.getLogger();
        try {
            object4 = this.modelBridges.loadBridgeLibrary(this.bridgeId, false);
            if (object4 == null) {
                MIMB.TOOL_IMPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            if (this.bridgeDisplayName.isEmpty()) {
                this.bridgeDisplayName = object4.getDisplayName();
            }
            File file = this.setup.getTempDirectory();
            this.dir = MIRBridgeLib.makeTempDir((File)file, (String)this.bridgeId);
            MIMB.DBG_CREATED_TMP_DIR.log(mIRLogger, this.dir.getPath());
            this.bridgeInterface = this.bridgeLoader.loadBridge(this.bridgeId, false);
            if (this.bridgeInterface == null) {
                if (MachineInfo.isWindows()) {
                    String string;
                    BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
                    bridgeRunRequest.setUserIdentity(this.userIdentity);
                    bridgeRunRequest.setLanguage("");
                    bridgeRunRequest.setBridgeId(this.bridgeId);
                    bridgeRunRequest.setBridgeDisplayName(this.bridgeDisplayName);
                    bridgeRunRequest.setUserOptions(this.userOptions);
                    bridgeRunRequest.setDisableLog(this.disableLog);
                    BridgeRunRequest bridgeRunRequest2 = new BridgeRunRequest();
                    bridgeRunRequest2.setUserIdentity(this.userIdentity);
                    bridgeRunRequest2.setLanguage("");
                    bridgeRunRequest2.setBridgeId("MetaIntegrationMultiModelXml");
                    bridgeRunRequest2.setBridgeDisplayName("MIMB Intermediate Step");
                    MimbOptions mimbOptions = new MimbOptions();
                    mimbOptions.addOption("Directory", this.dir.getPath(), "");
                    mimbOptions.addOption("Verboseness Level", "Low", "");
                    mimbOptions.addOption("Remove textual information", "False", "");
                    bridgeRunRequest2.setUserOptions(mimbOptions);
                    bridgeRunRequest2.setDisableLog(true);
                    RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
                    runMimbExtendedRequest.setUserIdentity(this.userIdentity);
                    runMimbExtendedRequest.setLanguage(this.language);
                    runMimbExtendedRequest.setImportRequest(bridgeRunRequest);
                    runMimbExtendedRequest.setExportRequest(bridgeRunRequest2);
                    runMimbExtendedRequest.setValidationLevel(this.validationLevel);
                    runMimbExtendedRequest.setCommandLineFile("");
                    runMimbExtendedRequest.setLogLevel(this.logLevel);
                    String string2 = runMimbExtendedRequest.toString();
                    MimbUtf8PrintStream mimbUtf8PrintStream = new MimbUtf8PrintStream((OutputStream)new MimbMessageLogOutputStream(mIRLogger));
                    try {
                        string = MIRModelBridgeInterface.execute((String)string2, (String)this.language, (PrintStream)mimbUtf8PrintStream, (MIRSetup)this.setup, (String)this.getOemToken());
                    }
                    catch (IOException iOException) {
                        BLIB.DBG_DEBUG.log(mIRLogger, iOException, iOException.toString());
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                        this.bridgeLoader.unloadBridge(this.bridgeInterface);
                        return;
                    }
                    this.response = Response.parse(string, mIRLogger);
                    if (this.response == null) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                        return;
                    }
                    if (this.response instanceof ErrorResponse) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                        return;
                    }
                    this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
                    return;
                }
                MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(mIRLogger, this.bridgeId, MachineInfo.getOperatingSystemName());
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            if (this.isMIMBIntermediateStep(this.bridgeId, this.bridgeDisplayName)) {
                MimbOption mimbOption = this.userOptions.getOption("File");
                if (mimbOption != null) {
                    File file2 = new File(mimbOption.getValue());
                    File file3 = MIRMixManager.getModelFile(this.dir);
                    MIMB.DBG_MOVING_FILES.log(mIRLogger, file2.getPath(), file3.getPath());
                    FileUtil.copy(file2, file3);
                    this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
                    return;
                }
                mimbOption = this.userOptions.getOption("Directory");
                if (mimbOption != null) {
                    File file4 = new File(mimbOption.getValue());
                    MIMB.DBG_MOVING_FILES.log(mIRLogger, file4.getPath(), this.dir.getPath());
                    FileUtil.copy(file4, this.dir);
                    this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
                    return;
                }
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            this.getBridgeOptions(this.bridgeId, false, mIRLogger);
            for (Object object32 : this.userOptions) {
                this.setBridgeOption((MimbOption)object32);
            }
            if (!this.checkMandatoryOptions(true)) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            if (!this.testRequiredInputFiles(false, mIRLogger)) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            object2 = VersionInfo.loadMitiJar(this.bridgeInterface.getClass());
            object32 = MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)false);
            this.displayBridgeInfo(this.bridgeParameters, this.bridgeId, this.bridgeDisplayName, false, (BridgeSpecificationLiteral)object32, (VersionInfo)object2, mIRLogger);
            this.processJavaOptions();
            MIMB.CALLING_RUN_METHOD.log(mIRLogger, new Object[0]);
            object = new BridgeEnvironment(this.setup, this.getOemToken(), this.validationLevel);
            boolean bl = this.bridgeInterface.run(this.bridgeId, this.dir, this.bridgeOptions, object, mIRLogger);
            if (!bl) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            MIMB.TOOL_MODEL_IMPORTED.log(mIRLogger, this.getCurrentDate());
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(mIRLogger, throwable, throwable.getMessage());
            this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
            return;
        }
        finally {
            this.bridgeLoader.unloadBridge(this.bridgeInterface);
        }
        if (!this.userIdentity.isEmpty() && !this.bridgeDisplayName.equals("MIMB Intermediate Step")) {
            for (File file : this.bridgeOptions) {
                object2 = file.getParameter();
                if (object2 == null || this.config.isHidden((String)(object32 = file.getName()))) continue;
                object = file.getValue();
                if (object2.getType() == Parameter.Type.PASSWORD) {
                    object = Encryption.encrypt(file.getValue());
                } else if (!(object2.getType() != Parameter.Type.FILE && object2.getType() != Parameter.Type.DIRECTORY || file.getClientSpecifiedText().isEmpty())) {
                    object = file.getClientSpecifiedText();
                }
                this.config.setHistoricalValue((String)object32, (String)object);
            }
            this.config.save();
            if (!this.bridgeDisplayName.isEmpty()) {
                object4 = new MIMBConfiguration(this.userIdentity);
                ((MIMBConfiguration)object4).loadMIMBConfiguration(mIRLogger, this.setup.getDataHistoryDirectory());
                ((MIMBConfiguration)object4).setImportBridge(this.bridgeDisplayName);
                ((Configuration)object4).save();
            }
        }
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
        ImportAction.printCommandLineComment(stringBuilder, "Defines the import bridge and its parameters");
        stringBuilder.append("\n");
        ImportAction.printCommandLineAdd(stringBuilder, "import");
        stringBuilder.append("-i ").append(this.bridgeId).append("\n");
        for (MimbOption mimbOption : this.userOptions) {
            String string = mimbOption.getName();
            String string2 = mimbOption.getValue();
            if (string.equals("File/Directory")) {
                ImportAction.printCommandLineAdd(stringBuilder, "import");
                stringBuilder.append("-f \"").append(string2).append("\"\n");
                continue;
            }
            ImportAction.printCommandLineAdd(stringBuilder, "import");
            stringBuilder.append("-o \"").append(string).append("=").append(string2).append("\"\n");
        }
        stringBuilder.append("\n");
        ImportAction.printCommandLineComment(stringBuilder, "Defines the validation level");
        stringBuilder.append("\n");
        ImportAction.printCommandLineAdd(stringBuilder, "validate");
        stringBuilder.append("-v ").append(this.validationLevel.getName()).append("\n");
        stringBuilder.append("\n");
    }
}

