/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRBridgeConstants.MBLST;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.requests.GetBridgeSpecsRequest;
import MITI.mimb.executable.responses.BridgeSpecsResponse;
import MITI.util.text.BridgeSpecificationLiteral;
import java.util.LinkedHashMap;

public class GetBridgeSpecsAction
extends Action {
    private String bridgeId;
    private boolean isExport;

    public GetBridgeSpecsAction(MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, GetBridgeSpecsRequest getBridgeSpecsRequest) {
        super(null, mIRSetup, mIRModelBridges, getBridgeSpecsRequest.getUserIdentity(), null);
        this.bridgeId = getBridgeSpecsRequest.getBridgeId();
        this.isExport = getBridgeSpecsRequest.isExport();
    }

    @Override
    public void run() {
        Object object;
        LinkedHashMap<BridgeSpecificationLiteral, BridgeLibrary> linkedHashMap = new LinkedHashMap<BridgeSpecificationLiteral, BridgeLibrary>();
        if (this.bridgeId != null && !this.bridgeId.isEmpty()) {
            object = MBLST.getBridgeSpecification(this.bridgeId, this.isExport);
            if (object != null) {
                linkedHashMap.put((BridgeSpecificationLiteral)object, this.getBridgeLibrary((BridgeSpecificationLiteral)object));
            }
        } else {
            for (BridgeSpecificationLiteral bridgeSpecificationLiteral : MBLST.listAllSpecifications()) {
                BridgeLibrary bridgeLibrary = this.getBridgeLibrary(bridgeSpecificationLiteral);
                if (bridgeLibrary == null || !bridgeLibrary.isEnabled()) continue;
                linkedHashMap.put(bridgeSpecificationLiteral, bridgeLibrary);
            }
        }
        object = new BridgeSpecsResponse();
        ((BridgeSpecsResponse)object).setSpecs(linkedHashMap);
        this.response = object;
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS_BRIDGE_SPECS;
    }

    private BridgeLibrary getBridgeLibrary(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
        BridgeLibrary bridgeLibrary = null;
        if (bridgeSpecificationLiteral != null) {
            if (bridgeSpecificationLiteral.getBridge_Direction().equalsIgnoreCase("Export")) {
                bridgeLibrary = this.modelBridges.loadBridgeLibrary(bridgeSpecificationLiteral.getBridge_Id(), true);
            } else if (bridgeSpecificationLiteral.getBridge_Direction().equalsIgnoreCase("Import")) {
                bridgeLibrary = this.modelBridges.loadBridgeLibrary(bridgeSpecificationLiteral.getBridge_Id(), false);
            }
        }
        return bridgeLibrary;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
    }
}

