/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.configuration.MIMBConfiguration;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.GetBridgeListRequest;
import MITI.mimb.executable.responses.BridgeListResponse;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import java.util.Iterator;

public class GetBridgeListAction
extends Action {
    protected boolean isExport = false;
    protected boolean withSpecification = false;

    public GetBridgeListAction(MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, GetBridgeListRequest getBridgeListRequest, OEMCode oEMCode) {
        super(null, mIRSetup, mIRModelBridges, getBridgeListRequest.getUserIdentity(), oEMCode);
        this.isExport = getBridgeListRequest.isExport();
        this.withSpecification = getBridgeListRequest.withSpecification();
    }

    @Override
    public void run() {
        MIRLogger mIRLogger = MIRLogger.getLogger();
        try {
            Object object;
            String string = "";
            if (!this.userIdentity.isEmpty()) {
                object = new MIMBConfiguration(this.userIdentity);
                ((MIMBConfiguration)object).loadMIMBConfiguration(mIRLogger, this.setup.getDataHistoryDirectory());
                string = this.isExport ? ((MIMBConfiguration)object).getExportBridge() : ((MIMBConfiguration)object).getImportBridge();
            }
            object = this.modelBridges.getBridges(this.isExport);
            BridgeListResponse bridgeListResponse = new BridgeListResponse();
            bridgeListResponse.setLastBridge(string);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                BridgeSpecificationLiteral bridgeSpecificationLiteral;
                BridgeLibrary bridgeLibrary = (BridgeLibrary)iterator.next();
                if (!bridgeLibrary.isEnabled() || !this.oemCode.isValidBridge(bridgeSpecificationLiteral = MIRModelBridges.getBridgeSpecificationLiteral((String)bridgeLibrary.getBridgeId(), (boolean)this.isExport), this.isExport)) continue;
                bridgeListResponse.addBridge(bridgeLibrary, this.withSpecification ? bridgeSpecificationLiteral : null);
            }
            bridgeListResponse.setIsExport(this.isExport);
            bridgeListResponse.setWithSpecification(this.withSpecification);
            this.response = bridgeListResponse;
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(mIRLogger, throwable, throwable.getMessage());
            this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
            return;
        }
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS_BRIDGE_LIST;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
    }
}

