/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridgeInterface;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.configuration.BridgeConfiguration;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.GetBridgeInformationRequest;
import MITI.mimb.executable.responses.BridgeInformationResponse;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.util.Encryption;
import MITI.util.MachineInfo;
import MITI.util.log.MIRLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class GetBridgeInformationAction
extends Action {
    protected String bridgeId;
    protected String bridgeDisplayName;
    protected boolean isExport;
    protected String language;

    public GetBridgeInformationAction(BridgeLoader bridgeLoader, MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, GetBridgeInformationRequest getBridgeInformationRequest, OEMCode oEMCode) {
        super(bridgeLoader, mIRSetup, mIRModelBridges, getBridgeInformationRequest.getUserIdentity(), oEMCode);
        this.bridgeId = getBridgeInformationRequest.getBridgeId();
        this.bridgeDisplayName = getBridgeInformationRequest.getBridgeDisplayName();
        this.isExport = getBridgeInformationRequest.isExport();
        this.language = getBridgeInformationRequest.getLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MIRLogger mIRLogger = MIRLogger.getLogger();
        try {
            Object object;
            Parameters parameters;
            BridgeSpecification bridgeSpecification;
            BridgeLibrary bridgeLibrary = this.modelBridges.loadBridgeLibrary(this.bridgeId, this.isExport);
            if (bridgeLibrary == null) {
                if (this.isExport) {
                    MIMB.TOOL_EXPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                } else {
                    MIMB.TOOL_IMPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                }
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                return;
            }
            if (this.bridgeDisplayName.isEmpty()) {
                this.bridgeDisplayName = bridgeLibrary.getDisplayName();
            }
            this.bridgeInterface = this.bridgeLoader.loadBridge(this.bridgeId, this.isExport);
            if (this.bridgeInterface == null) {
                if (MachineInfo.isWindows()) {
                    String string;
                    GetBridgeInformationRequest getBridgeInformationRequest = new GetBridgeInformationRequest();
                    getBridgeInformationRequest.setUserIdentity(this.userIdentity);
                    getBridgeInformationRequest.setLanguage(this.language);
                    getBridgeInformationRequest.setBridgeId(this.bridgeId);
                    getBridgeInformationRequest.setBridgeDisplayName(this.bridgeDisplayName);
                    getBridgeInformationRequest.setIsExport(this.isExport);
                    String string2 = getBridgeInformationRequest.toString();
                    MimbUtf8PrintStream mimbUtf8PrintStream = new MimbUtf8PrintStream((OutputStream)new MimbMessageLogOutputStream(mIRLogger));
                    try {
                        string = MIRModelBridgeInterface.execute((String)string2, (String)this.language, (PrintStream)mimbUtf8PrintStream, (MIRSetup)this.setup, (String)this.getOemToken());
                    }
                    catch (IOException iOException) {
                        BLIB.DBG_DEBUG.log(mIRLogger, iOException, iOException.toString());
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                        this.bridgeLoader.unloadBridge(this.bridgeInterface);
                        return;
                    }
                    this.response = Response.parse(string, mIRLogger);
                    if (this.response == null) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                        return;
                    }
                    if (this.response instanceof ErrorResponse) {
                        this.result = ((ErrorResponse)this.response).getReturnCode();
                        return;
                    }
                    if (this.response instanceof BridgeInformationResponse) {
                        // empty if block
                    }
                    this.result = MimbExecutable.MIMBReturnCode.SUCCESS_BRIDGE_INFORMATION;
                    return;
                }
                MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(mIRLogger, this.bridgeId, MachineInfo.getOperatingSystemName());
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                return;
            }
            try {
                bridgeSpecification = this.bridgeInterface.getSpecification(this.bridgeId);
            }
            catch (Throwable throwable) {
                MIMB.TOOL_CANNOT_GET_SPECS.log(mIRLogger, throwable, this.bridgeId, throwable.getMessage());
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                this.bridgeLoader.unloadBridge(this.bridgeInterface);
                return;
            }
            try {
                parameters = this.bridgeInterface.getParameters();
            }
            catch (Throwable throwable) {
                MIMB.TOOL_CANNOT_GET_OPTS.log(mIRLogger, throwable, this.bridgeId, throwable.getMessage());
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                this.bridgeLoader.unloadBridge(this.bridgeInterface);
                return;
            }
            if (this.userIdentity != null && !this.userIdentity.isEmpty()) {
                object = new BridgeConfiguration(this.userIdentity);
                ((BridgeConfiguration)object).loadBridgeConfiguration(mIRLogger, this.setup.getDataHistoryDirectory(), this.bridgeId, this.isExport);
                for (Parameter parameter : parameters) {
                    Object object2;
                    if (((BridgeConfiguration)object).hasSavedValue(parameter.getName())) {
                        object2 = ((BridgeConfiguration)object).getSavedValue(parameter.getName());
                        if (parameter.getType() == Parameter.Type.PASSWORD) {
                            object2 = Encryption.decrypt((String)object2);
                        }
                        if (parameter.isPossibleValue((String)object2)) {
                            parameter.setSavedValue((String)object2);
                        }
                    }
                    if ((object2 = ((BridgeConfiguration)object).getHistoricalValues(parameter.getName())) == null) continue;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (parameter.getType() == Parameter.Type.PASSWORD) {
                            string = Encryption.decrypt(string);
                        }
                        if (!parameter.isPossibleValue(string)) continue;
                        parameter.addHistoricalValue(string);
                    }
                }
            }
            if (this.oemCode != OEMCode.MIR_WEB) {
                object = parameters.iterator();
                while (object.hasNext()) {
                    if (!((Parameter)object.next()).isHidden()) continue;
                    object.remove();
                }
            }
            object = new BridgeInformationResponse();
            ((BridgeInformationResponse)object).setBridgeId(this.bridgeId);
            ((BridgeInformationResponse)object).setBridgeDisplayName(this.bridgeDisplayName);
            ((BridgeInformationResponse)object).setIsExport(this.isExport);
            ((BridgeInformationResponse)object).setSpecification(bridgeSpecification);
            ((BridgeInformationResponse)object).setParameters(parameters);
            ((Response)object).setLanguage(this.language);
            ((Response)object).setUserIdentity(this.userIdentity);
            this.response = object;
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(mIRLogger, throwable, throwable.getMessage());
            this.result = MimbExecutable.MIMBReturnCode.ERROR_EXE;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
            return;
        }
        finally {
            this.bridgeLoader.unloadBridge(this.bridgeInterface);
        }
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS_BRIDGE_INFORMATION;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
    }
}

