/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.MIRModelBridgeInterface;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.converter.MIRBiModelConverter;
import MITI.converter.MIRErModelConverter;
import MITI.converter.MIRErMultiModelConverter;
import MITI.converter.MIRExcelModelConverter;
import MITI.converter.MIRModelConverter;
import MITI.converter.MIRMultiModelConverter;
import MITI.converter.MIRNoModelConverter;
import MITI.converter.etl.MIREtlModelConverter;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.configuration.Configuration;
import MITI.mimb.executable.configuration.MIMBConfiguration;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.Encryption;
import MITI.util.MachineInfo;
import MITI.util.VersionInfo;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ExportAction
extends Action {
    private String bridgeId;
    private String bridgeDisplayName;
    private MIRValidationLevel.Enum validationLevel;
    private String language;
    private String logLevel;

    public ExportAction(BridgeLoader bridgeLoader, MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, BridgeRunRequest bridgeRunRequest, MIRValidationLevel.Enum enum_, String string, String string2, OEMCode oEMCode) {
        super(bridgeLoader, mIRSetup, mIRModelBridges, bridgeRunRequest.getUserIdentity(), oEMCode);
        this.bridgeId = bridgeRunRequest.getBridgeId();
        this.bridgeDisplayName = bridgeRunRequest.getBridgeDisplayName();
        this.userOptions = bridgeRunRequest.getUserOptions();
        this.vaultOptions = bridgeRunRequest.getVaultOptions();
        this.disableLog = bridgeRunRequest.getDisablelog();
        this.validationLevel = enum_;
        this.logLevel = string;
        this.language = string2;
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public String getBridgeDisplayName() {
        return this.bridgeDisplayName;
    }

    public void setBridgeDisplayName(String string) {
        this.bridgeDisplayName = string;
    }

    public BridgeSpecificationLiteral getBridgeSpec() {
        return MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Object object2;
        MimbOption mimbOption;
        Object object3;
        MIRLogger mIRLogger = MIRLogger.getLogger();
        try {
            MimbOption mimbOption22;
            object3 = this.modelBridges.loadBridgeLibrary(this.bridgeId, true);
            if (object3 == null) {
                MIMB.TOOL_EXPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return;
            }
            if (this.bridgeDisplayName.isEmpty()) {
                this.bridgeDisplayName = object3.getDisplayName();
            }
            String string = "";
            mimbOption = this.userOptions.getOption("Connection");
            if (mimbOption != null) {
                string = mimbOption.getValue();
            }
            if ((object2 = this.getConverter((BridgeSpecificationLiteral)(object = MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)true)))) != null) {
                object2.setSubsetValue(string);
                if (!object2.run(this.dir)) {
                    MIMB.GENERAL_ERROR.log(mIRLogger, "Failed to convert model");
                    this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                    this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                    return;
                }
            } else {
                MIMB.DBG_NO_CONVERTER.log(mIRLogger, new Object[0]);
            }
            this.bridgeInterface = this.bridgeLoader.loadBridge(this.bridgeId, true);
            if (this.bridgeInterface == null) {
                if (MachineInfo.isWindows()) {
                    String string2;
                    BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
                    bridgeRunRequest.setUserIdentity(this.userIdentity);
                    bridgeRunRequest.setLanguage("");
                    bridgeRunRequest.setBridgeId("MetaIntegrationMultiModelXml");
                    bridgeRunRequest.setBridgeDisplayName("MIMB Intermediate Step");
                    MimbOptions mimbOptions = new MimbOptions();
                    mimbOptions.addOption("Directory", this.dir.getPath(), "");
                    bridgeRunRequest.setUserOptions(mimbOptions);
                    bridgeRunRequest.setDisableLog(true);
                    BridgeRunRequest bridgeRunRequest2 = new BridgeRunRequest();
                    bridgeRunRequest2.setUserIdentity(this.userIdentity);
                    bridgeRunRequest2.setLanguage("");
                    bridgeRunRequest2.setBridgeId(this.bridgeId);
                    bridgeRunRequest2.setBridgeDisplayName(this.bridgeDisplayName);
                    bridgeRunRequest2.setUserOptions(this.userOptions);
                    bridgeRunRequest2.setDisableLog(this.disableLog);
                    RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
                    runMimbExtendedRequest.setUserIdentity(this.userIdentity);
                    runMimbExtendedRequest.setLanguage(this.language);
                    runMimbExtendedRequest.setImportRequest(bridgeRunRequest);
                    runMimbExtendedRequest.setExportRequest(bridgeRunRequest2);
                    runMimbExtendedRequest.setValidationLevel(this.validationLevel);
                    runMimbExtendedRequest.setCommandLineFile("");
                    runMimbExtendedRequest.setLogLevel(this.logLevel);
                    String string3 = runMimbExtendedRequest.toString();
                    MimbUtf8PrintStream mimbUtf8PrintStream = new MimbUtf8PrintStream((OutputStream)new MimbMessageLogOutputStream(mIRLogger));
                    try {
                        string2 = MIRModelBridgeInterface.execute((String)string3, (String)this.language, (PrintStream)mimbUtf8PrintStream, (MIRSetup)this.setup, (String)this.getOemToken());
                    }
                    catch (IOException iOException) {
                        BLIB.DBG_DEBUG.log(mIRLogger, iOException, iOException.toString());
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                        this.bridgeLoader.unloadBridge(this.bridgeInterface);
                        return;
                    }
                    this.response = Response.parse(string2, mIRLogger);
                    if (this.response == null) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                        return;
                    }
                    if (this.response instanceof ErrorResponse) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                        return;
                    }
                    this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
                    return;
                }
                MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(mIRLogger, this.bridgeId, MachineInfo.getOperatingSystemName());
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return;
            }
            if (this.isMIMBIntermediateStep(this.bridgeId, this.bridgeDisplayName)) {
                File file = MIRMixManager.getMultiModelFile(this.dir);
                if (file.exists()) {
                    MimbOption mimbOption3 = this.userOptions.getOption("Directory");
                    if (mimbOption3 == null) {
                        MIMB.GENERAL_ERROR.log(mIRLogger, "Directory parameter is not set");
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                        return;
                    }
                    File file2 = new File(mimbOption3.getValue());
                    boolean bl = FileUtil.move(this.dir, file2);
                    if (!bl) {
                        BLIB.DBG_ERROR_COPYING_FILE.log(mIRLogger, this.dir.getPath(), file2.getPath());
                    }
                    this.dir = file2;
                } else {
                    File file3;
                    File file4;
                    MimbOption mimbOption4 = this.userOptions.getOption("File");
                    if (mimbOption4 == null) {
                        mimbOption4 = this.userOptions.getOption("Directory");
                        if (mimbOption4 == null) {
                            MIMB.GENERAL_ERROR.log(mIRLogger, "File parameter is not set");
                            this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                            return;
                        }
                        file4 = new File(mimbOption4.getValue());
                        file3 = new File(file4, "model.xml");
                        mimbOption4.setValue(file3.getPath());
                    }
                    file4 = MIRMixManager.getModelFile(this.dir);
                    file3 = new File(mimbOption4.getValue());
                    MIMB.DBG_MOVING_FILES.log(mIRLogger, file4.getPath(), file3.getPath());
                    boolean bl = FileUtil.move(file4, file3);
                    if (!bl) {
                        BLIB.DBG_ERROR_COPYING_FILE.log(mIRLogger, file4.getPath(), file3.getPath());
                    }
                }
                this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
                return;
            }
            this.getBridgeOptions(this.bridgeId, true, mIRLogger);
            for (MimbOption mimbOption22 : this.userOptions) {
                this.setBridgeOption(mimbOption22);
            }
            if (!this.checkMandatoryOptions(true)) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return;
            }
            if (!this.testRequiredInputFiles(true, mIRLogger)) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return;
            }
            VersionInfo versionInfo = VersionInfo.loadMitiJar(this.bridgeInterface.getClass());
            this.displayBridgeInfo(this.bridgeParameters, this.bridgeId, this.bridgeDisplayName, true, (BridgeSpecificationLiteral)object, versionInfo, mIRLogger);
            this.processJavaOptions();
            MIMB.CALLING_RUN_METHOD.log(mIRLogger, new Object[0]);
            mimbOption22 = new BridgeEnvironment(this.setup, this.getOemToken(), MIRValidationLevel.NONE);
            boolean bl = this.bridgeInterface.run(this.bridgeId, this.dir, this.bridgeOptions, (BridgeEnvironment)mimbOption22, mIRLogger);
            if (!bl) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
                return;
            }
            MIMB.TOOL_MODEL_EXPORTED.log(mIRLogger, this.getCurrentDate());
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(mIRLogger, throwable, throwable.getMessage());
            this.result = MimbExecutable.MIMBReturnCode.ERROR_EXPORT;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_EXPORT);
            return;
        }
        finally {
            this.bridgeLoader.unloadBridge(this.bridgeInterface);
        }
        if (!this.userIdentity.isEmpty() && !this.bridgeDisplayName.equals("MIMB Intermediate Step")) {
            for (String string : this.bridgeOptions) {
                mimbOption = string.getParameter();
                if (mimbOption == null || this.config.isHidden((String)(object = string.getName()))) continue;
                object2 = string.getValue();
                if (mimbOption.getType() == Parameter.Type.PASSWORD) {
                    object2 = Encryption.encrypt(string.getValue());
                } else if (!(mimbOption.getType() != Parameter.Type.FILE && mimbOption.getType() != Parameter.Type.DIRECTORY || string.getClientSpecifiedText().isEmpty())) {
                    object2 = string.getClientSpecifiedText();
                }
                this.config.setHistoricalValue((String)object, (String)object2);
            }
            this.config.save();
            if (!this.bridgeDisplayName.isEmpty()) {
                object3 = new MIMBConfiguration(this.userIdentity);
                ((MIMBConfiguration)object3).loadMIMBConfiguration(mIRLogger, this.setup.getDataHistoryDirectory());
                ((MIMBConfiguration)object3).setImportBridge(this.bridgeDisplayName);
                ((Configuration)object3).save();
            }
        }
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
    }

    private MIRModelConverter getConverter(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
        Object object = null;
        if (bridgeSpecificationLiteral != null) {
            object = bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Business Intelligence") ? new MIRBiModelConverter() : (bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Data Integration") ? (bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel() ? new MIREtlModelConverter() : new MIRErModelConverter()) : (bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Metadata Management") ? (bridgeSpecificationLiteral.getTool_Name().equals("Metadata Excel Format") ? new MIRExcelModelConverter() : (bridgeSpecificationLiteral.getBridge_Id().equals("MicrosoftAzureDataCatalog") || bridgeSpecificationLiteral.getBridge_Id().equals("ApacheAtlas") ? new MIRNoModelConverter() : (bridgeSpecificationLiteral.getVendor_Id().equals("MITI") ? new MIRNoModelConverter() : (bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel() ? new MIRMultiModelConverter() : new MIRErModelConverter())))) : (bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel() ? new MIRErMultiModelConverter() : new MIRErModelConverter())));
        }
        return object;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
        ExportAction.printCommandLineComment(stringBuilder, "Defines the export bridge and its parameters");
        stringBuilder.append("\n");
        ExportAction.printCommandLineAdd(stringBuilder, "export");
        stringBuilder.append("-e ").append(this.bridgeId).append("\n");
        for (MimbOption mimbOption : this.userOptions) {
            String string = mimbOption.getName();
            String string2 = mimbOption.getValue();
            if (string.equals("File/Directory")) {
                ExportAction.printCommandLineAdd(stringBuilder, "export");
                stringBuilder.append("-t \"").append(string2).append("\" \n");
                continue;
            }
            ExportAction.printCommandLineAdd(stringBuilder, "export");
            stringBuilder.append("-p \"").append(string).append("=").append(string2).append("\" \n");
        }
        stringBuilder.append("\n");
    }
}

