/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.DataProfilerBridgeInterface;
import MITI.bridges.javabridgeinterface.DataQualityOptions;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.configuration.Configuration;
import MITI.mimb.executable.configuration.MIMBConfiguration;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.DataQualityRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.Encryption;
import MITI.util.MachineInfo;
import MITI.util.VersionInfo;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;

public class DataQualityAction
extends Action {
    private BridgeRunRequest importRequest;
    private String bridgeId;
    private String bridgeDisplayName;
    private DataQualityOptions dqOptions;

    public DataQualityAction(BridgeLoader bridgeLoader, MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, DataQualityRequest dataQualityRequest, String string, OEMCode oEMCode) {
        super(bridgeLoader, mIRSetup, mIRModelBridges, string, oEMCode);
        this.importRequest = dataQualityRequest.getImportRequest();
        this.bridgeId = this.importRequest.getBridgeId();
        this.bridgeDisplayName = this.importRequest.getBridgeDisplayName();
        this.userOptions = this.importRequest.getUserOptions();
        this.dqOptions = dataQualityRequest.getDataQualityOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        MIRLogger mIRLogger = MIRLogger.getLogger();
        try {
            object4 = this.modelBridges.loadBridgeLibrary(this.bridgeId, false);
            if (object4 == null) {
                MIMB.TOOL_IMPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            if (this.bridgeDisplayName.isEmpty()) {
                this.bridgeDisplayName = object4.getDisplayName();
            }
            this.bridgeInterface = this.bridgeLoader.loadBridge(this.bridgeId, false);
            if (this.bridgeInterface == null) {
                MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(mIRLogger, this.bridgeId, MachineInfo.getOperatingSystemName());
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
            }
            this.getBridgeOptions(this.bridgeId, false, mIRLogger);
            for (Object object32 : this.userOptions) {
                this.setBridgeOption((MimbOption)object32);
            }
            if (!this.checkMandatoryOptions(true)) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            if (!this.testRequiredInputFiles(false, mIRLogger)) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return;
            }
            Object object5 = VersionInfo.loadMitiJar(this.bridgeInterface.getClass());
            object32 = MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)false);
            this.displayBridgeInfo(this.bridgeParameters, this.bridgeId, this.bridgeDisplayName, false, (BridgeSpecificationLiteral)object32, (VersionInfo)object5, mIRLogger);
            MIMB.TOOL_BRIDGE_PARAMETER.log("Data Profiling", this.dqOptions.toString());
            object2 = new BridgeEnvironment(this.setup, this.getOemToken(), MIRValidationLevel.BASIC);
            if (this.bridgeInterface instanceof DataProfilerBridgeInterface) {
                MIMB.CALLING_DATAPROFILE_METHOD.log(mIRLogger, new Object[0]);
                object = (DataProfilerBridgeInterface)this.bridgeInterface;
                object.runDataQuality(this.bridgeId, this.bridgeOptions, object2, this.dqOptions, mIRLogger);
            } else {
                MIMB.WRN_DATAPROFILING_NOTSUPPORTED.log(new Object[0]);
            }
            MIMB.TOOL_MODEL_IMPORTED.log(mIRLogger, this.getCurrentDate());
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(mIRLogger, throwable, throwable.getMessage());
            this.result = MimbExecutable.MIMBReturnCode.ERROR_IMPORT;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
            return;
        }
        finally {
            this.bridgeLoader.unloadBridge(this.bridgeInterface);
        }
        if (!this.userIdentity.isEmpty() && !this.bridgeDisplayName.equals("MIMB Intermediate Step")) {
            for (Object object5 : this.bridgeOptions) {
                object32 = object5.getParameter();
                if (object32 == null || this.config.isHidden((String)(object2 = object5.getName()))) continue;
                object = object5.getValue();
                if (object32.getType() == Parameter.Type.PASSWORD) {
                    object = Encryption.encrypt(object5.getValue());
                } else if (!(object32.getType() != Parameter.Type.FILE && object32.getType() != Parameter.Type.DIRECTORY || object5.getClientSpecifiedText().isEmpty())) {
                    object = object5.getClientSpecifiedText();
                }
                this.config.setHistoricalValue((String)object2, (String)object);
            }
            this.config.save();
            if (!this.bridgeDisplayName.isEmpty()) {
                object4 = new MIMBConfiguration(this.userIdentity);
                ((MIMBConfiguration)object4).loadMIMBConfiguration(mIRLogger, this.setup.getDataHistoryDirectory());
                ((MIMBConfiguration)object4).setImportBridge(this.bridgeDisplayName);
                ((Configuration)object4).save();
            }
        }
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public void setBridgeId(String string) {
        this.bridgeId = string;
    }

    public String getBridgeDisplayName() {
        return this.bridgeDisplayName;
    }

    public void setBridgeDisplayName(String string) {
        this.bridgeDisplayName = string;
    }

    public DataQualityOptions getDataQualityOptions() {
        return this.dqOptions;
    }

    public void setDataQualityOptions(DataQualityOptions dataQualityOptions) {
        this.dqOptions = dataQualityOptions;
    }
}

