/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridgeInterface;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.BrowseRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.MachineInfo;
import MITI.util.VersionInfo;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class BrowseAction
extends Action {
    protected String bridgeId;
    protected String bridgeDisplayName;
    protected boolean isExport;
    private String browseParameterIdentifier;
    private File browseFile;
    private MIRValidationLevel.Enum validationLevel;
    private String logLevel;
    private String language;

    public BrowseAction(BridgeLoader bridgeLoader, MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, BrowseRequest browseRequest, MIRValidationLevel.Enum enum_, OEMCode oEMCode) {
        super(bridgeLoader, mIRSetup, mIRModelBridges, browseRequest.getUserIdentity(), oEMCode);
        this.bridgeId = browseRequest.getBridgeId();
        this.bridgeDisplayName = browseRequest.getBridgeDisplayName();
        this.isExport = browseRequest.isExport();
        this.browseParameterIdentifier = browseRequest.getBrowseParameterIdentifier();
        this.browseFile = new File(browseRequest.getBrowseFile());
        this.userOptions = browseRequest.getUserOptions();
        this.vaultOptions = browseRequest.getVaultOptions();
        this.disableLog = browseRequest.getDisablelog();
        this.validationLevel = enum_;
        this.logLevel = browseRequest.getLogLevel();
        this.language = browseRequest.getLanguage();
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public boolean isExport() {
        return this.isExport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MIRLogger mIRLogger = MIRLogger.getLogger();
        try {
            Object object2;
            BridgeLibrary bridgeLibrary = this.modelBridges.loadBridgeLibrary(this.bridgeId, this.isExport);
            if (bridgeLibrary == null) {
                if (this.isExport) {
                    MIMB.TOOL_EXPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                } else {
                    MIMB.TOOL_IMPORT_TOOL_NOT_SUPPORTED.log(mIRLogger, this.bridgeId);
                }
                this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return;
            }
            if (this.bridgeDisplayName.isEmpty()) {
                this.bridgeDisplayName = bridgeLibrary.getBridgeId();
            }
            this.bridgeInterface = this.bridgeLoader.loadBridge(this.bridgeId, this.isExport);
            if (this.bridgeInterface == null) {
                if (MachineInfo.isWindows()) {
                    String string;
                    BrowseRequest browseRequest = new BrowseRequest();
                    browseRequest.setUserIdentity(this.userIdentity);
                    browseRequest.setLanguage(this.language);
                    browseRequest.setBridgeId(this.bridgeId);
                    browseRequest.setBridgeDisplayName(this.bridgeDisplayName);
                    browseRequest.setDisableLog(this.disableLog);
                    browseRequest.setUserOptions(this.userOptions);
                    browseRequest.setIsExport(this.isExport);
                    browseRequest.setLogLevel(this.logLevel);
                    browseRequest.setBrowseFile(this.browseFile.getPath());
                    browseRequest.setBowseParameterIdentifier(this.browseParameterIdentifier);
                    browseRequest.setValidationLevel(this.validationLevel);
                    String string2 = browseRequest.toString();
                    MimbUtf8PrintStream mimbUtf8PrintStream = new MimbUtf8PrintStream((OutputStream)new MimbMessageLogOutputStream(mIRLogger));
                    try {
                        string = MIRModelBridgeInterface.execute((String)string2, (String)this.language, (PrintStream)mimbUtf8PrintStream, (MIRSetup)this.setup, (String)this.getOemToken());
                    }
                    catch (IOException iOException) {
                        BLIB.DBG_DEBUG.log(mIRLogger, iOException, iOException.toString());
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                        this.bridgeLoader.unloadBridge(this.bridgeInterface);
                        return;
                    }
                    this.response = Response.parse(string, mIRLogger);
                    if (this.response == null) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
                        this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                        return;
                    }
                    if (this.response instanceof ErrorResponse) {
                        this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
                        return;
                    }
                    this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
                    return;
                }
                MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(mIRLogger, this.bridgeId, MachineInfo.getOperatingSystemName());
                this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return;
            }
            this.getBridgeOptions(this.bridgeId, false, mIRLogger);
            for (Object object2 : this.userOptions) {
                this.setBridgeOption((MimbOption)object2);
            }
            Iterator iterator = this.bridgeOptions.getOption(this.browseParameterIdentifier);
            if (iterator == null || iterator.getParameter().getType() != Parameter.Type.REPOSITORY_MODEL && iterator.getParameter().getType() != Parameter.Type.REPOSITORY_SUBSET) {
                MIMB.TOOL_INVALID_BROWSE_PARAMETER.log(mIRLogger, this.browseParameterIdentifier);
                this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return;
            }
            if (!this.checkMandatoryOptions(false)) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return;
            }
            object2 = VersionInfo.loadMitiJar(this.bridgeInterface.getClass());
            BridgeSpecificationLiteral bridgeSpecificationLiteral = MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)this.isExport);
            this.displayBridgeInfo(this.bridgeParameters, this.bridgeId, this.bridgeDisplayName, this.isExport, bridgeSpecificationLiteral, (VersionInfo)object2, mIRLogger);
            MIMB.CALLING_BROWSE_METHOD.log(mIRLogger, this.browseParameterIdentifier);
            BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(this.setup, this.getOemToken(), MIRValidationLevel.BROWSE);
            boolean bl = this.bridgeInterface.browse(this.bridgeId, this.browseFile, this.browseParameterIdentifier, this.bridgeOptions, bridgeEnvironment, mIRLogger);
            if (!bl) {
                this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
                this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return;
            }
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(mIRLogger, throwable, throwable.getMessage());
            this.result = MimbExecutable.MIMBReturnCode.ERROR_BROWSE;
            this.response = new ErrorResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
            return;
        }
        finally {
            this.bridgeLoader.unloadBridge(this.bridgeInterface);
        }
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
    }

    @Override
    public void printCommandLine(StringBuilder stringBuilder) {
    }
}

