/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.MIRException;
import MITI.bridges.javabridgeinterface.BridgeInterface;
import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.ExportAction;
import MITI.mimb.executable.actions.ImportAction;
import MITI.mimb.executable.configuration.BridgeConfiguration;
import MITI.mimb.executable.oem.OEM;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.responses.Response;
import MITI.sdk.MIRDate;
import MITI.secretvault.MIRSecretVault;
import MITI.server.services.common.LogEvent;
import MITI.util.DateUtil;
import MITI.util.Encryption;
import MITI.util.MiscParams;
import MITI.util.VersionInfo;
import MITI.util.file.FileUtil;
import MITI.util.log.BufferedLogger;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import MITI.util.text.MessageLiteral;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public abstract class Action {
    public static final String BO_FILE = "File";
    public static final String BO_DIRECTORY = "Directory";
    public static final String BO_MISCELLANEOUS = "Miscellaneous";
    public static final String BO_FILE_DIRECTORY = "File/Directory";
    private static final String MIMB_ENCRYPTED_PASSWORD_START = "$MIMB_Encrypted_Start$";
    private static final String MIMB_ENCRYPTED_PASSWORD_END = "$MIMB_Encrypted_End$";
    protected MIRSetup setup;
    protected String userIdentity;
    protected boolean disableLog;
    protected MimbExecutable.MIMBReturnCode result;
    protected File dir;
    protected BridgeConfiguration config;
    protected BridgeInterface bridgeInterface;
    protected Parameters bridgeParameters;
    protected OEMCode oemCode;
    protected BridgeLoader bridgeLoader;
    protected MIRModelBridges modelBridges;
    protected MimbOptions userOptions = new MimbOptions();
    protected MimbOptions bridgeOptions = new MimbOptions();
    protected HashMap<String, String> vaultOptions = new HashMap();
    private MiscParams miscParams = null;
    protected Response response = null;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public Action(BridgeLoader bridgeLoader, MIRSetup mIRSetup, MIRModelBridges mIRModelBridges, String string, OEMCode oEMCode) {
        this.setup = mIRSetup;
        this.modelBridges = mIRModelBridges;
        this.userIdentity = string;
        this.oemCode = oEMCode;
        this.disableLog = false;
        this.result = MimbExecutable.MIMBReturnCode.SUCCESS;
        this.bridgeLoader = bridgeLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        MIRLogger mIRLogger = MIRLogger.getLogger();
        BufferedLogger bufferedLogger = new BufferedLogger();
        try {
            if (this.disableLog) {
                MIRLogger.setLogger(bufferedLogger);
            }
            this.run();
        }
        finally {
            if (this.disableLog && this.result.getValue() > 0) {
                for (LogEvent logEvent : bufferedLogger.getEvents()) {
                    mIRLogger.log(logEvent);
                }
                bufferedLogger.clearEvents();
            }
            MIRLogger.setLogger(mIRLogger);
        }
    }

    protected abstract void run();

    protected String getOemToken() {
        return OEM.getOemToken(this.oemCode);
    }

    public Response getResponse() {
        return this.response;
    }

    public MimbExecutable.MIMBReturnCode getResult() {
        return this.result;
    }

    public File getDirectory() {
        return this.dir;
    }

    public void setDirectory(File file) {
        this.dir = file;
    }

    public MiscParams getMiscParams() {
        return this.miscParams;
    }

    public void setMiscParams(MiscParams miscParams) {
        this.miscParams = miscParams;
    }

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public String getCurrentDate() {
        MIRDate mIRDate = MIRDate.getCurrentDate();
        long l = mIRDate.get().getTimeInMillis();
        String string = DateUtil.formatSimpleDate(l, false);
        return "<" + string + ">";
    }

    public static void printCommandLineHeader(StringBuilder stringBuilder) {
        if (isWindows) {
            stringBuilder.append("rem DOS batch file");
        } else {
            stringBuilder.append("#!/bin/sh");
        }
    }

    public static void printCommandLineIni(StringBuilder stringBuilder, String string) {
        if (isWindows) {
            stringBuilder.append("set ").append(string).append("=");
        } else {
            stringBuilder.append(string).append("=");
        }
    }

    public static void printCommandLineAdd(StringBuilder stringBuilder, String string) {
        if (isWindows) {
            stringBuilder.append("set ").append(string).append("=%").append(string).append("% ");
        } else {
            stringBuilder.append(string).append("=${").append(string).append("} ");
        }
    }

    public static void printCommandLineUse(StringBuilder stringBuilder, String string) {
        if (isWindows) {
            stringBuilder.append("%").append(string).append("%");
        } else {
            stringBuilder.append("${").append(string).append("}");
        }
    }

    public static void printCommandLineComment(StringBuilder stringBuilder, String string) {
        if (isWindows) {
            stringBuilder.append("rem ").append(string);
        } else {
            stringBuilder.append("#").append(string);
        }
    }

    public abstract void printCommandLine(StringBuilder var1);

    public static boolean isMitiBridge(String string) {
        return string.equals("MetaIntegrationXml") || string.equals("MetaIntegrationMultiModelXml") || string.equals("MetaIntegrationXmlExport.MetaIntegrationDataModelXml");
    }

    public boolean isMIMBIntermediateStep(String string, String string2) {
        if (!(this.disableLog && this.userOptions.getCount() == 1 && Action.isMitiBridge(string) && string2.equals("MIMB Intermediate Step"))) {
            return false;
        }
        return this.userOptions.getOption(BO_FILE) != null || this.userOptions.getOption(BO_DIRECTORY) != null;
    }

    protected void getBridgeOptions(String string, boolean bl, MIRLogger mIRLogger) throws MIRException {
        this.bridgeParameters = this.bridgeInterface.getParameters();
        for (Parameter parameter : this.bridgeParameters) {
            this.bridgeOptions.addOption(parameter);
        }
        if (!this.userIdentity.isEmpty()) {
            this.config = new BridgeConfiguration(this.userIdentity);
            this.config.loadBridgeConfiguration(mIRLogger, this.setup.getDataHistoryDirectory(), string, bl);
            for (Parameter parameter : this.bridgeOptions) {
                String string2;
                Parameter parameter2 = parameter.getParameter();
                if (!parameter2.isPossibleValue(string2 = this.config.getSavedValue(parameter.getName()))) continue;
                parameter.setValue(string2);
            }
        }
    }

    protected void setBridgeOption(MimbOption mimbOption) {
        String string;
        File file;
        Object object;
        String string2 = mimbOption.getName();
        String string3 = mimbOption.getValue();
        boolean bl = this instanceof ExportAction;
        MimbOption mimbOption2 = null;
        Parameter parameter = null;
        if (string2.equals(BO_FILE_DIRECTORY)) {
            mimbOption2 = this.bridgeOptions.getOption(BO_FILE);
            if (mimbOption2 == null) {
                mimbOption2 = this.bridgeOptions.getOption(BO_DIRECTORY);
            } else if (bl && !(parameter = mimbOption2.getParameter()).isPossibleValue(string3) && (object = parameter.getFileExtensions()) != null && object.size() >= 1) {
                string3 = string3 + "." + (String)object.get(0);
            }
        } else {
            mimbOption2 = this.bridgeOptions.getOption(string2);
        }
        if (mimbOption2 == null) {
            MIMB.TOOL_INVALID_BRIDGE_OPTION.log(string2);
            return;
        }
        parameter = mimbOption2.getParameter();
        if (!parameter.isPossibleValue(string3)) {
            MIMB.TOOL_INVALID_BRIDGE_OPTION_VALUE.log(string2, string3);
            if (parameter.getType() != Parameter.Type.FILE) {
                return;
            }
        }
        if (parameter.getType() == Parameter.Type.PASSWORD) {
            if (string3.startsWith(MIMB_ENCRYPTED_PASSWORD_START) && string3.endsWith(MIMB_ENCRYPTED_PASSWORD_END)) {
                object = Encryption.decrypt(Encryption.hexToBytes(string3.substring(MIMB_ENCRYPTED_PASSWORD_START.length(), string3.length() - MIMB_ENCRYPTED_PASSWORD_END.length())));
                string3 = new String((byte[])object, 8, ((Object)object).length - 8, FileUtil.UTF8);
            }
            string3 = MIRSecretVault.getSecret((MIRSetup)this.setup, (String)string3, this.vaultOptions);
        } else if (parameter.getType() == Parameter.Type.FILE) {
            object = new File(string3);
            if (((File)object).exists() && !((File)object).isFile()) {
                MIMB.TOOL_INVALID_BRIDGE_OPTION_VALUE.log(string2, string3);
            }
        } else if (parameter.getType() == Parameter.Type.DIRECTORY) {
            object = new File(string3);
            if (((File)object).exists() && !((File)object).isDirectory()) {
                MIMB.TOOL_INVALID_BRIDGE_OPTION_VALUE.log(string2, string3);
            }
        } else if ((parameter.getType() == Parameter.Type.STRING || parameter.getType() == Parameter.Type.REPOSITORY_MODEL || parameter.getType() == Parameter.Type.REPOSITORY_SUBSET) && FileUtil.isSubPath((File)(object = this.setup.getDataParamsDirectory()), string3) && (file = new File((File)object, string3)).exists() && file.isFile() && file.canRead() && (string = FileUtil.readContent(file, StandardCharsets.UTF_8)) != null) {
            string3 = string;
        }
        mimbOption2.setValue(string3);
        if (parameter.getType() == Parameter.Type.FILE || parameter.getType() == Parameter.Type.DIRECTORY) {
            mimbOption2.setClientSpecifiedText(mimbOption.getClientSpecifiedText());
        }
    }

    protected boolean checkMandatoryOptions(boolean bl) {
        boolean bl2 = true;
        for (MimbOption mimbOption : this.bridgeOptions) {
            Parameter parameter = this.bridgeParameters.getParameter(mimbOption.getName());
            if (!bl && (parameter.getType() == Parameter.Type.REPOSITORY_MODEL || parameter.getType() == Parameter.Type.REPOSITORY_SUBSET) || !parameter.isMandatory() || !mimbOption.getValue().isEmpty()) continue;
            MIMB.TOOL_INVALID_MANDATORY_OPTION.log(mimbOption.getName());
            bl2 = false;
        }
        return bl2;
    }

    protected boolean testRequiredInputFiles(boolean bl, MIRLogger mIRLogger) {
        for (MimbOption mimbOption : this.bridgeOptions) {
            File file;
            Parameter parameter = this.bridgeParameters.getParameter(mimbOption.getName());
            if (!parameter.isMandatory() || parameter.getType() != Parameter.Type.FILE && parameter.getType() != Parameter.Type.DIRECTORY) continue;
            String string = mimbOption.getValue();
            if (string.isEmpty()) {
                BLIB.ERR_MISSING_REQUIRED_FILE.log(mIRLogger, string);
                return false;
            }
            File file2 = new File(string);
            if (!bl && parameter.getOpenMode() != Parameter.OpenMode.WRITE && !file2.exists()) {
                BLIB.ERR_MISSING_REQUIRED_FILE.log(mIRLogger, string);
                return false;
            }
            if (!bl || parameter.getOpenMode() == Parameter.OpenMode.READ || parameter.getType() != Parameter.Type.FILE) continue;
            String string2 = file2.getParent();
            if (string2 != null && string2.length() > 2 && !(file = new File(string2)).exists()) {
                BLIB.ERR_MISSING_REQUIRED_FILE.log(mIRLogger, string2);
                return false;
            }
            if (!file2.exists() || file2.canWrite()) continue;
            BLIB.ERR_FILE_NOT_WRITABLE.log(mIRLogger, string);
            return false;
        }
        return true;
    }

    protected String getDisplayValue(MimbOption mimbOption, Parameter parameter) {
        String string;
        if (parameter.getType() == Parameter.Type.ENUMERATED || parameter.getType() == Parameter.Type.BOOLEAN) {
            string = parameter.getDisplayPossibleValue(mimbOption.getValue());
            if (string.isEmpty()) {
                string = mimbOption.getValue();
            }
        } else {
            string = mimbOption.getValue();
        }
        return string;
    }

    protected void displayBridgeInfo(Parameters parameters, String string, String string2, boolean bl, BridgeSpecificationLiteral bridgeSpecificationLiteral, VersionInfo versionInfo, MIRLogger mIRLogger) {
        MessageLiteral messageLiteral;
        MessageLiteral messageLiteral2;
        MessageLiteral messageLiteral3;
        if (bl) {
            messageLiteral3 = MIMB.TOOL_EXPORT_SPECIFICATION;
            messageLiteral2 = MIMB.TOOL_MODEL_EXPORT;
            messageLiteral = MIMB.TOOL_EXPORT_BRIDGE;
        } else {
            messageLiteral3 = MIMB.TOOL_IMPORT_SPECIFICATION;
            messageLiteral2 = MIMB.TOOL_MODEL_IMPORT;
            messageLiteral = MIMB.TOOL_IMPORT_BRIDGE;
        }
        messageLiteral3.log(mIRLogger, bridgeSpecificationLiteral.getVendor_Name(), bridgeSpecificationLiteral.getTool_Name(), bridgeSpecificationLiteral.getTool_Versions(), bridgeSpecificationLiteral.getTool_Web());
        messageLiteral2.log(mIRLogger, bridgeSpecificationLiteral.getMethodology_Summary(), string2, this.getCurrentDate());
        messageLiteral.log(mIRLogger, string, versionInfo != null ? versionInfo.toString() : "");
        for (MimbOption mimbOption : this.bridgeOptions) {
            Parameter parameter = parameters.getParameter(mimbOption.getName());
            String string3 = parameter.getDisplayName();
            if (!mimbOption.getName().equals(string3)) {
                string3 = string3 + " (" + mimbOption.getName() + ")";
            }
            String string4 = this.getDisplayValue(mimbOption, parameter);
            if (!mimbOption.getValue().equals(string4)) {
                string4 = string4 + " (" + mimbOption.getValue() + ")";
            }
            if (parameter.getType() == Parameter.Type.PASSWORD) {
                string4 = "******";
            } else if (!(parameter.getType() != Parameter.Type.FILE && parameter.getType() != Parameter.Type.DIRECTORY || mimbOption.getClientSpecifiedText().isEmpty())) {
                string4 = mimbOption.getClientSpecifiedText();
            }
            MIMB.TOOL_BRIDGE_PARAMETER.log(mIRLogger, string3, string4);
        }
    }

    protected void processJavaOptions() {
        MimbOption mimbOption = this.bridgeOptions.getOption(BO_MISCELLANEOUS);
        if (mimbOption != null) {
            String string;
            if (this instanceof ImportAction) {
                String string2 = mimbOption.getValue();
                if (string2 != null) {
                    this.miscParams = MiscParams.parse(string2);
                }
            } else if (this instanceof ExportAction && this.miscParams != null && (string = mimbOption.getValue()) != null) {
                MiscParams miscParams = MiscParams.parse(string);
                String string3 = this.miscParams.getValue("-java.executable");
                String string4 = this.miscParams.getValue("-java.memory");
                String string5 = miscParams.getValue("-java.executable");
                String string6 = miscParams.getValue("-java.memory");
                if (string5 == null && string6 == null) {
                    if (string3 == null || !string3.isEmpty()) {
                        // empty if block
                    }
                    if (string4 != null && !string4.isEmpty()) {
                        miscParams.addValue("-java.memory", string4);
                    }
                    String string7 = miscParams.toString();
                    mimbOption.setValue(string7);
                }
            }
        }
    }
}

